/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.runtime;

import com.amazonaws.services.kinesisanalytics.runtime.models.PropertyGroup;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

public class KinesisAnalyticsRuntime {
    public static Map<String, Properties> getApplicationProperties() throws IOException {
        Properties configProperties = KinesisAnalyticsRuntime.getConfigProperties();
        return KinesisAnalyticsRuntime.getApplicationProperties(configProperties.getProperty("application_properties_file"));
    }

    public static Map<String, Properties> getApplicationProperties(String filename) throws IOException {
        HashMap<String, Properties> appProperties = new HashMap<String, Properties>();
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode root = mapper.readTree((InputStream)new FileInputStream(filename));
            for (JsonNode elem : root) {
                PropertyGroup propertyGroup = (PropertyGroup)mapper.treeToValue((TreeNode)elem, PropertyGroup.class);
                Properties properties = new Properties();
                properties.putAll(propertyGroup.properties);
                appProperties.put(propertyGroup.groupID, properties);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return appProperties;
    }

    @VisibleForTesting
    static Properties getConfigProperties() throws IOException {
        InputStream configPropertiesStream = KinesisAnalyticsRuntime.class.getClassLoader().getResourceAsStream("config.properties");
        if (configPropertiesStream == null) {
            throw new FileNotFoundException("config.properties");
        }
        Properties configProperties = new Properties();
        configProperties.load(configPropertiesStream);
        return configProperties;
    }
}

