/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.events;

import java.util.List;
import java.util.Map;

public class CloudWatchMetricAlarmEvent {
    private String source;
    private String alarmArn;
    private String accountId;
    private String time;
    private String region;
    private AlarmData alarmData;

    public static CloudWatchMetricAlarmEventBuilder builder() {
        return new CloudWatchMetricAlarmEventBuilder();
    }

    public String getSource() {
        return this.source;
    }

    public String getAlarmArn() {
        return this.alarmArn;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getTime() {
        return this.time;
    }

    public String getRegion() {
        return this.region;
    }

    public AlarmData getAlarmData() {
        return this.alarmData;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setAlarmArn(String alarmArn) {
        this.alarmArn = alarmArn;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setAlarmData(AlarmData alarmData) {
        this.alarmData = alarmData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudWatchMetricAlarmEvent)) {
            return false;
        }
        CloudWatchMetricAlarmEvent other = (CloudWatchMetricAlarmEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$alarmArn = this.getAlarmArn();
        String other$alarmArn = other.getAlarmArn();
        if (this$alarmArn == null ? other$alarmArn != null : !this$alarmArn.equals(other$alarmArn)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$time = this.getTime();
        String other$time = other.getTime();
        if (this$time == null ? other$time != null : !this$time.equals(other$time)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        AlarmData this$alarmData = this.getAlarmData();
        AlarmData other$alarmData = other.getAlarmData();
        return !(this$alarmData == null ? other$alarmData != null : !((Object)this$alarmData).equals(other$alarmData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CloudWatchMetricAlarmEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $alarmArn = this.getAlarmArn();
        result = result * 59 + ($alarmArn == null ? 43 : $alarmArn.hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : $time.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        AlarmData $alarmData = this.getAlarmData();
        result = result * 59 + ($alarmData == null ? 43 : ((Object)$alarmData).hashCode());
        return result;
    }

    public String toString() {
        return "CloudWatchMetricAlarmEvent(source=" + this.getSource() + ", alarmArn=" + this.getAlarmArn() + ", accountId=" + this.getAccountId() + ", time=" + this.getTime() + ", region=" + this.getRegion() + ", alarmData=" + this.getAlarmData() + ")";
    }

    public CloudWatchMetricAlarmEvent() {
    }

    public CloudWatchMetricAlarmEvent(String source, String alarmArn, String accountId, String time, String region, AlarmData alarmData) {
        this.source = source;
        this.alarmArn = alarmArn;
        this.accountId = accountId;
        this.time = time;
        this.region = region;
        this.alarmData = alarmData;
    }

    public static class CloudWatchMetricAlarmEventBuilder {
        private String source;
        private String alarmArn;
        private String accountId;
        private String time;
        private String region;
        private AlarmData alarmData;

        CloudWatchMetricAlarmEventBuilder() {
        }

        public CloudWatchMetricAlarmEventBuilder withSource(String source) {
            this.source = source;
            return this;
        }

        public CloudWatchMetricAlarmEventBuilder withAlarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
            return this;
        }

        public CloudWatchMetricAlarmEventBuilder withAccountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public CloudWatchMetricAlarmEventBuilder withTime(String time) {
            this.time = time;
            return this;
        }

        public CloudWatchMetricAlarmEventBuilder withRegion(String region) {
            this.region = region;
            return this;
        }

        public CloudWatchMetricAlarmEventBuilder withAlarmData(AlarmData alarmData) {
            this.alarmData = alarmData;
            return this;
        }

        public CloudWatchMetricAlarmEvent build() {
            return new CloudWatchMetricAlarmEvent(this.source, this.alarmArn, this.accountId, this.time, this.region, this.alarmData);
        }

        public String toString() {
            return "CloudWatchMetricAlarmEvent.CloudWatchMetricAlarmEventBuilder(source=" + this.source + ", alarmArn=" + this.alarmArn + ", accountId=" + this.accountId + ", time=" + this.time + ", region=" + this.region + ", alarmData=" + this.alarmData + ")";
        }
    }

    public static class MetricDetail {
        private String namespace;
        private String name;
        private Map<String, String> dimensions;

        public static MetricDetailBuilder builder() {
            return new MetricDetailBuilder();
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getDimensions() {
            return this.dimensions;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDimensions(Map<String, String> dimensions) {
            this.dimensions = dimensions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetricDetail)) {
                return false;
            }
            MetricDetail other = (MetricDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, String> this$dimensions = this.getDimensions();
            Map<String, String> other$dimensions = other.getDimensions();
            return !(this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetricDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, String> $dimensions = this.getDimensions();
            result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
            return result;
        }

        public String toString() {
            return "CloudWatchMetricAlarmEvent.MetricDetail(namespace=" + this.getNamespace() + ", name=" + this.getName() + ", dimensions=" + this.getDimensions() + ")";
        }

        public MetricDetail() {
        }

        public MetricDetail(String namespace, String name, Map<String, String> dimensions) {
            this.namespace = namespace;
            this.name = name;
            this.dimensions = dimensions;
        }

        public static class MetricDetailBuilder {
            private String namespace;
            private String name;
            private Map<String, String> dimensions;

            MetricDetailBuilder() {
            }

            public MetricDetailBuilder withNamespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public MetricDetailBuilder withName(String name) {
                this.name = name;
                return this;
            }

            public MetricDetailBuilder withDimensions(Map<String, String> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public MetricDetail build() {
                return new MetricDetail(this.namespace, this.name, this.dimensions);
            }

            public String toString() {
                return "CloudWatchMetricAlarmEvent.MetricDetail.MetricDetailBuilder(namespace=" + this.namespace + ", name=" + this.name + ", dimensions=" + this.dimensions + ")";
            }
        }
    }

    public static class MetricStat {
        private MetricDetail metric;
        private Integer period;
        private String stat;
        private String unit;

        public static MetricStatBuilder builder() {
            return new MetricStatBuilder();
        }

        public MetricDetail getMetric() {
            return this.metric;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public String getStat() {
            return this.stat;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setMetric(MetricDetail metric) {
            this.metric = metric;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }

        public void setStat(String stat) {
            this.stat = stat;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetricStat)) {
                return false;
            }
            MetricStat other = (MetricStat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$period = this.getPeriod();
            Integer other$period = other.getPeriod();
            if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
                return false;
            }
            MetricDetail this$metric = this.getMetric();
            MetricDetail other$metric = other.getMetric();
            if (this$metric == null ? other$metric != null : !((Object)this$metric).equals(other$metric)) {
                return false;
            }
            String this$stat = this.getStat();
            String other$stat = other.getStat();
            if (this$stat == null ? other$stat != null : !this$stat.equals(other$stat)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetricStat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $period = this.getPeriod();
            result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
            MetricDetail $metric = this.getMetric();
            result = result * 59 + ($metric == null ? 43 : ((Object)$metric).hashCode());
            String $stat = this.getStat();
            result = result * 59 + ($stat == null ? 43 : $stat.hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            return result;
        }

        public String toString() {
            return "CloudWatchMetricAlarmEvent.MetricStat(metric=" + this.getMetric() + ", period=" + this.getPeriod() + ", stat=" + this.getStat() + ", unit=" + this.getUnit() + ")";
        }

        public MetricStat() {
        }

        public MetricStat(MetricDetail metric, Integer period, String stat, String unit) {
            this.metric = metric;
            this.period = period;
            this.stat = stat;
            this.unit = unit;
        }

        public static class MetricStatBuilder {
            private MetricDetail metric;
            private Integer period;
            private String stat;
            private String unit;

            MetricStatBuilder() {
            }

            public MetricStatBuilder withMetric(MetricDetail metric) {
                this.metric = metric;
                return this;
            }

            public MetricStatBuilder withPeriod(Integer period) {
                this.period = period;
                return this;
            }

            public MetricStatBuilder withStat(String stat) {
                this.stat = stat;
                return this;
            }

            public MetricStatBuilder withUnit(String unit) {
                this.unit = unit;
                return this;
            }

            public MetricStat build() {
                return new MetricStat(this.metric, this.period, this.stat, this.unit);
            }

            public String toString() {
                return "CloudWatchMetricAlarmEvent.MetricStat.MetricStatBuilder(metric=" + this.metric + ", period=" + this.period + ", stat=" + this.stat + ", unit=" + this.unit + ")";
            }
        }
    }

    public static class Metric {
        private String id;
        private MetricStat metricStat;
        private Boolean returnData;

        public static MetricBuilder builder() {
            return new MetricBuilder();
        }

        public String getId() {
            return this.id;
        }

        public MetricStat getMetricStat() {
            return this.metricStat;
        }

        public Boolean getReturnData() {
            return this.returnData;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setMetricStat(MetricStat metricStat) {
            this.metricStat = metricStat;
        }

        public void setReturnData(Boolean returnData) {
            this.returnData = returnData;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$returnData = this.getReturnData();
            Boolean other$returnData = other.getReturnData();
            if (this$returnData == null ? other$returnData != null : !((Object)this$returnData).equals(other$returnData)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            MetricStat this$metricStat = this.getMetricStat();
            MetricStat other$metricStat = other.getMetricStat();
            return !(this$metricStat == null ? other$metricStat != null : !((Object)this$metricStat).equals(other$metricStat));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Metric;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $returnData = this.getReturnData();
            result = result * 59 + ($returnData == null ? 43 : ((Object)$returnData).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            MetricStat $metricStat = this.getMetricStat();
            result = result * 59 + ($metricStat == null ? 43 : ((Object)$metricStat).hashCode());
            return result;
        }

        public String toString() {
            return "CloudWatchMetricAlarmEvent.Metric(id=" + this.getId() + ", metricStat=" + this.getMetricStat() + ", returnData=" + this.getReturnData() + ")";
        }

        public Metric() {
        }

        public Metric(String id, MetricStat metricStat, Boolean returnData) {
            this.id = id;
            this.metricStat = metricStat;
            this.returnData = returnData;
        }

        public static class MetricBuilder {
            private String id;
            private MetricStat metricStat;
            private Boolean returnData;

            MetricBuilder() {
            }

            public MetricBuilder withId(String id) {
                this.id = id;
                return this;
            }

            public MetricBuilder withMetricStat(MetricStat metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            public MetricBuilder withReturnData(Boolean returnData) {
                this.returnData = returnData;
                return this;
            }

            public Metric build() {
                return new Metric(this.id, this.metricStat, this.returnData);
            }

            public String toString() {
                return "CloudWatchMetricAlarmEvent.Metric.MetricBuilder(id=" + this.id + ", metricStat=" + this.metricStat + ", returnData=" + this.returnData + ")";
            }
        }
    }

    public static class Configuration {
        private String description;
        private List<Metric> metrics;

        public static ConfigurationBuilder builder() {
            return new ConfigurationBuilder();
        }

        public String getDescription() {
            return this.description;
        }

        public List<Metric> getMetrics() {
            return this.metrics;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setMetrics(List<Metric> metrics) {
            this.metrics = metrics;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            List<Metric> this$metrics = this.getMetrics();
            List<Metric> other$metrics = other.getMetrics();
            return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Configuration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            List<Metric> $metrics = this.getMetrics();
            result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
            return result;
        }

        public String toString() {
            return "CloudWatchMetricAlarmEvent.Configuration(description=" + this.getDescription() + ", metrics=" + this.getMetrics() + ")";
        }

        public Configuration() {
        }

        public Configuration(String description, List<Metric> metrics) {
            this.description = description;
            this.metrics = metrics;
        }

        public static class ConfigurationBuilder {
            private String description;
            private List<Metric> metrics;

            ConfigurationBuilder() {
            }

            public ConfigurationBuilder withDescription(String description) {
                this.description = description;
                return this;
            }

            public ConfigurationBuilder withMetrics(List<Metric> metrics) {
                this.metrics = metrics;
                return this;
            }

            public Configuration build() {
                return new Configuration(this.description, this.metrics);
            }

            public String toString() {
                return "CloudWatchMetricAlarmEvent.Configuration.ConfigurationBuilder(description=" + this.description + ", metrics=" + this.metrics + ")";
            }
        }
    }

    public static class PreviousState {
        private String value;
        private String reason;
        private String reasonData;
        private String timestamp;

        public static PreviousStateBuilder builder() {
            return new PreviousStateBuilder();
        }

        public String getValue() {
            return this.value;
        }

        public String getReason() {
            return this.reason;
        }

        public String getReasonData() {
            return this.reasonData;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void setReasonData(String reasonData) {
            this.reasonData = reasonData;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PreviousState)) {
                return false;
            }
            PreviousState other = (PreviousState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                return false;
            }
            String this$reasonData = this.getReasonData();
            String other$reasonData = other.getReasonData();
            if (this$reasonData == null ? other$reasonData != null : !this$reasonData.equals(other$reasonData)) {
                return false;
            }
            String this$timestamp = this.getTimestamp();
            String other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PreviousState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            String $reasonData = this.getReasonData();
            result = result * 59 + ($reasonData == null ? 43 : $reasonData.hashCode());
            String $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            return result;
        }

        public String toString() {
            return "CloudWatchMetricAlarmEvent.PreviousState(value=" + this.getValue() + ", reason=" + this.getReason() + ", reasonData=" + this.getReasonData() + ", timestamp=" + this.getTimestamp() + ")";
        }

        public PreviousState() {
        }

        public PreviousState(String value, String reason, String reasonData, String timestamp) {
            this.value = value;
            this.reason = reason;
            this.reasonData = reasonData;
            this.timestamp = timestamp;
        }

        public static class PreviousStateBuilder {
            private String value;
            private String reason;
            private String reasonData;
            private String timestamp;

            PreviousStateBuilder() {
            }

            public PreviousStateBuilder withValue(String value) {
                this.value = value;
                return this;
            }

            public PreviousStateBuilder withReason(String reason) {
                this.reason = reason;
                return this;
            }

            public PreviousStateBuilder withReasonData(String reasonData) {
                this.reasonData = reasonData;
                return this;
            }

            public PreviousStateBuilder withTimestamp(String timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public PreviousState build() {
                return new PreviousState(this.value, this.reason, this.reasonData, this.timestamp);
            }

            public String toString() {
                return "CloudWatchMetricAlarmEvent.PreviousState.PreviousStateBuilder(value=" + this.value + ", reason=" + this.reason + ", reasonData=" + this.reasonData + ", timestamp=" + this.timestamp + ")";
            }
        }
    }

    public static class State {
        private String value;
        private String reason;
        private String timestamp;

        public static StateBuilder builder() {
            return new StateBuilder();
        }

        public String getValue() {
            return this.value;
        }

        public String getReason() {
            return this.reason;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                return false;
            }
            String this$timestamp = this.getTimestamp();
            String other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof State;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            String $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            return result;
        }

        public String toString() {
            return "CloudWatchMetricAlarmEvent.State(value=" + this.getValue() + ", reason=" + this.getReason() + ", timestamp=" + this.getTimestamp() + ")";
        }

        public State() {
        }

        public State(String value, String reason, String timestamp) {
            this.value = value;
            this.reason = reason;
            this.timestamp = timestamp;
        }

        public static class StateBuilder {
            private String value;
            private String reason;
            private String timestamp;

            StateBuilder() {
            }

            public StateBuilder withValue(String value) {
                this.value = value;
                return this;
            }

            public StateBuilder withReason(String reason) {
                this.reason = reason;
                return this;
            }

            public StateBuilder withTimestamp(String timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public State build() {
                return new State(this.value, this.reason, this.timestamp);
            }

            public String toString() {
                return "CloudWatchMetricAlarmEvent.State.StateBuilder(value=" + this.value + ", reason=" + this.reason + ", timestamp=" + this.timestamp + ")";
            }
        }
    }

    public static class AlarmData {
        private String alarmName;
        private State state;
        private PreviousState previousState;
        private Configuration configuration;

        public static AlarmDataBuilder builder() {
            return new AlarmDataBuilder();
        }

        public String getAlarmName() {
            return this.alarmName;
        }

        public State getState() {
            return this.state;
        }

        public PreviousState getPreviousState() {
            return this.previousState;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public void setState(State state) {
            this.state = state;
        }

        public void setPreviousState(PreviousState previousState) {
            this.previousState = previousState;
        }

        public void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlarmData)) {
                return false;
            }
            AlarmData other = (AlarmData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$alarmName = this.getAlarmName();
            String other$alarmName = other.getAlarmName();
            if (this$alarmName == null ? other$alarmName != null : !this$alarmName.equals(other$alarmName)) {
                return false;
            }
            State this$state = this.getState();
            State other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
                return false;
            }
            PreviousState this$previousState = this.getPreviousState();
            PreviousState other$previousState = other.getPreviousState();
            if (this$previousState == null ? other$previousState != null : !((Object)this$previousState).equals(other$previousState)) {
                return false;
            }
            Configuration this$configuration = this.getConfiguration();
            Configuration other$configuration = other.getConfiguration();
            return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AlarmData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $alarmName = this.getAlarmName();
            result = result * 59 + ($alarmName == null ? 43 : $alarmName.hashCode());
            State $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
            PreviousState $previousState = this.getPreviousState();
            result = result * 59 + ($previousState == null ? 43 : ((Object)$previousState).hashCode());
            Configuration $configuration = this.getConfiguration();
            result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
            return result;
        }

        public String toString() {
            return "CloudWatchMetricAlarmEvent.AlarmData(alarmName=" + this.getAlarmName() + ", state=" + this.getState() + ", previousState=" + this.getPreviousState() + ", configuration=" + this.getConfiguration() + ")";
        }

        public AlarmData() {
        }

        public AlarmData(String alarmName, State state, PreviousState previousState, Configuration configuration) {
            this.alarmName = alarmName;
            this.state = state;
            this.previousState = previousState;
            this.configuration = configuration;
        }

        public static class AlarmDataBuilder {
            private String alarmName;
            private State state;
            private PreviousState previousState;
            private Configuration configuration;

            AlarmDataBuilder() {
            }

            public AlarmDataBuilder withAlarmName(String alarmName) {
                this.alarmName = alarmName;
                return this;
            }

            public AlarmDataBuilder withState(State state) {
                this.state = state;
                return this;
            }

            public AlarmDataBuilder withPreviousState(PreviousState previousState) {
                this.previousState = previousState;
                return this;
            }

            public AlarmDataBuilder withConfiguration(Configuration configuration) {
                this.configuration = configuration;
                return this;
            }

            public AlarmData build() {
                return new AlarmData(this.alarmName, this.state, this.previousState, this.configuration);
            }

            public String toString() {
                return "CloudWatchMetricAlarmEvent.AlarmData.AlarmDataBuilder(alarmName=" + this.alarmName + ", state=" + this.state + ", previousState=" + this.previousState + ", configuration=" + this.configuration + ")";
            }
        }
    }
}

