/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.tests;

import com.amazonaws.services.lambda.runtime.tests.EventLoader;
import com.amazonaws.services.lambda.runtime.tests.annotations.Events;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

public class EventsArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<Events> {
    private Events events;

    public void accept(Events events) {
        this.events = events;
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        if (ArrayUtils.isNotEmpty((Object[])this.events.events())) {
            return Arrays.stream(this.events.events()).map(event -> {
                Class<?> clazz = event.type() == Void.class ? this.events.type() : event.type();
                return Arguments.of((Object[])new Object[]{EventLoader.loadEvent(event.value(), clazz)});
            });
        }
        URL folderUrl = this.getClass().getResource(this.events.folder());
        if (folderUrl == null) {
            folderUrl = this.getClass().getClassLoader().getResource(this.events.folder());
        }
        if (folderUrl == null) {
            throw new IllegalArgumentException("Path " + this.events.folder() + " cannot be found");
        }
        Stream<Path> files = Files.list(Paths.get(folderUrl.toURI())).sorted();
        return files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> Arguments.of((Object[])new Object[]{EventLoader.loadEvent(path.toString(), this.events.type())}));
    }
}

