/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor;

import com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor.ProcessorUtils;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.common.SharedProcessorUtils;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Activities;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.ActivityMethod;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Method;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.MethodParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivitiesDeclarationVisitor
extends ElementScanner6<Void, ProcessingEnvironment> {
    private Set<DeclaredType> annotationsToExcludeFromCopying;
    private final Activities activitiesDefinition;
    private Activities parentActivities;

    public ActivitiesDeclarationVisitor(ProcessingEnvironment processingEnv, TypeElement activities, DeclaredType activitiesAnnotationType, Set<DeclaredType> annotationsToExcludeFromCopying) {
        this.annotationsToExcludeFromCopying = annotationsToExcludeFromCopying;
        String prefix = ProcessorUtils.getActivitiesNamePrefix(activities);
        String version = ProcessorUtils.getActivitiesVersion(activities);
        String dataConverter = ProcessorUtils.getActivitiesDataConverter(processingEnv, activities, activitiesAnnotationType);
        String interfaceName = activities.getSimpleName().toString();
        String qualifiedName = activities.toString();
        this.activitiesDefinition = new Activities(prefix, version, dataConverter, interfaceName, qualifiedName);
        List<Activities> superTypes = ProcessorUtils.getAllSuperActivities(processingEnv, activities, activitiesAnnotationType, annotationsToExcludeFromCopying);
        this.activitiesDefinition.setSuperTypes(superTypes);
        this.parentActivities = SharedProcessorUtils.getParentActivities(this.activitiesDefinition);
    }

    public Activities getActivitiesDefinition() {
        return this.activitiesDefinition;
    }

    @Override
    public Void visitExecutable(ExecutableElement method, ProcessingEnvironment env) {
        String prefix = this.activitiesDefinition.getPrefix();
        String version = this.activitiesDefinition.getVersion();
        if (this.parentActivities != null) {
            if (prefix == null || prefix.isEmpty()) {
                prefix = this.parentActivities.getPrefix();
            }
            if (version == null || version.isEmpty()) {
                version = this.parentActivities.getVersion();
            }
        }
        String activityName = ProcessorUtils.computeActivityName(prefix, this.activitiesDefinition.getInterfaceName(), method);
        String activityVersion = ProcessorUtils.computeActivityVersion(version, method);
        ActivityMethod activity = new ActivityMethod(activityName, activityVersion);
        this.setMethodInfo(method, activity, this.activitiesDefinition.getPackageName());
        activity.setAnnotationsToCopy(ProcessorUtils.getAnnotationsText(env, method, this.annotationsToExcludeFromCopying));
        this.activitiesDefinition.getActivities().add(activity);
        return (Void)super.visitExecutable(method, env);
    }

    private void setMethodInfo(ExecutableElement methodDeclaration, Method method, String generatedTypePackageName) {
        method.setMethodName(methodDeclaration.getSimpleName().toString());
        TypeMirror returnType = methodDeclaration.getReturnType();
        method.setMethodReturnType(ProcessorUtils.getTypeName(returnType, generatedTypePackageName));
        method.setMethodReturnTypeNoGenerics(ProcessorUtils.getJustTypeName(returnType, generatedTypePackageName));
        method.setMethodReturnTypeUnboxed(ProcessorUtils.getTypeNameUnboxed(returnType, generatedTypePackageName));
        method.setHasGenericReturnType(ProcessorUtils.isGenericType(returnType));
        method.setPrimitiveReturnType(ProcessorUtils.isPrimitive(returnType));
        List<? extends VariableElement> parameters = methodDeclaration.getParameters();
        for (VariableElement variableElement : parameters) {
            TypeMirror typeMirror = variableElement.asType();
            String parameterTypeName = ProcessorUtils.getTypeName(typeMirror, generatedTypePackageName);
            String parameterName = variableElement.toString();
            MethodParameter methodParam = new MethodParameter(parameterName, parameterTypeName);
            methodParam.setParameterTypeUnboxed(ProcessorUtils.getTypeNameUnboxed(typeMirror, generatedTypePackageName));
            method.getMethodParameters().add(methodParam);
        }
        ArrayList<String> thrownTypes = new ArrayList<String>();
        for (TypeMirror typeMirror : methodDeclaration.getThrownTypes()) {
            thrownTypes.add(typeMirror.toString());
        }
        method.setThrownExceptions(thrownTypes);
    }
}

