/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor;

import com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor.ProcessorUtils;
import com.amazonaws.services.simpleworkflow.flow.annotations.Activities;
import com.amazonaws.services.simpleworkflow.flow.annotations.Activity;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;
import javax.tools.Diagnostic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivitiesValidator
extends ElementScanner6<Boolean, ProcessingEnvironment> {
    private boolean hasErrors = false;
    private String version;
    private String parentVersion;

    public boolean isHasErrors() {
        return this.hasErrors;
    }

    @Override
    public Boolean visitType(TypeElement e, ProcessingEnvironment p) {
        if (e.getAnnotation(Activities.class) != null) {
            if (e.getKind().isClass()) {
                this.reportError(p, "@Activities can only be used on an interface.", e);
            }
            if (e.getNestingKind().isNested()) {
                this.reportError(p, "@Activities not allowed on inner or nested types.", e);
            }
            this.version = ProcessorUtils.getActivitiesVersion(e);
            this.parentVersion = ProcessorUtils.getParentActivitiesVersion(p, e);
        }
        return (Boolean)super.visitType(e, p);
    }

    @Override
    public Boolean visitExecutable(ExecutableElement e, ProcessingEnvironment p) {
        Activity activityAnnotation;
        TypeMirror returnType = e.getReturnType();
        if (!ProcessorUtils.isVoidType(returnType) && ProcessorUtils.isPromiseType(returnType)) {
            this.reportError(p, "Activity methods are not allowed to have Promise return type.", e);
        }
        for (VariableElement variableElement : e.getParameters()) {
            TypeMirror parameterType = variableElement.asType();
            if (!ProcessorUtils.isPromiseType(parameterType)) continue;
            this.reportError(p, "Activity methods are not allowed to have Promise parameter type.", variableElement);
        }
        if (!(this.version != null && !this.version.isEmpty() || this.parentVersion != null && !this.parentVersion.isEmpty() || (activityAnnotation = e.getAnnotation(Activity.class)) != null && !activityAnnotation.name().isEmpty())) {
            this.reportError(p, "Activity version not specified.", e);
        }
        return (Boolean)super.visitExecutable(e, p);
    }

    private void reportError(ProcessingEnvironment environment, String message, Element element) {
        this.hasErrors = true;
        environment.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }
}

