/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor;

import com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor.ActivitiesValidator;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor.ProcessorUtils;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor.WorkflowValidator;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.common.ProcessorConstants;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.freemarker.ActivitiesCodeGenerator;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.freemarker.SourceFileCreator;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.freemarker.WorkflowCodeGenerator;
import com.amazonaws.services.simpleworkflow.flow.annotations.Activities;
import com.amazonaws.services.simpleworkflow.flow.annotations.Workflow;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"com.amazonaws.services.simpleworkflow.flow.annotations.Activities", "com.amazonaws.services.simpleworkflow.flow.annotations.Workflow"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class AsynchronyDeciderAnnotationProcessor
extends AbstractProcessor {
    private Set<DeclaredType> annotationsToExcludeFromCopying;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "AsynchronyDeciderAnnotationProcessor.process() invoked.");
            this.annotationsToExcludeFromCopying = new HashSet<DeclaredType>();
            this.annotationsToExcludeFromCopying.add(ProcessorUtils.getDeclaredType(this.processingEnv, ProcessorConstants.EXECUTE_ANNOTATION));
            this.annotationsToExcludeFromCopying.add(ProcessorUtils.getDeclaredType(this.processingEnv, ProcessorConstants.ACTIVITY_ANNOTATION));
            this.annotationsToExcludeFromCopying.add(ProcessorUtils.getDeclaredType(this.processingEnv, ProcessorConstants.SIGNAL_ANNOTATION));
            this.annotationsToExcludeFromCopying.add(ProcessorUtils.getDeclaredType(this.processingEnv, ProcessorConstants.GETSTATE_ANNOTATION));
            this.annotationsToExcludeFromCopying.add(ProcessorUtils.getDeclaredType(this.processingEnv, ProcessorConstants.JAVA_LANG_OVERRIDE));
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(Activities.class);
            for (Element element : annotatedElements) {
                ActivitiesValidator activitiesValidator = new ActivitiesValidator();
                activitiesValidator.scan(element, this.processingEnv);
                if (activitiesValidator.isHasErrors() || !(element instanceof TypeElement)) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Processing @Activities for " + element.getSimpleName());
                this.processActivities(element);
            }
            annotatedElements = roundEnv.getElementsAnnotatedWith(Workflow.class);
            for (Element element : annotatedElements) {
                WorkflowValidator workflowValidator = new WorkflowValidator();
                workflowValidator.scan(element, this.processingEnv);
                if (workflowValidator.isHasErrors() || !(element instanceof TypeElement)) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Processing @Workflow for " + element.getSimpleName());
                this.processWorkflow(roundEnv, element);
            }
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Processing finished");
        }
        return false;
    }

    private void processActivities(final Element activities) {
        DeclaredType activitiesAnnotationType = ProcessorUtils.getDeclaredType(this.processingEnv, ProcessorConstants.ACTIVITIES_ANNOTATION_TYPE_CLASS_NAME);
        com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Activities activitiesDefinition = ProcessorUtils.getActivitiesModel(this.processingEnv, (TypeElement)activities, activitiesAnnotationType, this.annotationsToExcludeFromCopying);
        String packageName = this.processingEnv.getElementUtils().getPackageOf(activities).getQualifiedName().toString();
        SourceFileCreator fileCreator = new SourceFileCreator(){

            public PrintWriter createSourceFile(String packageName, String className) {
                OutputStream fileStream = null;
                try {
                    JavaFileObject sourceFile = AsynchronyDeciderAnnotationProcessor.this.processingEnv.getFiler().createSourceFile(packageName + "." + className, activities);
                    fileStream = sourceFile.openOutputStream();
                }
                catch (IOException e) {
                    AsynchronyDeciderAnnotationProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to generate target class for element [reason: " + e.toString() + "]", activities);
                }
                if (fileStream != null) {
                    return new PrintWriter(fileStream);
                }
                return null;
            }
        };
        ActivitiesCodeGenerator codeGenerator = new ActivitiesCodeGenerator(packageName, activities.getSimpleName().toString(), activitiesDefinition, fileCreator);
        codeGenerator.generateCode();
    }

    private void processWorkflow(RoundEnvironment roundEnv, final Element workflow) {
        DeclaredType workflowAnnotationType = ProcessorUtils.getDeclaredType(this.processingEnv, ProcessorConstants.WORKFLOW_ANNOTATION_TYPE_CLASS_NAME);
        com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Workflow workflowDefinition = ProcessorUtils.getWorkflowModel(this.processingEnv, (TypeElement)workflow, workflowAnnotationType, this.annotationsToExcludeFromCopying);
        String packageName = this.processingEnv.getElementUtils().getPackageOf(workflow).getQualifiedName().toString();
        SourceFileCreator fileCreator = new SourceFileCreator(){

            public PrintWriter createSourceFile(String packageName, String className) {
                OutputStream fileStream = null;
                try {
                    JavaFileObject sourceFile = AsynchronyDeciderAnnotationProcessor.this.processingEnv.getFiler().createSourceFile(packageName + "." + className, workflow);
                    fileStream = sourceFile.openOutputStream();
                }
                catch (IOException e) {
                    AsynchronyDeciderAnnotationProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to generate target class for elmenet [reason: " + e.toString() + "]", workflow);
                }
                if (fileStream != null) {
                    return new PrintWriter(fileStream);
                }
                return null;
            }
        };
        WorkflowCodeGenerator workflowCodeGenerator = new WorkflowCodeGenerator(packageName, workflow.getSimpleName().toString(), workflowDefinition, fileCreator);
        workflowCodeGenerator.generateCode();
    }
}

