/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor;

import com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor.ActivitiesDeclarationVisitor;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor.WorkflowTypeVisitor;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.common.PrimitiveTypeHelper;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.common.ProcessorConstants;
import com.amazonaws.services.simpleworkflow.flow.annotations.Activities;
import com.amazonaws.services.simpleworkflow.flow.annotations.Activity;
import com.amazonaws.services.simpleworkflow.flow.annotations.Execute;
import com.amazonaws.services.simpleworkflow.flow.annotations.NullDataConverter;
import com.amazonaws.services.simpleworkflow.flow.annotations.Signal;
import com.amazonaws.services.simpleworkflow.flow.annotations.Workflow;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessorUtils {
    private static final String JAVA_LANG_PREFIX = "java.lang.";

    ProcessorUtils() {
    }

    public static boolean isPrimitive(TypeMirror typeMirror) {
        return typeMirror.getKind().isPrimitive();
    }

    public static boolean isVoidType(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.VOID;
    }

    public static boolean isJavaLangType(TypeMirror typeMirror) {
        return ProcessorUtils.isTypePackage(typeMirror, JAVA_LANG_PREFIX);
    }

    public static boolean isTypePackage(TypeMirror typeMirror, String packageName) {
        String fullName;
        if (typeMirror != null && !ProcessorUtils.isVoidType(typeMirror) && (fullName = typeMirror.toString()).startsWith(packageName)) {
            return !fullName.substring(packageName.length()).contains(".");
        }
        return false;
    }

    public static boolean isDeclaredType(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.DECLARED;
    }

    public static boolean isPromiseType(TypeMirror typeMirror) {
        String fullName;
        if (typeMirror != null && !ProcessorUtils.isVoidType(typeMirror) && (fullName = typeMirror.toString()) != null && !fullName.isEmpty()) {
            return fullName.startsWith(Promise.class.getName());
        }
        return false;
    }

    public static boolean isGenericType(TypeMirror typeMirror) {
        if (typeMirror != null && ProcessorUtils.isDeclaredType(typeMirror)) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            return declaredType.getTypeArguments().size() > 0;
        }
        return false;
    }

    public static boolean isArrayType(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.ARRAY;
    }

    public static String getTypeName(TypeMirror typeMirror, String generatedTypePackageName) {
        return ProcessorUtils.getTypeName(typeMirror, false, 1, generatedTypePackageName);
    }

    public static String getTypeNameUnboxed(TypeMirror typeMirror, String generatedTypePackageName) {
        return ProcessorUtils.getTypeName(typeMirror, true, 1, generatedTypePackageName);
    }

    private static String getTypeName(TypeMirror typeMirror, boolean unboxed, int depth, String generatedTypePackageName) {
        String typeName;
        if (ProcessorUtils.isPrimitive(typeMirror)) {
            typeName = unboxed ? typeMirror.toString() : PrimitiveTypeHelper.getWrapper(typeMirror.toString());
        } else if (ProcessorUtils.isVoidType(typeMirror)) {
            typeName = "Void";
        } else if (depth == 1 && ProcessorUtils.isPromiseType(typeMirror)) {
            DeclaredType pType = (DeclaredType)typeMirror;
            List<? extends TypeMirror> typeArguments = pType.getTypeArguments();
            typeName = typeArguments.size() == 0 ? "Void" : ProcessorUtils.getTypeName(typeArguments.iterator().next(), unboxed, depth + 1, generatedTypePackageName);
        } else if (ProcessorUtils.isArrayType(typeMirror)) {
            ArrayType aType = (ArrayType)typeMirror;
            typeName = ProcessorUtils.getTypeName(aType.getComponentType(), unboxed, depth + 1, generatedTypePackageName) + "[]";
        } else {
            typeName = typeMirror.toString();
        }
        if (ProcessorUtils.isJavaLangType(typeMirror)) {
            typeName = typeMirror.toString().substring(JAVA_LANG_PREFIX.length());
        }
        if (ProcessorUtils.isTypePackage(typeMirror, generatedTypePackageName)) {
            typeName = typeMirror.toString().substring(generatedTypePackageName.length() + 1);
        }
        return typeName;
    }

    public static String getJustTypeName(TypeMirror typeMirror, String generatedTypePackageName) {
        return ProcessorUtils.getJustTypeName(typeMirror, 1, generatedTypePackageName);
    }

    private static String getJustTypeName(TypeMirror typeMirror, int depth, String generatedTypePackageName) {
        DeclaredType pType;
        String typeName;
        if (ProcessorUtils.isPrimitive(typeMirror)) {
            typeName = PrimitiveTypeHelper.getWrapper(typeMirror.toString());
        } else if (depth == 1 && ProcessorUtils.isPromiseType(typeMirror)) {
            pType = (DeclaredType)typeMirror;
            List<? extends TypeMirror> typeArguments = pType.getTypeArguments();
            typeName = typeArguments.size() == 0 ? "Void" : ProcessorUtils.getJustTypeName(typeArguments.iterator().next(), depth + 1, generatedTypePackageName);
        } else if (ProcessorUtils.isVoidType(typeMirror)) {
            typeName = "Void";
        } else if (ProcessorUtils.isArrayType(typeMirror)) {
            ArrayType aType = (ArrayType)typeMirror;
            typeName = ProcessorUtils.getJustTypeName(aType.getComponentType(), depth + 1, generatedTypePackageName) + "[]";
        } else {
            pType = (DeclaredType)typeMirror;
            typeName = pType.asElement().toString();
        }
        if (typeMirror instanceof DeclaredType && ProcessorUtils.isJavaLangType(typeMirror)) {
            pType = (DeclaredType)typeMirror;
            typeName = pType.asElement().toString().substring(JAVA_LANG_PREFIX.length());
        }
        if (typeMirror instanceof DeclaredType && ProcessorUtils.isTypePackage(typeMirror, generatedTypePackageName)) {
            pType = (DeclaredType)typeMirror;
            typeName = pType.asElement().toString().substring(generatedTypePackageName.length() + 1);
        }
        return typeName;
    }

    public static DeclaredType getDeclaredType(ProcessingEnvironment processingEnv, String type) {
        TypeElement typeElem = processingEnv.getElementUtils().getTypeElement(type);
        if (typeElem != null) {
            return processingEnv.getTypeUtils().getDeclaredType(typeElem, new TypeMirror[0]);
        }
        return null;
    }

    public static String getActivitiesNamePrefix(TypeElement activitiesElement) {
        if (activitiesElement == null) {
            return "";
        }
        Activities annotation = activitiesElement.getAnnotation(Activities.class);
        String activityPrefix = annotation.activityNamePrefix();
        if (activityPrefix == null) {
            activityPrefix = activitiesElement.getSimpleName().toString();
        }
        return activityPrefix;
    }

    public static String getActivitiesVersion(TypeElement activitiesElement) {
        if (activitiesElement == null) {
            return null;
        }
        Activities annotation = activitiesElement.getAnnotation(Activities.class);
        if (annotation == null) {
            return null;
        }
        return annotation.version();
    }

    public static String getParentActivitiesVersion(ProcessingEnvironment processingEnv, TypeElement activities) {
        for (TypeMirror typeMirror : activities.getInterfaces()) {
            Element superInterfaceDeclaration = processingEnv.getTypeUtils().asElement(typeMirror);
            String parentVersion = ProcessorUtils.getActivitiesVersion((TypeElement)superInterfaceDeclaration);
            if (parentVersion == null || parentVersion.isEmpty()) continue;
            return parentVersion;
        }
        return null;
    }

    public static String getActivitiesDataConverter(ProcessingEnvironment env, TypeElement activitiesElement, DeclaredType activitiesAnnotation) {
        String dataConverterTypeName;
        if (activitiesElement == null) {
            return ProcessorConstants.DEFAULT_DATACONVERTER.getName();
        }
        AnnotationValue dataConverter = ProcessorUtils.getAnnotationValueForClassAttribute(env, activitiesElement, activitiesAnnotation, "dataConverter");
        String string = dataConverterTypeName = dataConverter != null ? dataConverter.getValue().toString() : null;
        if (dataConverterTypeName == null || dataConverterTypeName.equals(NullDataConverter.class.getName())) {
            dataConverterTypeName = ProcessorConstants.DEFAULT_DATACONVERTER.getName();
        }
        return dataConverterTypeName;
    }

    public static String computeActivityName(String prefix, String interfaceName, ExecutableElement activity) {
        assert (activity != null);
        String activityName = null;
        Activity activityAnnotation = activity.getAnnotation(Activity.class);
        activityName = activityAnnotation != null && !activityAnnotation.name().isEmpty() ? activityAnnotation.name() : (prefix == null || prefix.isEmpty() ? interfaceName + "." + activity.getSimpleName().toString() : prefix + activity.getSimpleName().toString());
        return activityName;
    }

    public static String computeActivityVersion(String version, ExecutableElement activity) {
        Activity activityAnnotation = activity.getAnnotation(Activity.class);
        if (activityAnnotation != null && !activityAnnotation.version().isEmpty()) {
            version = activityAnnotation.version();
        }
        return version;
    }

    public static String getWorkflowDataConverter(ProcessingEnvironment env, TypeElement workflowElement, DeclaredType workflowAnnotation) {
        String dataConverterTypeName;
        if (workflowElement == null) {
            return ProcessorConstants.DEFAULT_DATACONVERTER.getName();
        }
        AnnotationValue dataConverter = ProcessorUtils.getAnnotationValueForClassAttribute(env, workflowElement, workflowAnnotation, "dataConverter");
        String string = dataConverterTypeName = dataConverter != null ? dataConverter.getValue().toString() : null;
        if (dataConverterTypeName == null || dataConverterTypeName.equals(NullDataConverter.class.getName())) {
            dataConverterTypeName = ProcessorConstants.DEFAULT_DATACONVERTER.getName();
        }
        return dataConverterTypeName;
    }

    private static AnnotationValue getAnnotationValueForClassAttribute(ProcessingEnvironment env, TypeElement typeElement, DeclaredType annotationType, String attribute) {
        AnnotationValue elementValue = null;
        block0: for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            if (!env.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), annotationType)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                ExecutableElement elementKey = entry.getKey();
                if (!attribute.equals(elementKey.getSimpleName().toString())) continue;
                elementValue = entry.getValue();
                continue block0;
            }
        }
        return elementValue;
    }

    public static String computeWorkflowName(String interfaceName, ExecutableElement workflow) {
        assert (workflow != null);
        String workflowName = null;
        Execute options = workflow.getAnnotation(Execute.class);
        workflowName = options != null && !options.name().isEmpty() ? options.name() : interfaceName + "." + workflow.getSimpleName().toString();
        return workflowName;
    }

    public static String computeWorkflowVersion(ExecutableElement workflow) {
        String version = "1.0";
        Execute options = workflow.getAnnotation(Execute.class);
        if (!options.version().isEmpty()) {
            version = options.version();
        }
        return version;
    }

    public static String computeSignalName(ExecutableElement signal) {
        String signalName = signal.getSimpleName().toString();
        Signal signalOptions = signal.getAnnotation(Signal.class);
        if (signalOptions != null && signalOptions.name() != null && !signalOptions.name().equals("")) {
            signalName = signalOptions.name();
        }
        return signalName;
    }

    public static String getAnnotationsText(ProcessingEnvironment env, ExecutableElement method, Set<DeclaredType> annotationsToExcludeFromCopying) {
        StringBuilder annotationsText = new StringBuilder();
        for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
            boolean toInclude = true;
            if (annotationsToExcludeFromCopying != null) {
                for (DeclaredType toExclude : annotationsToExcludeFromCopying) {
                    if (!env.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), toExclude)) continue;
                    toInclude = false;
                    break;
                }
            }
            if (!toInclude) continue;
            StringBuilder annotationText = new StringBuilder();
            ProcessorUtils.writeAnnotation(annotationText, annotationMirror);
            annotationsText.append(annotationText.toString());
        }
        return annotationsText.toString();
    }

    public static void writeAnnotation(StringBuilder builder, AnnotationMirror annotation) {
        DeclaredType annotationDeclaration = annotation.getAnnotationType();
        builder.append("@" + annotationDeclaration.asElement().toString() + "(");
        boolean isFirst = true;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
            ExecutableElement elementKey = entry.getKey();
            AnnotationValue elementValue = entry.getValue();
            builder.append("\n");
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(elementKey.getSimpleName() + "=");
            ProcessorUtils.writeAnnotationValue(builder, elementValue);
        }
        builder.append(")\n");
    }

    public static void writeAnnotationValue(final StringBuilder builder, AnnotationValue annotationValue) {
        SimpleAnnotationValueVisitor6<Void, Void> annotationValueWriter = new SimpleAnnotationValueVisitor6<Void, Void>(){

            @Override
            public Void visitString(String value, Void processingEnv) {
                builder.append("\"");
                builder.append(value);
                builder.append("\"");
                return null;
            }

            @Override
            public Void visitAnnotation(AnnotationMirror value, Void processingEnv) {
                ProcessorUtils.writeAnnotation(builder, value);
                return null;
            }

            @Override
            public Void visitType(TypeMirror value, Void processingEnv) {
                builder.append(value.toString());
                builder.append(".class");
                return null;
            }

            @Override
            public Void visitEnumConstant(VariableElement value, Void processingEnv) {
                String enumTypeName = value.asType().toString();
                String simpleName = value.getSimpleName().toString();
                builder.append(enumTypeName + "." + simpleName);
                return null;
            }

            @Override
            public Void visitArray(List<? extends AnnotationValue> value, Void processingEnv) {
                builder.append("{ ");
                boolean isFirst = true;
                for (AnnotationValue annotationValue : value) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        builder.append(", ");
                    }
                    ProcessorUtils.writeAnnotationValue(builder, annotationValue);
                }
                builder.append(" }");
                return null;
            }

            @Override
            protected Void defaultAction(Object value, Void processingEnv) {
                builder.append(value.toString());
                return null;
            }
        };
        annotationValue.accept(annotationValueWriter, null);
    }

    public static com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Activities getActivitiesModel(ProcessingEnvironment processingEnv, TypeElement activities, DeclaredType activitiesAnnotationType, Set<DeclaredType> annotationsToExcludeFromCopying) {
        ActivitiesDeclarationVisitor visitor = new ActivitiesDeclarationVisitor(processingEnv, activities, activitiesAnnotationType, annotationsToExcludeFromCopying);
        visitor.scan(activities, processingEnv);
        return visitor.getActivitiesDefinition();
    }

    public static com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Workflow getWorkflowModel(ProcessingEnvironment processingEnv, TypeElement workflow, DeclaredType workflowAnnotationType, Set<DeclaredType> annotationsToExcludeFromCopying) {
        WorkflowTypeVisitor visitor = new WorkflowTypeVisitor(processingEnv, workflow, workflowAnnotationType, annotationsToExcludeFromCopying);
        visitor.scan(workflow, processingEnv);
        return visitor.getWorkflowDefinition();
    }

    public static List<com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Activities> getAllSuperActivities(ProcessingEnvironment processingEnv, TypeElement activities, DeclaredType activitiesAnnotationType, Set<DeclaredType> annotationsToExcludeFromCopying) {
        ArrayList<com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Activities> superActivities = new ArrayList<com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Activities>();
        for (TypeMirror typeMirror : activities.getInterfaces()) {
            Element superInterfaceDeclaration = processingEnv.getTypeUtils().asElement(typeMirror);
            Activities annotation = superInterfaceDeclaration != null ? superInterfaceDeclaration.getAnnotation(Activities.class) : null;
            if (annotation == null) continue;
            superActivities.add(ProcessorUtils.getActivitiesModel(processingEnv, (TypeElement)superInterfaceDeclaration, activitiesAnnotationType, annotationsToExcludeFromCopying));
        }
        return superActivities;
    }

    public static List<com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Workflow> getAllSuperWorkflows(ProcessingEnvironment processingEnv, TypeElement workflow, DeclaredType workflowAnnotationType, Set<DeclaredType> annotationsToExcludeFromCopying) {
        ArrayList<com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Workflow> superWorkflows = new ArrayList<com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Workflow>();
        for (TypeMirror typeMirror : workflow.getInterfaces()) {
            Element superInterfaceDeclaration = processingEnv.getTypeUtils().asElement(typeMirror);
            Workflow annotation = superInterfaceDeclaration != null ? superInterfaceDeclaration.getAnnotation(Workflow.class) : null;
            if (annotation == null) continue;
            superWorkflows.add(ProcessorUtils.getWorkflowModel(processingEnv, (TypeElement)superInterfaceDeclaration, workflowAnnotationType, annotationsToExcludeFromCopying));
        }
        return superWorkflows;
    }
}

