/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor;

import com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor.ProcessorUtils;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.ExecuteMethod;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.GetStateMethod;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Method;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.MethodParameter;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.SignalMethod;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Workflow;
import com.amazonaws.services.simpleworkflow.flow.annotations.Execute;
import com.amazonaws.services.simpleworkflow.flow.annotations.GetState;
import com.amazonaws.services.simpleworkflow.flow.annotations.Signal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowTypeVisitor
extends ElementScanner6<Void, ProcessingEnvironment> {
    private Workflow workflowDefinition;
    private Set<DeclaredType> annotationsToExcludeFromCopying;

    public WorkflowTypeVisitor(ProcessingEnvironment processingEnv, TypeElement workflow, DeclaredType workflowAnnotationType, Set<DeclaredType> annotationsToExcludeFromCopying) {
        this.annotationsToExcludeFromCopying = annotationsToExcludeFromCopying;
        String dataConverter = ProcessorUtils.getWorkflowDataConverter(processingEnv, workflow, workflowAnnotationType);
        String interfaceName = workflow.getSimpleName().toString();
        String qualifiedName = workflow.toString();
        this.workflowDefinition = new Workflow(null, null, dataConverter, interfaceName, qualifiedName);
        List<Workflow> superTypes = ProcessorUtils.getAllSuperWorkflows(processingEnv, workflow, workflowAnnotationType, annotationsToExcludeFromCopying);
        this.workflowDefinition.setSuperTypes(superTypes);
    }

    @Override
    public Void visitExecutable(ExecutableElement method, ProcessingEnvironment env) {
        if (method.getAnnotation(Execute.class) != null) {
            String workflowName = ProcessorUtils.computeWorkflowName(this.workflowDefinition.getInterfaceName(), method);
            String workflowVersion = ProcessorUtils.computeWorkflowVersion(method);
            ExecuteMethod executeMethod = new ExecuteMethod(workflowName, workflowVersion);
            this.setMethodInfo(method, executeMethod, this.workflowDefinition.getPackageName());
            executeMethod.setAnnotationsToCopy(ProcessorUtils.getAnnotationsText(env, method, this.annotationsToExcludeFromCopying));
            this.workflowDefinition.setExecuteMethod(executeMethod);
        } else if (method.getAnnotation(Signal.class) != null) {
            String signalName = ProcessorUtils.computeSignalName(method);
            SignalMethod signalMethod = new SignalMethod(signalName);
            this.setMethodInfo(method, signalMethod, this.workflowDefinition.getPackageName());
            this.workflowDefinition.getSignals().add(signalMethod);
        } else if (method.getAnnotation(GetState.class) != null) {
            GetStateMethod getStateMethod = new GetStateMethod();
            this.setMethodInfo(method, getStateMethod, this.workflowDefinition.getPackageName());
            this.workflowDefinition.setGetStateMethod(getStateMethod);
        }
        return (Void)super.visitExecutable(method, env);
    }

    public Workflow getWorkflowDefinition() {
        return this.workflowDefinition;
    }

    private void setMethodInfo(ExecutableElement methodDeclaration, Method method, String generatedTypePackageName) {
        method.setMethodName(methodDeclaration.getSimpleName().toString());
        TypeMirror returnType = methodDeclaration.getReturnType();
        method.setMethodReturnType(ProcessorUtils.getTypeName(returnType, generatedTypePackageName));
        method.setMethodReturnTypeNoGenerics(ProcessorUtils.getJustTypeName(returnType, generatedTypePackageName));
        method.setMethodReturnTypeUnboxed(ProcessorUtils.getTypeNameUnboxed(returnType, generatedTypePackageName));
        method.setHasGenericReturnType(ProcessorUtils.isGenericType(returnType));
        method.setPrimitiveReturnType(ProcessorUtils.isPrimitive(returnType));
        List<? extends VariableElement> parameters = methodDeclaration.getParameters();
        for (VariableElement variableElement : parameters) {
            TypeMirror typeMirror = variableElement.asType();
            String parameterTypeName = ProcessorUtils.getTypeName(typeMirror, generatedTypePackageName);
            String parameterName = variableElement.toString();
            MethodParameter methodParam = new MethodParameter(parameterName, parameterTypeName);
            methodParam.setParameterTypeUnboxed(ProcessorUtils.getTypeNameUnboxed(typeMirror, generatedTypePackageName));
            method.getMethodParameters().add(methodParam);
        }
        ArrayList<String> thrownTypes = new ArrayList<String>();
        for (TypeMirror typeMirror : methodDeclaration.getThrownTypes()) {
            thrownTypes.add(typeMirror.toString());
        }
        method.setThrownExceptions(thrownTypes);
    }
}

