/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor;

import com.amazonaws.eclipse.simpleworkflow.asynchrony.annotationprocessor.ProcessorUtils;
import com.amazonaws.services.simpleworkflow.flow.annotations.Execute;
import com.amazonaws.services.simpleworkflow.flow.annotations.GetState;
import com.amazonaws.services.simpleworkflow.flow.annotations.Signal;
import com.amazonaws.services.simpleworkflow.flow.annotations.Workflow;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;
import javax.tools.Diagnostic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowValidator
extends ElementScanner6<Boolean, ProcessingEnvironment> {
    private boolean hasErrors = false;
    private boolean hasExecute = false;
    private boolean hasGetState = false;

    public boolean isHasErrors() {
        return this.hasErrors;
    }

    public boolean isHasExecute() {
        return this.hasExecute;
    }

    public boolean isHasGetState() {
        return this.hasGetState;
    }

    @Override
    public Boolean visitType(TypeElement e, ProcessingEnvironment p) {
        if (e.getAnnotation(Workflow.class) != null) {
            if (e.getKind().isClass()) {
                this.reportError(p, "@Workflow can only be used on an interface.", e);
            }
            if (e.getNestingKind().isNested()) {
                this.reportError(p, "@Workflow not allowed on inner or nested types.", e);
            }
        }
        return (Boolean)super.visitType(e, p);
    }

    @Override
    public Boolean visitExecutable(ExecutableElement e, ProcessingEnvironment p) {
        TypeMirror returnType;
        int annotationCount = 0;
        if (e.getAnnotation(Execute.class) != null) {
            if (this.hasExecute) {
                this.reportError(p, "Only one method allowed with @Execute annotation.", e);
            } else {
                this.hasExecute = true;
            }
            ++annotationCount;
            returnType = e.getReturnType();
            if (!ProcessorUtils.isVoidType(returnType) && !ProcessorUtils.isPromiseType(returnType)) {
                this.reportError(p, "Method with @Execute annotations is only allowed to have void or Promise as return types.", e);
            }
        }
        if (e.getAnnotation(Signal.class) != null) {
            if (!ProcessorUtils.isVoidType(e.getReturnType())) {
                this.reportError(p, "Signal method cannot have a return type.", e);
            }
            ++annotationCount;
        }
        if (e.getAnnotation(GetState.class) != null) {
            if (this.hasGetState) {
                this.reportError(p, "Only one method allowed with @GetState annotation.", e);
            } else {
                this.hasGetState = true;
            }
            returnType = e.getReturnType();
            if (ProcessorUtils.isVoidType(returnType)) {
                this.reportError(p, "GetState method cannot have void as return type.", e);
            } else if (ProcessorUtils.isPromiseType(returnType)) {
                this.reportError(p, "GetState method cannot have Promise as return type.", e);
            }
            ++annotationCount;
        }
        if (annotationCount > 1) {
            this.reportError(p, "Annotations @Execute, @Signal and @GetState are exclusive.", e);
        }
        for (VariableElement variableElement : e.getParameters()) {
            TypeMirror parameterType = variableElement.asType();
            if (!ProcessorUtils.isPromiseType(parameterType)) continue;
            this.reportError(p, "@Workflow methods are not allowed to have Promise parameter types.", variableElement);
        }
        return (Boolean)super.visitExecutable(e, p);
    }

    private void reportError(ProcessingEnvironment environment, String message, Element element) {
        this.hasErrors = true;
        environment.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }
}

