/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.eclipse.simpleworkflow.asynchrony.common;

import java.util.HashMap;
import java.util.Map;

public class PrimitiveTypeHelper {
    private static final String[] primitiveTypes = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double", "void"};
    private static final String[] wrapperTypes = new String[]{"Boolean", "Byte", "Character", "Short", "Integer", "Long", "Float", "Double", "Void"};
    public static final String[] methods = new String[]{"booleanValue", "byteValue", "charValue", "shortValue", "intValue", "longValue", "floatValue", "doubleValue"};
    private static Map<String, String> primitiveToWrapper = new HashMap<String, String>();
    private static Map<String, String> wrapperToPrimitive = new HashMap<String, String>();
    private static Map<String, String> toPrimitiveMethods = new HashMap<String, String>();

    public static String getWrapper(String primitive) {
        String result = primitiveToWrapper.get(primitive);
        if (result == null) {
            throw new IllegalArgumentException(primitive);
        }
        return result;
    }

    public static String getPrimitive(String wrapper) {
        String result = wrapperToPrimitive.get(wrapper);
        if (result == null) {
            throw new IllegalArgumentException(wrapper);
        }
        return result;
    }

    public static String getToPrimitiveMethod(String primitive) {
        String result = toPrimitiveMethods.get(primitive);
        if (result == null) {
            throw new IllegalArgumentException(primitive);
        }
        return result;
    }

    static {
        for (int i = 0; i < primitiveTypes.length; ++i) {
            primitiveToWrapper.put(primitiveTypes[i], wrapperTypes[i]);
            wrapperToPrimitive.put(wrapperTypes[i], primitiveTypes[i]);
            if (i >= primitiveTypes.length - 1) continue;
            toPrimitiveMethods.put(primitiveTypes[i], methods[i]);
        }
    }
}

