/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.eclipse.simpleworkflow.asynchrony.freemarker;

import com.amazonaws.eclipse.simpleworkflow.asynchrony.freemarker.SourceFileCreator;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Activities;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivitiesCodeGenerator {
    private final String packageName;
    private final String interfaceName;
    private final Activities activities;
    private final SourceFileCreator fileCreator;
    private Configuration cfg;
    private Map<String, Object> root;

    public ActivitiesCodeGenerator(String packageName, String interfaceName, Activities activities, SourceFileCreator fileCreator) {
        this.packageName = packageName;
        this.interfaceName = interfaceName;
        this.activities = activities;
        this.fileCreator = fileCreator;
    }

    private Configuration getConfiguration() {
        if (this.cfg == null) {
            this.cfg = new Configuration();
            this.cfg.setClassForTemplateLoading(this.getClass(), "/");
            this.cfg.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        }
        return this.cfg;
    }

    private Map<String, Object> getRoot() {
        if (this.root == null) {
            this.root = new HashMap<String, Object>();
            this.root.put("packageName", this.packageName);
            this.root.put("clientInterfaceName", this.getClientInterfaceName());
            this.root.put("clientImplName", this.getClientImplName());
            this.root.put("qualifiedTypeName", this.activities.getQualifiedName());
            this.root.put("activities", this.activities);
        }
        return this.root;
    }

    private String getClientInterfaceName() {
        return this.interfaceName + "Client";
    }

    private String getClientImplName() {
        return this.interfaceName + "ClientImpl";
    }

    public void generateCode() {
        this.generateActivitiesClientInterface();
        this.generateActivitiesClientImpl();
    }

    private void generateActivitiesClientInterface() {
        String clientInterfaceName = this.getClientInterfaceName();
        this.generate(clientInterfaceName, "resources/templates/activitiesclient.ftl");
    }

    private void generateActivitiesClientImpl() {
        String clientImplName = this.getClientImplName();
        this.generate(clientImplName, "resources/templates/activitiesclientimpl.ftl");
    }

    private void generate(String className, String templateName) {
        PrintWriter writer = this.fileCreator.createSourceFile(this.packageName, className);
        try {
            Template template = this.getConfiguration().getTemplate(templateName);
            template.process(this.getRoot(), (Writer)writer);
        }
        catch (IOException e) {
            writer.println("Error loading template: " + templateName);
        }
        catch (TemplateException e) {
            writer.println("Error processing template: " + templateName);
            writer.println(e.getMessage());
        }
        writer.flush();
        writer.close();
    }
}

