/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.eclipse.simpleworkflow.asynchrony.freemarker;

import com.amazonaws.eclipse.simpleworkflow.asynchrony.freemarker.SourceFileCreator;
import com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel.Workflow;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowCodeGenerator {
    private final String packageName;
    private final String interfaceName;
    private final Workflow workflow;
    private final SourceFileCreator fileCreator;
    private Configuration cfg;
    private Map<String, Object> root;

    public WorkflowCodeGenerator(String packageName, String interfaceName, Workflow workflow, SourceFileCreator fileCreator) {
        this.packageName = packageName;
        this.interfaceName = interfaceName;
        this.workflow = workflow;
        this.fileCreator = fileCreator;
    }

    private Configuration getConfiguration() {
        if (this.cfg == null) {
            this.cfg = new Configuration();
            this.cfg.setClassForTemplateLoading(this.getClass(), "/");
            this.cfg.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        }
        return this.cfg;
    }

    private Map<String, Object> getRoot() {
        if (this.root == null) {
            this.root = new HashMap<String, Object>();
            this.root.put("packageName", this.packageName);
            this.root.put("clientInterfaceName", this.getClientInterfaceName());
            this.root.put("clientImplName", this.getClientImplName());
            this.root.put("clientFactoryName", this.getClientFactoryName());
            this.root.put("clientFactoryImplName", this.getClientFactoryImplName());
            this.root.put("clientExternalInterfaceName", this.getClientExternalInterfaceName());
            this.root.put("clientExternalImplName", this.getClientExternalImplName());
            this.root.put("clientExternalFactoryName", this.getClientExternalFactoryName());
            this.root.put("clientExternalFactoryImplName", this.getClientExternalFactoryImplName());
            this.root.put("selfClientInterfaceName", this.getSelfClientInterfaceName());
            this.root.put("selfClientImplName", this.getSelfClientImplName());
            this.root.put("qualifiedTypeName", this.workflow.getQualifiedName());
            this.root.put("workflow", this.workflow);
        }
        return this.root;
    }

    private String getClientInterfaceName() {
        return this.interfaceName + "Client";
    }

    private String getClientImplName() {
        return this.interfaceName + "ClientImpl";
    }

    private String getClientFactoryName() {
        return this.interfaceName + "ClientFactory";
    }

    private String getClientFactoryImplName() {
        return this.interfaceName + "ClientFactoryImpl";
    }

    private String getClientExternalInterfaceName() {
        return this.interfaceName + "ClientExternal";
    }

    private String getClientExternalImplName() {
        return this.interfaceName + "ClientExternalImpl";
    }

    private String getClientExternalFactoryName() {
        return this.interfaceName + "ClientExternalFactory";
    }

    private String getClientExternalFactoryImplName() {
        return this.interfaceName + "ClientExternalFactoryImpl";
    }

    private String getSelfClientInterfaceName() {
        return this.interfaceName + "SelfClient";
    }

    private String getSelfClientImplName() {
        return this.interfaceName + "SelfClientImpl";
    }

    public void generateCode() {
        this.generateWorkflowClientInterface();
        this.generateWorkflowClientImpl();
        this.generateWorkflowClientFactory();
        this.generateWorkflowClientFactoryImpl();
        this.generateWorkflowClientExternalInterface();
        this.generateWorkflowClientExternalImpl();
        this.generateWorkflowClientExternalFactory();
        this.generateWorkflowClientExternalFactoryImpl();
        this.generateWorkflowSelfClientInterface();
        this.generateWorkflowSelfClientImpl();
    }

    private void generateWorkflowClientInterface() {
        String clientInterfaceName = this.getClientInterfaceName();
        this.generate(clientInterfaceName, "resources/templates/workflowclient.ftl");
    }

    private void generateWorkflowClientImpl() {
        String clientImplName = this.getClientImplName();
        this.generate(clientImplName, "resources/templates/workflowclientimpl.ftl");
    }

    private void generateWorkflowClientFactory() {
        String clientFactoryName = this.getClientFactoryName();
        this.generate(clientFactoryName, "resources/templates/workflowclientfactory.ftl");
    }

    private void generateWorkflowClientFactoryImpl() {
        String clientFactoryName = this.getClientFactoryImplName();
        this.generate(clientFactoryName, "resources/templates/workflowclientfactoryimpl.ftl");
    }

    private void generateWorkflowClientExternalInterface() {
        String clientInterfaceName = this.getClientExternalInterfaceName();
        this.generate(clientInterfaceName, "resources/templates/workflowclientexternal.ftl");
    }

    private void generateWorkflowClientExternalImpl() {
        String clientImplName = this.getClientExternalImplName();
        this.generate(clientImplName, "resources/templates/workflowclientexternalimpl.ftl");
    }

    private void generateWorkflowClientExternalFactory() {
        String clientFactoryName = this.getClientExternalFactoryName();
        this.generate(clientFactoryName, "resources/templates/workflowclientexternalfactory.ftl");
    }

    private void generateWorkflowClientExternalFactoryImpl() {
        String clientFactoryName = this.getClientExternalFactoryImplName();
        this.generate(clientFactoryName, "resources/templates/workflowclientexternalfactoryimpl.ftl");
    }

    private void generateWorkflowSelfClientInterface() {
        String clientInterfaceName = this.getSelfClientInterfaceName();
        this.generate(clientInterfaceName, "resources/templates/workflowselfclient.ftl");
    }

    private void generateWorkflowSelfClientImpl() {
        String clientImplName = this.getSelfClientImplName();
        this.generate(clientImplName, "resources/templates/workflowselfclientimpl.ftl");
    }

    private void generate(String className, String templateName) {
        PrintWriter writer = this.fileCreator.createSourceFile(this.packageName, className);
        try {
            Template template = this.getConfiguration().getTemplate(templateName);
            template.process(this.getRoot(), (Writer)writer);
        }
        catch (IOException e) {
            writer.println("Error loading template: " + templateName);
        }
        catch (TemplateException e) {
            writer.println("Error processing template: " + templateName);
            writer.println(e.getMessage());
        }
        writer.flush();
        writer.close();
    }
}

