/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.eclipse.simpleworkflow.asynchrony.objectmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDefinition {
    private final String prefix;
    private final String version;
    private final String dataConverter;
    private final String interfaceName;
    private final String qualifiedName;
    private final String packageName;
    private List<? extends TypeDefinition> superTypes;

    public TypeDefinition(String prefix, String version, String dataConverter, String interfaceName, String qualifiedName) {
        this.prefix = prefix;
        this.version = version;
        this.dataConverter = dataConverter;
        this.interfaceName = interfaceName;
        this.qualifiedName = qualifiedName;
        this.packageName = qualifiedName.substring(0, qualifiedName.length() - interfaceName.length() - 1);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDataConverter() {
        return this.dataConverter;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<? extends TypeDefinition> getSuperTypes() {
        if (this.superTypes == null) {
            this.superTypes = new ArrayList<TypeDefinition>();
        }
        return this.superTypes;
    }

    public void setSuperTypes(List<? extends TypeDefinition> superTypes) {
        ArrayList<? extends TypeDefinition> superTypesCopy = new ArrayList<TypeDefinition>();
        if (superTypes != null) {
            superTypesCopy.addAll(superTypes);
        }
        this.superTypes = superTypesCopy;
    }

    public Collection<? extends TypeDefinition> getAllSuperTypes() {
        HashMap<String, TypeDefinition> allSuperTypesMap = new HashMap<String, TypeDefinition>();
        for (TypeDefinition typeDefinition : this.getSuperTypes()) {
            for (TypeDefinition typeDefinition2 : typeDefinition.getAllSuperTypes()) {
                if (allSuperTypesMap.containsKey(typeDefinition2.getQualifiedName())) continue;
                allSuperTypesMap.put(typeDefinition2.getQualifiedName(), typeDefinition2);
            }
            allSuperTypesMap.put(typeDefinition.getQualifiedName(), typeDefinition);
        }
        return allSuperTypesMap.values();
    }
}

