/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.interceptors;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Namespace;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.TraceHeader;
import com.amazonaws.xray.handlers.config.AWSOperationHandler;
import com.amazonaws.xray.handlers.config.AWSOperationHandlerManifest;
import com.amazonaws.xray.handlers.config.AWSServiceHandlerManifest;
import com.amazonaws.xray.utils.StringTransform;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.regions.Region;

public class TracingInterceptor
implements ExecutionInterceptor {
    @Deprecated
    public static final ExecutionAttribute<Subsegment> entityKey = new ExecutionAttribute("AWS X-Ray Entity");
    private static final Log logger = LogFactory.getLog(TracingInterceptor.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    private static final URL DEFAULT_OPERATION_PARAMETER_WHITELIST = TracingInterceptor.class.getResource("/com/amazonaws/xray/interceptors/DefaultOperationParameterWhitelist.json");
    private static final String UNKNOWN_REQUEST_ID = "UNKNOWN";
    private static final List<String> REQUEST_ID_KEYS = Arrays.asList("x-amz-request-id", "x-amzn-requestid");
    private AWSServiceHandlerManifest awsServiceHandlerManifest;
    private AWSXRayRecorder recorder;
    private final String accountId;

    public TracingInterceptor() {
        this(null, null, null);
    }

    public TracingInterceptor(AWSXRayRecorder recorder, String accountId, URL parameterWhitelist) {
        this.recorder = recorder;
        this.accountId = accountId;
        this.initInterceptorManifest(parameterWhitelist);
    }

    private void initInterceptorManifest(URL parameterWhitelist) {
        if (parameterWhitelist != null) {
            try {
                this.awsServiceHandlerManifest = (AWSServiceHandlerManifest)MAPPER.readValue(parameterWhitelist, AWSServiceHandlerManifest.class);
                return;
            }
            catch (IOException e) {
                logger.error((Object)("Unable to parse operation parameter whitelist at " + parameterWhitelist.getPath() + ". Falling back to default operation parameter whitelist at " + DEFAULT_OPERATION_PARAMETER_WHITELIST.getPath() + "."), (Throwable)e);
            }
        }
        try {
            this.awsServiceHandlerManifest = (AWSServiceHandlerManifest)MAPPER.readValue(DEFAULT_OPERATION_PARAMETER_WHITELIST, AWSServiceHandlerManifest.class);
        }
        catch (IOException e) {
            logger.error((Object)("Unable to parse default operation parameter whitelist at " + DEFAULT_OPERATION_PARAMETER_WHITELIST.getPath() + ". This will affect this handler's ability to capture AWS operation parameter information."), (Throwable)e);
        }
    }

    private AWSOperationHandler getOperationHandler(ExecutionAttributes executionAttributes) {
        String serviceName = (String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME);
        String operationName = (String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
        if (this.awsServiceHandlerManifest == null) {
            return null;
        }
        AWSOperationHandlerManifest operationManifest = this.awsServiceHandlerManifest.getOperationHandlerManifest(serviceName);
        if (operationManifest == null) {
            return null;
        }
        return operationManifest.getOperationHandler(operationName);
    }

    private HashMap<String, Object> extractRequestParameters(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        AWSOperationHandler operationHandler = this.getOperationHandler(executionAttributes);
        if (operationHandler == null) {
            return parameters;
        }
        if (operationHandler.getRequestParameters() != null) {
            operationHandler.getRequestParameters().forEach(parameterName -> {
                SdkRequest request = context.request();
                Optional parameterValue = request.getValueForField(parameterName, Object.class);
                if (parameterValue.isPresent()) {
                    parameters.put(StringTransform.toSnakeCase((String)parameterName), parameterValue.get());
                }
            });
        }
        if (operationHandler.getRequestDescriptors() != null) {
            operationHandler.getRequestDescriptors().forEach((key, descriptor) -> {
                SdkRequest request;
                Optional parameterValue;
                if (descriptor.isMap() && descriptor.shouldGetKeys()) {
                    SdkRequest request2 = context.request();
                    Optional parameterValue2 = request2.getValueForField(key, Map.class);
                    if (parameterValue2.isPresent()) {
                        String renameTo = descriptor.getRenameTo() != null ? descriptor.getRenameTo() : key;
                        parameters.put(StringTransform.toSnakeCase((String)renameTo), ((Map)parameterValue2.get()).keySet());
                    }
                } else if (descriptor.isList() && descriptor.shouldGetCount() && (parameterValue = (request = context.request()).getValueForField(key, List.class)).isPresent()) {
                    String renameTo = descriptor.getRenameTo() != null ? descriptor.getRenameTo() : key;
                    parameters.put(StringTransform.toSnakeCase((String)renameTo), ((List)parameterValue.get()).size());
                }
            });
        }
        return parameters;
    }

    private HashMap<String, Object> extractResponseParameters(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        AWSOperationHandler operationHandler = this.getOperationHandler(executionAttributes);
        if (operationHandler == null) {
            return parameters;
        }
        if (operationHandler.getResponseParameters() != null) {
            operationHandler.getResponseParameters().forEach(parameterName -> {
                SdkResponse response = context.response();
                Optional parameterValue = response.getValueForField(parameterName, Object.class);
                if (parameterValue.isPresent()) {
                    parameters.put(StringTransform.toSnakeCase((String)parameterName), parameterValue.get());
                }
            });
        }
        if (operationHandler.getResponseDescriptors() != null) {
            operationHandler.getResponseDescriptors().forEach((key, descriptor) -> {
                SdkResponse response;
                Optional parameterValue;
                if (descriptor.isMap() && descriptor.shouldGetKeys()) {
                    SdkResponse response2 = context.response();
                    Optional parameterValue2 = response2.getValueForField(key, Map.class);
                    if (parameterValue2.isPresent()) {
                        String renameTo = descriptor.getRenameTo() != null ? descriptor.getRenameTo() : key;
                        parameters.put(StringTransform.toSnakeCase((String)renameTo), ((Map)parameterValue2.get()).keySet());
                    }
                } else if (descriptor.isList() && descriptor.shouldGetCount() && (parameterValue = (response = context.response()).getValueForField(key, List.class)).isPresent()) {
                    String renameTo = descriptor.getRenameTo() != null ? descriptor.getRenameTo() : key;
                    parameters.put(StringTransform.toSnakeCase((String)renameTo), ((List)parameterValue.get()).size());
                }
            });
        }
        return parameters;
    }

    public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
        AWSXRayRecorder recorder = this.getRecorder();
        Entity origin = recorder.getTraceEntity();
        Subsegment subsegment = recorder.beginSubsegment((String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME));
        subsegment.setNamespace(Namespace.AWS.toString());
        subsegment.putAws("operation", executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME));
        Region region = (Region)executionAttributes.getAttribute(AwsExecutionAttribute.AWS_REGION);
        if (region != null) {
            subsegment.putAws("region", (Object)region.id());
        }
        subsegment.putAllAws(this.extractRequestParameters(context, executionAttributes));
        if (this.accountId != null) {
            subsegment.putAws("account_id", (Object)this.accountId);
        }
        recorder.setTraceEntity(origin);
        executionAttributes.putAttribute(entityKey, (Object)subsegment);
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest httpRequest = context.httpRequest();
        Subsegment subsegment = (Subsegment)executionAttributes.getAttribute(entityKey);
        if (!subsegment.shouldPropagate()) {
            return httpRequest;
        }
        boolean isSampled = subsegment.getParentSegment().isSampled();
        TraceHeader header = new TraceHeader(subsegment.getParentSegment().getTraceId(), isSampled ? subsegment.getId() : null, isSampled ? TraceHeader.SampleDecision.SAMPLED : TraceHeader.SampleDecision.NOT_SAMPLED);
        return (SdkHttpRequest)((SdkHttpRequest.Builder)httpRequest.toBuilder()).appendHeader("X-Amzn-Trace-Id", header.toString()).build();
    }

    public void beforeTransmission(Context.BeforeTransmission context, ExecutionAttributes executionAttributes) {
        Subsegment subsegment = (Subsegment)executionAttributes.getAttribute(entityKey);
        if (subsegment == null) {
            return;
        }
        Map awsProperties = subsegment.getAws();
        int retryCount = awsProperties.getOrDefault("retries", -1);
        awsProperties.put("retries", retryCount + 1);
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        Subsegment subsegment = (Subsegment)executionAttributes.getAttribute(entityKey);
        if (subsegment == null) {
            return;
        }
        this.populateRequestId(subsegment, context);
        this.populateSubsegmentWithResponse(subsegment, context.httpResponse());
        subsegment.putAllAws(this.extractResponseParameters(context, executionAttributes));
        this.getRecorder().endSubsegment(subsegment);
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        Subsegment subsegment = (Subsegment)executionAttributes.getAttribute(entityKey);
        if (subsegment == null) {
            return;
        }
        this.populateSubsegmentException(subsegment, context);
        this.populateRequestId(subsegment, context);
        if (context.httpResponse().isPresent()) {
            this.populateSubsegmentWithResponse(subsegment, (SdkHttpResponse)context.httpResponse().get());
        }
        this.getRecorder().endSubsegment(subsegment);
    }

    private HashMap<String, Object> extractHttpResponseParameters(SdkHttpResponse httpResponse) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, Number> responseData = new HashMap<String, Number>();
        responseData.put("status", httpResponse.statusCode());
        try {
            if (httpResponse.headers().containsKey("Content-Length")) {
                responseData.put("content_length", Long.parseLong((String)((List)httpResponse.headers().get("Content-Length")).get(0)));
            }
        }
        catch (NumberFormatException e) {
            logger.warn((Object)"Unable to parse Content-Length header.", (Throwable)e);
        }
        parameters.put("response", responseData);
        return parameters;
    }

    private void setRemoteForException(Subsegment subsegment, Throwable exception) {
        subsegment.getCause().getExceptions().forEach(e -> {
            if (e.getThrowable() == exception) {
                e.setRemote(true);
            }
        });
    }

    private void populateSubsegmentException(Subsegment subsegment, Context.FailedExecution context) {
        Throwable exception = context.exception();
        subsegment.addException(exception);
        int statusCode = -1;
        if (exception instanceof SdkServiceException) {
            statusCode = ((SdkServiceException)exception).statusCode();
            subsegment.getCause().setMessage(exception.getMessage());
            if (((SdkServiceException)exception).isThrottlingException()) {
                subsegment.setThrottle(true);
                subsegment.setError(true);
            }
            this.setRemoteForException(subsegment, exception);
        } else if (context.httpResponse().isPresent()) {
            statusCode = ((SdkHttpResponse)context.httpResponse().get()).statusCode();
        }
        if (statusCode == -1) {
            return;
        }
        if (statusCode >= 400 && statusCode < 500) {
            subsegment.setFault(false);
            subsegment.setError(true);
            if (statusCode == 429) {
                subsegment.setThrottle(true);
            }
        } else if (statusCode >= 500) {
            subsegment.setFault(true);
        }
    }

    private void populateRequestId(Subsegment subsegment, Optional<SdkResponse> response, Optional<SdkHttpResponse> httpResponse, Throwable exception) {
        String requestId = null;
        if (exception != null) {
            requestId = this.extractRequestIdFromThrowable(exception);
        }
        if (requestId == null || requestId.equals(UNKNOWN_REQUEST_ID)) {
            requestId = this.extractRequestIdFromResponse(response);
        }
        if (requestId == null || requestId.equals(UNKNOWN_REQUEST_ID)) {
            requestId = this.extractRequestIdFromHttp(httpResponse);
        }
        if (requestId != null && !requestId.equals(UNKNOWN_REQUEST_ID)) {
            subsegment.putAws("request_id", (Object)requestId);
        }
    }

    private void populateRequestId(Subsegment subsegment, Context.FailedExecution context) {
        this.populateRequestId(subsegment, context.response(), context.httpResponse(), context.exception());
    }

    private void populateRequestId(Subsegment subsegment, Context.AfterExecution context) {
        this.populateRequestId(subsegment, Optional.of(context.response()), Optional.of(context.httpResponse()), null);
    }

    private String extractRequestIdFromHttp(Optional<SdkHttpResponse> httpResponse) {
        if (!httpResponse.isPresent()) {
            return null;
        }
        return this.extractRequestIdFromHttp(httpResponse.get());
    }

    private String extractRequestIdFromHttp(SdkHttpResponse httpResponse) {
        Map headers = httpResponse.headers();
        Set headerKeys = headers.keySet();
        String requestIdKey = headerKeys.stream().filter(key -> REQUEST_ID_KEYS.contains(key.toLowerCase())).findFirst().orElse(null);
        return requestIdKey != null ? (String)((List)headers.get(requestIdKey)).get(0) : null;
    }

    private String extractExtendedRequestIdFromHttp(SdkHttpResponse httpResponse) {
        Map headers = httpResponse.headers();
        return headers.containsKey("x-amz-id-2") ? (String)((List)headers.get("x-amz-id-2")).get(0) : null;
    }

    private String extractRequestIdFromThrowable(Throwable exception) {
        if (exception instanceof SdkServiceException) {
            return ((SdkServiceException)exception).requestId();
        }
        return null;
    }

    private String extractRequestIdFromResponse(Optional<SdkResponse> response) {
        if (response.isPresent()) {
            return this.extractRequestIdFromResponse(response.get());
        }
        return null;
    }

    private String extractRequestIdFromResponse(SdkResponse response) {
        if (response instanceof AwsResponse) {
            return ((AwsResponse)response).responseMetadata().requestId();
        }
        return null;
    }

    private void populateSubsegmentWithResponse(Subsegment subsegment, SdkHttpResponse httpResponse) {
        if (subsegment == null || httpResponse == null) {
            return;
        }
        String extendedRequestId = this.extractExtendedRequestIdFromHttp(httpResponse);
        if (extendedRequestId != null) {
            subsegment.putAws("id_2", (Object)extendedRequestId);
        }
        subsegment.putAllHttp(this.extractHttpResponseParameters(httpResponse));
    }

    private AWSXRayRecorder getRecorder() {
        if (this.recorder == null) {
            this.recorder = AWSXRay.getGlobalRecorder();
        }
        return this.recorder;
    }
}

