/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.log4j;

import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.StringValidator;
import com.amazonaws.xray.listeners.SegmentListener;
import org.apache.logging.log4j.ThreadContext;

public class Log4JSegmentListener
implements SegmentListener {
    private static final String TRACE_ID_KEY = "AWS-XRAY-TRACE-ID";
    private String prefix;

    public Log4JSegmentListener() {
        this(TRACE_ID_KEY);
    }

    public Log4JSegmentListener(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void onSetEntity(Entity oldEntity, Entity newEntity) {
        Segment segment;
        if (newEntity == null) {
            ThreadContext.remove((String)TRACE_ID_KEY);
            return;
        }
        Segment segment2 = segment = newEntity instanceof Segment ? (Segment)newEntity : newEntity.getParentSegment();
        if (segment != null && segment.getTraceId() != null && segment.isSampled() && newEntity.getId() != null) {
            String fullPrefix = StringValidator.isNullOrBlank((String)this.prefix) ? "" : this.prefix + ": ";
            ThreadContext.put((String)TRACE_ID_KEY, (String)(fullPrefix + segment.getTraceId() + "@" + newEntity.getId()));
        } else {
            ThreadContext.remove((String)TRACE_ID_KEY);
        }
    }

    public void onClearEntity(Entity entity) {
        ThreadContext.remove((String)TRACE_ID_KEY);
    }
}

