/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.metrics;

import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.metrics.MetricFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EMFMetricFormatter
implements MetricFormatter {
    private static final Log logger = LogFactory.getLog(EMFMetricFormatter.class);
    private static final String EMF_FORMAT = "{\"Timestamp\":%d,\"log_group_name\":\"ServiceMetricsSDK\",\"CloudWatchMetrics\":[{\"Metrics\":[{\"Name\":\"ErrorRate\",\"Unit\":\"None\"},{\"Name\":\"FaultRate\",\"Unit\":\"None\"},{\"Name\":\"ThrottleRate\",\"Unit\":\"None\"},{\"Name\":\"OkRate\",\"Unit\":\"None\"},{\"Name\":\"Latency\",\"Unit\":\"Milliseconds\"}],\"Namespace\":\"ServiceMetrics/SDK\",\"Dimensions\":[[\"ServiceType\",\"ServiceName\"]]}],\"Latency\":%.3f,\"ErrorRate\":%d,\"FaultRate\":%d,\"ThrottleRate\":%d,\"OkRate\":%d,\"TraceId\":\"%s\",\"ServiceType\":\"%s\",\"ServiceName\":\"%s\",\"Version\":\"0\"}";

    @Override
    public String formatSegment(Segment segment) {
        int errorRate = segment.isError() ? 1 : 0;
        int faultRate = segment.isFault() ? 1 : 0;
        int throttleRate = segment.isThrottle() ? 1 : 0;
        int okRate = errorRate + faultRate + throttleRate > 0 ? 0 : 1;
        double duration = (segment.getEndTime() - segment.getStartTime()) * 1000.0;
        long endTimeMillis = (long)(segment.getEndTime() * 1000.0);
        String json = String.format(EMF_FORMAT, endTimeMillis, duration, errorRate, faultRate, throttleRate, okRate, segment.getTraceId().toString(), segment.getOrigin(), segment.getName());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Formatted segment " + segment.getName() + " as EMF: " + json));
        }
        return json;
    }
}

