/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.metrics;

import com.amazonaws.xray.config.MetricsDaemonConfiguration;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.metrics.EMFMetricFormatter;
import com.amazonaws.xray.metrics.MetricEmitter;
import com.amazonaws.xray.metrics.MetricFormatter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPMetricEmitter
implements MetricEmitter {
    private static final Log logger = LogFactory.getLog(UDPMetricEmitter.class);
    private static final int BUFFER_SIZE = 65536;
    private MetricFormatter formatter;
    private DatagramSocket socket;
    private InetSocketAddress address;
    private byte[] sendBuffer = new byte[65536];

    public UDPMetricEmitter() throws SocketException {
        MetricsDaemonConfiguration configuration = new MetricsDaemonConfiguration();
        this.formatter = new EMFMetricFormatter();
        try {
            this.socket = new DatagramSocket();
            this.address = configuration.getAddressForEmitter();
        }
        catch (SocketException e) {
            logger.error((Object)"Exception while instantiating daemon socket.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void emitMetric(Segment segment) {
        String formattedMetric = this.formatter.formatSegment(segment);
        DatagramPacket packet = new DatagramPacket(this.sendBuffer, 65536, this.address);
        packet.setData(formattedMetric.getBytes());
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            logger.error((Object)"Unable to send metric to agent.", (Throwable)e);
        }
    }
}

