/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.sql;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Namespace;
import com.amazonaws.xray.entities.Subsegment;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SqlSubsegments {
    private static final Log logger = LogFactory.getLog(SqlSubsegments.class);
    public static final String URL = "url";
    public static final String USER = "user";
    public static final String DRIVER_VERSION = "driver_version";
    public static final String DATABASE_TYPE = "database_type";
    public static final String DATABASE_VERSION = "database_version";
    public static final String SANITIZED_QUERY = "sanitized_query";
    public static final String DEFAULT_DATABASE_NAME = "database";

    public static Subsegment forQuery(Connection connection, @Nullable String query) {
        DatabaseMetaData metadata = null;
        String subsegmentName = DEFAULT_DATABASE_NAME;
        try {
            metadata = connection.getMetaData();
            String database = connection.getCatalog();
            URI normalizedUri = new URI(new URI(metadata.getURL()).getSchemeSpecificPart());
            subsegmentName = database + "@" + normalizedUri.getHost();
        }
        catch (URISyntaxException e) {
            logger.debug((Object)"Unable to parse database URI. Falling back to default 'database' for subsegment name.", (Throwable)e);
        }
        catch (SQLException e) {
            logger.debug((Object)"Encountered exception while retrieving metadata for SQL subsegment , starting blank subsegment instead");
            return AWSXRay.beginSubsegment((String)subsegmentName);
        }
        Subsegment subsegment = AWSXRay.beginSubsegment((String)subsegmentName);
        subsegment.setNamespace(Namespace.REMOTE.toString());
        try {
            subsegment.putSql(URL, (Object)metadata.getURL());
            subsegment.putSql(USER, (Object)metadata.getUserName());
            subsegment.putSql(DRIVER_VERSION, (Object)metadata.getDriverVersion());
            subsegment.putSql(DATABASE_TYPE, (Object)metadata.getDatabaseProductName());
            subsegment.putSql(DATABASE_VERSION, (Object)metadata.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            logger.debug((Object)"Encountered exception while populating SQL subsegment metadata", (Throwable)e);
        }
        if (query != null) {
            subsegment.putSql(SANITIZED_QUERY, (Object)query);
        }
        return subsegment;
    }

    private SqlSubsegments() {
    }
}

