/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.dynamodb.bootstrap;

import com.amazonaws.dynamodb.bootstrap.SegmentedScanResult;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractLogConsumer {
    public ExecutorCompletionService<Void> exec;
    protected ExecutorService threadPool;
    private static final Logger LOGGER = LogManager.getLogger(AbstractLogConsumer.class);

    public abstract Future<Void> writeResult(SegmentedScanResult var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean awaitTermination) {
        if (awaitTermination) {
            boolean interrupted = false;
            this.threadPool.shutdown();
            try {
                while (!this.threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.warn((Object)"Waiting for the threadpool to terminate...");
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
                LOGGER.warn((Object)("Threadpool was interrupted when trying to shutdown: " + e.getMessage()));
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            this.threadPool.shutdownNow();
        }
    }
}

