/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.dynamodb.bootstrap;

import com.amazonaws.dynamodb.bootstrap.AbstractLogConsumer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractLogProvider {
    private static final Logger LOGGER = LogManager.getLogger(AbstractLogProvider.class);
    protected ExecutorService threadPool;

    public abstract void pipe(AbstractLogConsumer var1) throws ExecutionException, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean awaitTermination) {
        if (awaitTermination) {
            boolean interrupted = false;
            this.threadPool.shutdown();
            try {
                while (!this.threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.info((Object)"Waiting for the threadpool to terminate...");
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
                LOGGER.warn((Object)("Threadpool was interrupted when trying to shutdown: " + e.getMessage()));
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            this.threadPool.shutdownNow();
        }
    }
}

