/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.dynamodb.bootstrap;

import com.amazonaws.dynamodb.bootstrap.DynamoDBEntryWithSize;
import com.amazonaws.dynamodb.bootstrap.ItemSizeCalculator;
import com.amazonaws.dynamodb.bootstrap.SegmentedScanResult;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class BlockingQueueWorker
implements Callable<Void> {
    private static final Logger LOGGER = LogManager.getLogger(BlockingQueueWorker.class);
    private final BlockingQueue<DynamoDBEntryWithSize> queue;
    private final SegmentedScanResult result;

    public BlockingQueueWorker(BlockingQueue<DynamoDBEntryWithSize> queue, SegmentedScanResult result) {
        this.queue = queue;
        this.result = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() {
        ScanResult scanResult = this.result.getScanResult();
        List items = scanResult.getItems();
        Iterator it = items.iterator();
        boolean interrupted = false;
        try {
            do {
                try {
                    Map item = (Map)it.next();
                    DynamoDBEntryWithSize entryWithSize = new DynamoDBEntryWithSize(item, ItemSizeCalculator.calculateItemSizeInBytes(item));
                    this.queue.put(entryWithSize);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    LOGGER.warn((Object)("interrupted when writing item to queue: " + e.getMessage()));
                }
            } while (it.hasNext());
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }
}

