/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.dynamodb.bootstrap;

import com.amazonaws.dynamodb.bootstrap.constants.BootstrapConstants;
import com.beust.jcommander.Parameter;

public class CommandLineArgs {
    public static final String HELP = "--help";
    @Parameter(names={"--help"}, description="Display usage information", help=true)
    private boolean help;
    public static final String SOURCE_ENDPOINT = "--sourceEndpoint";
    @Parameter(names={"--sourceEndpoint"}, description="Endpoint of the source table", required=true)
    private String sourceEndpoint;
    public static final String SOURCE_TABLE = "--sourceTable";
    @Parameter(names={"--sourceTable"}, description="Name of the source table", required=true)
    private String sourceTable;
    public static final String DESTINATION_ENDPOINT = "--destinationEndpoint";
    @Parameter(names={"--destinationEndpoint"}, description="Endpoint of the destination table", required=true)
    private String destinationEndpoint;
    public static final String DESTINATION_TABLE = "--destinationTable";
    @Parameter(names={"--destinationTable"}, description="Name of the destination table", required=true)
    private String destinationTable;
    public static final String READ_THROUGHPUT_RATIO = "--readThroughputRatio";
    @Parameter(names={"--readThroughputRatio"}, description="Percentage of total read throughput to scan the source table", required=true)
    private double readThroughputRatio;
    public static final String WRITE_THROUGHPUT_RATIO = "--writeThroughputRatio";
    @Parameter(names={"--writeThroughputRatio"}, description="Percentage of total write throughput to write the destination table", required=true)
    private double writeThroughputRatio;
    public static final String MAX_WRITE_THREADS = "--maxWriteThreads";
    @Parameter(names={"--maxWriteThreads"}, description="Number of max threads to write to destination table", required=false)
    private int maxWriteThreads = BootstrapConstants.DYNAMODB_CLIENT_EXECUTOR_MAX_POOL_SIZE;
    public static final String TOTAL_SECTIONS = "--totalSections";
    @Parameter(names={"--totalSections"}, description="Total number of sections to divide the scan into", required=false)
    private int totalSections = 1;
    public static final String SECTION = "--section";
    @Parameter(names={"--section"}, description="Section number to scan when running multiple programs concurrently [0, 1... totalSections-1]", required=false)
    private int section = 0;
    public static final String CONSISTENT_SCAN = "--consistentScan";
    @Parameter(names={"--consistentScan"}, description="Use this flag to use strongly consistent scan. If the flag is not used it will default to eventually consistent scan")
    private boolean consistentScan = false;

    public boolean getHelp() {
        return this.help;
    }

    public String getSourceEndpoint() {
        return this.sourceEndpoint;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public String getDestinationEndpoint() {
        return this.destinationEndpoint;
    }

    public String getDestinationTable() {
        return this.destinationTable;
    }

    public double getReadThroughputRatio() {
        return this.readThroughputRatio;
    }

    public double getWriteThroughputRatio() {
        return this.writeThroughputRatio;
    }

    public int getMaxWriteThreads() {
        return this.maxWriteThreads;
    }

    public int getTotalSections() {
        return this.totalSections;
    }

    public int getSection() {
        return this.section;
    }

    public boolean getConsistentScan() {
        return this.consistentScan;
    }
}

