/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.dynamodb.bootstrap;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.dynamodb.bootstrap.CommandLineArgs;
import com.amazonaws.dynamodb.bootstrap.DynamoDBBootstrapWorker;
import com.amazonaws.dynamodb.bootstrap.DynamoDBConsumer;
import com.amazonaws.dynamodb.bootstrap.constants.BootstrapConstants;
import com.amazonaws.dynamodb.bootstrap.exception.NullReadCapacityException;
import com.amazonaws.dynamodb.bootstrap.exception.SectionOutOfRangeException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CommandLineInterface {
    private static final Logger LOGGER = LogManager.getLogger(CommandLineInterface.class);

    public static void main(String[] args) {
        CommandLineArgs params = new CommandLineArgs();
        JCommander cmd = new JCommander((Object)params);
        try {
            cmd.parse(args);
        }
        catch (ParameterException e) {
            LOGGER.error((Object)e);
            JCommander.getConsole().println(e.getMessage());
            cmd.usage();
            System.exit(1);
        }
        if (params.getHelp()) {
            cmd.usage();
            return;
        }
        String sourceEndpoint = params.getSourceEndpoint();
        String destinationEndpoint = params.getDestinationEndpoint();
        String destinationTable = params.getDestinationTable();
        String sourceTable = params.getSourceTable();
        double readThroughputRatio = params.getReadThroughputRatio();
        double writeThroughputRatio = params.getWriteThroughputRatio();
        int maxWriteThreads = params.getMaxWriteThreads();
        boolean consistentScan = params.getConsistentScan();
        ClientConfiguration sourceConfig = new ClientConfiguration().withMaxConnections(5000);
        ClientConfiguration destinationConfig = new ClientConfiguration().withMaxConnections(5000);
        AmazonDynamoDBClient sourceClient = new AmazonDynamoDBClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), sourceConfig);
        AmazonDynamoDBClient destinationClient = new AmazonDynamoDBClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), destinationConfig);
        sourceClient.setEndpoint(sourceEndpoint);
        destinationClient.setEndpoint(destinationEndpoint);
        TableDescription readTableDescription = sourceClient.describeTable(sourceTable).getTable();
        TableDescription writeTableDescription = destinationClient.describeTable(destinationTable).getTable();
        int numSegments = 10;
        try {
            numSegments = DynamoDBBootstrapWorker.getNumberOfSegments(readTableDescription);
        }
        catch (NullReadCapacityException e) {
            LOGGER.warn((Object)("Number of segments not specified - defaulting to " + numSegments), (Throwable)e);
        }
        double readThroughput = CommandLineInterface.calculateThroughput(readTableDescription, readThroughputRatio, true);
        double writeThroughput = CommandLineInterface.calculateThroughput(writeTableDescription, writeThroughputRatio, false);
        try {
            ExecutorService sourceExec = CommandLineInterface.getSourceThreadPool(numSegments);
            ExecutorService destinationExec = CommandLineInterface.getDestinationThreadPool(maxWriteThreads);
            DynamoDBConsumer consumer = new DynamoDBConsumer(destinationClient, destinationTable, writeThroughput, destinationExec);
            DynamoDBBootstrapWorker worker = new DynamoDBBootstrapWorker(sourceClient, readThroughput, sourceTable, sourceExec, params.getSection(), params.getTotalSections(), numSegments, consistentScan);
            LOGGER.info((Object)"Starting transfer...");
            worker.pipe(consumer);
            LOGGER.info((Object)"Finished Copying Table.");
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Encountered exception when executing transfer.", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Interrupted when executing transfer.", (Throwable)e);
            System.exit(1);
        }
        catch (SectionOutOfRangeException e) {
            LOGGER.error((Object)"Invalid section parameter", (Throwable)e);
        }
    }

    private static double calculateThroughput(TableDescription tableDescription, double throughputRatio, boolean read) {
        if (read) {
            return (double)tableDescription.getProvisionedThroughput().getReadCapacityUnits().longValue() * throughputRatio;
        }
        return (double)tableDescription.getProvisionedThroughput().getWriteCapacityUnits().longValue() * throughputRatio;
    }

    private static ExecutorService getDestinationThreadPool(int maxWriteThreads) {
        int corePoolSize = BootstrapConstants.DYNAMODB_CLIENT_EXECUTOR_CORE_POOL_SIZE;
        if (corePoolSize > maxWriteThreads) {
            corePoolSize = maxWriteThreads - 1;
        }
        long keepAlive = 60000L;
        ThreadPoolExecutor exec = new ThreadPoolExecutor(corePoolSize, maxWriteThreads, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(maxWriteThreads), new ThreadPoolExecutor.CallerRunsPolicy());
        return exec;
    }

    private static ExecutorService getSourceThreadPool(int numSegments) {
        int corePoolSize = BootstrapConstants.DYNAMODB_CLIENT_EXECUTOR_CORE_POOL_SIZE;
        if (corePoolSize > numSegments) {
            corePoolSize = numSegments - 1;
        }
        long keepAlive = 60000L;
        ThreadPoolExecutor exec = new ThreadPoolExecutor(corePoolSize, numSegments, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(numSegments), new ThreadPoolExecutor.CallerRunsPolicy());
        return exec;
    }
}

