/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.dynamodb.bootstrap;

import com.amazonaws.dynamodb.bootstrap.AbstractLogConsumer;
import com.amazonaws.dynamodb.bootstrap.AbstractLogProvider;
import com.amazonaws.dynamodb.bootstrap.DynamoDBTableScan;
import com.amazonaws.dynamodb.bootstrap.ParallelScanExecutor;
import com.amazonaws.dynamodb.bootstrap.SegmentedScanResult;
import com.amazonaws.dynamodb.bootstrap.constants.BootstrapConstants;
import com.amazonaws.dynamodb.bootstrap.exception.NullReadCapacityException;
import com.amazonaws.dynamodb.bootstrap.exception.SectionOutOfRangeException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DynamoDBBootstrapWorker
extends AbstractLogProvider {
    private final AmazonDynamoDBClient client;
    private final double rateLimit;
    private final String tableName;
    private final int numSegments;
    private int section;
    private int totalSections;
    private final boolean consistentScan;

    public DynamoDBBootstrapWorker(AmazonDynamoDBClient client, double rateLimit, String tableName, ExecutorService exec, int section, int totalSections, int numSegments, boolean consistentScan) throws SectionOutOfRangeException {
        if (section > totalSections - 1 || section < 0) {
            throw new SectionOutOfRangeException("Section of scan must be within [0...totalSections-1]");
        }
        this.client = client;
        this.rateLimit = rateLimit;
        this.tableName = tableName;
        this.numSegments = numSegments;
        this.section = section;
        this.totalSections = totalSections;
        this.consistentScan = consistentScan;
        this.threadPool = exec;
    }

    public DynamoDBBootstrapWorker(AmazonDynamoDBClient client, double rateLimit, String tableName, int numThreads) throws NullReadCapacityException {
        this.client = client;
        this.rateLimit = rateLimit;
        this.tableName = tableName;
        TableDescription description = client.describeTable(tableName).getTable();
        this.section = 0;
        this.totalSections = 1;
        this.consistentScan = false;
        this.numSegments = DynamoDBBootstrapWorker.getNumberOfSegments(description);
        int numProcessors = Runtime.getRuntime().availableProcessors() * 4;
        if (numProcessors > numThreads) {
            numThreads = numProcessors;
        }
        this.threadPool = Executors.newFixedThreadPool(numThreads);
    }

    @Override
    public void pipe(AbstractLogConsumer consumer) throws ExecutionException, InterruptedException {
        DynamoDBTableScan scanner = new DynamoDBTableScan(this.rateLimit, this.client);
        ScanRequest request = new ScanRequest().withTableName(this.tableName).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL).withLimit(Integer.valueOf(1000)).withConsistentRead(Boolean.valueOf(this.consistentScan));
        ParallelScanExecutor scanService = scanner.getParallelScanCompletionService(request, this.numSegments, this.threadPool, this.section, this.totalSections);
        while (!scanService.finished()) {
            SegmentedScanResult result = scanService.grab();
            consumer.writeResult(result);
        }
        this.shutdown(true);
        consumer.shutdown(true);
    }

    public static int getNumberOfSegments(TableDescription description) throws NullReadCapacityException {
        ProvisionedThroughputDescription provisionedThroughput = description.getProvisionedThroughput();
        double tableSizeInGigabytes = Math.ceil((double)description.getTableSizeBytes().longValue() / BootstrapConstants.GIGABYTE);
        Long readCapacity = provisionedThroughput.getReadCapacityUnits();
        Long writeCapacity = provisionedThroughput.getWriteCapacityUnits();
        if (writeCapacity == null) {
            writeCapacity = 1L;
        }
        if (readCapacity == null) {
            throw new NullReadCapacityException("Cannot scan with a null readCapacity provisioned throughput");
        }
        double throughput = (double)(readCapacity + 3L * writeCapacity) / 3000.0;
        return (int)(10.0 * Math.max(Math.ceil(throughput), Math.ceil(tableSizeInGigabytes) / 10.0));
    }
}

