/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.dynamodb.bootstrap;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class DynamoDBConsumerWorker
implements Callable<Void> {
    private final AmazonDynamoDBClient client;
    private final RateLimiter rateLimiter;
    private long exponentialBackoffTime;
    private BatchWriteItemRequest batch;
    private final String tableName;

    public DynamoDBConsumerWorker(BatchWriteItemRequest batchWriteItemRequest, AmazonDynamoDBClient client, RateLimiter rateLimiter, String tableName) {
        this.batch = batchWriteItemRequest;
        this.client = client;
        this.rateLimiter = rateLimiter;
        this.tableName = tableName;
        this.exponentialBackoffTime = 128L;
    }

    @Override
    public Void call() {
        List<ConsumedCapacity> batchResult = this.runWithBackoff(this.batch);
        Iterator<ConsumedCapacity> it = batchResult.iterator();
        int consumedCapacity = 0;
        while (it.hasNext()) {
            consumedCapacity += it.next().getCapacityUnits().intValue();
        }
        this.rateLimiter.acquire(consumedCapacity);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConsumedCapacity> runWithBackoff(BatchWriteItemRequest req) {
        BatchWriteItemResult writeItemResult = null;
        LinkedList<ConsumedCapacity> consumedCapacities = new LinkedList<ConsumedCapacity>();
        Map unprocessedItems = null;
        boolean interrupted = false;
        try {
            do {
                writeItemResult = this.client.batchWriteItem(req);
                unprocessedItems = writeItemResult.getUnprocessedItems();
                consumedCapacities.addAll(writeItemResult.getConsumedCapacity());
                if (unprocessedItems == null) continue;
                req.setRequestItems(unprocessedItems);
                try {
                    Thread.sleep(this.exponentialBackoffTime);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                finally {
                    this.exponentialBackoffTime *= 2L;
                    if (this.exponentialBackoffTime > 2048L) {
                        this.exponentialBackoffTime = 2048L;
                    }
                }
            } while (unprocessedItems != null && unprocessedItems.get(this.tableName) != null);
            LinkedList<ConsumedCapacity> linkedList = consumedCapacities;
            return linkedList;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

