/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.dynamodb.bootstrap;

import com.amazonaws.dynamodb.bootstrap.ParallelScanExecutor;
import com.amazonaws.dynamodb.bootstrap.ScanSegmentWorker;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.Executor;

public class DynamoDBTableScan {
    private final RateLimiter rateLimiter;
    private final AmazonDynamoDBClient client;

    public DynamoDBTableScan(double rateLimit, AmazonDynamoDBClient client) {
        this.rateLimiter = RateLimiter.create((double)rateLimit);
        this.client = client;
    }

    public ParallelScanExecutor getParallelScanCompletionService(ScanRequest initialRequest, int numSegments, Executor executor, int section, int totalSections) {
        int segments = Math.max(1, numSegments);
        ParallelScanExecutor completion = new ParallelScanExecutor(executor, segments);
        int sectionSize = segments / totalSections;
        int start = sectionSize * section;
        int end = start + sectionSize;
        if (section + 1 == totalSections) {
            end = segments;
        }
        for (int segment = start; segment < end; ++segment) {
            ScanRequest scanSegment = this.copyScanRequest(initialRequest).withTotalSegments(Integer.valueOf(segments)).withSegment(Integer.valueOf(segment));
            completion.addWorker(new ScanSegmentWorker(this.client, this.rateLimiter, scanSegment), segment);
        }
        return completion;
    }

    public ScanRequest copyScanRequest(ScanRequest request) {
        return new ScanRequest().withTableName(request.getTableName()).withTotalSegments(request.getTotalSegments()).withSegment(request.getSegment()).withReturnConsumedCapacity(request.getReturnConsumedCapacity()).withLimit(request.getLimit()).withConsistentRead(request.getConsistentRead());
    }
}

