/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.dynamodb.bootstrap;

import com.amazonaws.dynamodb.bootstrap.constants.BootstrapConstants;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ItemSizeCalculator {
    public static int calculateItemSizeInBytes(Map<String, AttributeValue> item) {
        int size = 0;
        if (item == null) {
            return size;
        }
        for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
            String name = entry.getKey();
            AttributeValue value = entry.getValue();
            size += name.getBytes(BootstrapConstants.UTF8).length;
            size += ItemSizeCalculator.calculateAttributeSizeInBytes(value);
        }
        return size;
    }

    public static int calculateScanResultSizeInBytes(ScanResult result) {
        Iterator it = result.getItems().iterator();
        int totalBytes = 0;
        while (it.hasNext()) {
            totalBytes += ItemSizeCalculator.calculateItemSizeInBytes((Map)it.next());
        }
        return totalBytes;
    }

    private static int calculateAttributeSizeInBytes(AttributeValue value) {
        int attrValSize = 0;
        if (value == null) {
            return attrValSize;
        }
        if (value.getB() != null) {
            ByteBuffer b = value.getB();
            attrValSize += b.remaining();
        } else if (value.getS() != null) {
            String s = value.getS();
            attrValSize += s.getBytes(BootstrapConstants.UTF8).length;
        } else if (value.getN() != null) {
            attrValSize += 21;
        } else if (value.getBS() != null) {
            List bs = value.getBS();
            for (ByteBuffer b : bs) {
                if (b == null) continue;
                attrValSize += b.remaining();
            }
        } else if (value.getSS() != null) {
            List ss = value.getSS();
            for (String s : ss) {
                if (s == null) continue;
                attrValSize += s.getBytes(BootstrapConstants.UTF8).length;
            }
        } else if (value.getNS() != null) {
            List ns = value.getNS();
            for (String n : ns) {
                if (n == null) continue;
                attrValSize += 21;
            }
        } else if (value.getBOOL() != null) {
            ++attrValSize;
        } else if (value.getNULL() != null) {
            ++attrValSize;
        } else if (value.getM() != null) {
            for (Map.Entry entry : value.getM().entrySet()) {
                attrValSize += ((String)entry.getKey()).getBytes(BootstrapConstants.UTF8).length;
                attrValSize += ItemSizeCalculator.calculateAttributeSizeInBytes((AttributeValue)entry.getValue());
                ++attrValSize;
            }
            attrValSize += 3;
        } else if (value.getL() != null) {
            List list = value.getL();
            Integer i = 0;
            while (i < list.size()) {
                attrValSize += ItemSizeCalculator.calculateAttributeSizeInBytes((AttributeValue)list.get(i));
                ++attrValSize;
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            attrValSize += 3;
        }
        return attrValSize;
    }
}

