/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.dynamodb.bootstrap;

import com.amazonaws.dynamodb.bootstrap.ScanSegmentWorker;
import com.amazonaws.dynamodb.bootstrap.SegmentedScanResult;
import java.util.BitSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;

public class ParallelScanExecutor {
    private final BitSet finished;
    private final ScanSegmentWorker[] workers;
    private final ExecutorCompletionService<SegmentedScanResult> exec;

    public ParallelScanExecutor(Executor executor, int segments) {
        this.exec = new ExecutorCompletionService(executor);
        this.finished = new BitSet(segments);
        this.finished.clear();
        this.workers = new ScanSegmentWorker[segments];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishSegment(int segment) {
        BitSet bitSet = this.finished;
        synchronized (bitSet) {
            if (segment > this.finished.size()) {
                throw new IllegalArgumentException("Invalid segment passed to finishSegment");
            }
            this.finished.set(segment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finished() {
        BitSet bitSet = this.finished;
        synchronized (bitSet) {
            return this.finished.cardinality() == this.workers.length;
        }
    }

    public SegmentedScanResult grab() throws ExecutionException, InterruptedException {
        Future<SegmentedScanResult> ret = this.exec.take();
        int segment = ret.get().getSegment();
        ScanSegmentWorker sw = this.workers[segment];
        if (sw.hasNext()) {
            this.exec.submit(sw);
        } else {
            this.finishSegment(segment);
        }
        return ret.get();
    }

    public void addWorker(ScanSegmentWorker ssw, int segment) {
        this.workers[segment] = ssw;
        this.exec.submit(ssw);
    }
}

