/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.dynamodb.bootstrap;

import com.amazonaws.dynamodb.bootstrap.ItemSizeCalculator;
import com.amazonaws.dynamodb.bootstrap.SegmentedScanResult;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.Callable;

public class ScanSegmentWorker
implements Callable<SegmentedScanResult> {
    private final ScanRequest request;
    private boolean hasNext;
    private int lastConsumedCapacity;
    private long exponentialBackoffTime;
    private final AmazonDynamoDBClient client;
    private final RateLimiter rateLimiter;

    ScanSegmentWorker(AmazonDynamoDBClient client, RateLimiter rateLimiter, ScanRequest request) {
        this.request = request;
        this.client = client;
        this.rateLimiter = rateLimiter;
        this.hasNext = true;
        this.exponentialBackoffTime = 128L;
        this.lastConsumedCapacity = 256;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public SegmentedScanResult call() {
        ScanResult result = null;
        result = this.runWithBackoff();
        ConsumedCapacity cc = result.getConsumedCapacity();
        if (cc != null && cc.getCapacityUnits() != null) {
            this.lastConsumedCapacity = result.getConsumedCapacity().getCapacityUnits().intValue();
        } else if (result.getScannedCount() != null && result.getCount() != null) {
            boolean isConsistent = this.request.getConsistentRead();
            int itemSize = isConsistent ? 4096 : 8192;
            this.lastConsumedCapacity = result.getScannedCount() / (int)Math.max(1.0, (double)result.getCount().intValue()) * (ItemSizeCalculator.calculateScanResultSizeInBytes(result) / itemSize);
        }
        if (result.getLastEvaluatedKey() != null && !result.getLastEvaluatedKey().isEmpty()) {
            this.hasNext = true;
            this.request.setExclusiveStartKey(result.getLastEvaluatedKey());
        } else {
            this.hasNext = false;
        }
        if (this.lastConsumedCapacity > 0) {
            this.rateLimiter.acquire(this.lastConsumedCapacity);
        }
        return new SegmentedScanResult(result, this.request.getSegment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult runWithBackoff() {
        ScanResult result = null;
        boolean interrupted = false;
        try {
            do {
                try {
                    result = this.client.scan(this.request);
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(this.exponentialBackoffTime);
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                    finally {
                        this.exponentialBackoffTime *= 2L;
                    }
                }
            } while (result == null);
            ScanResult scanResult = result;
            return scanResult;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

