/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.services.dynamodbv2.LockItemFactory;
import com.amazonaws.services.dynamodbv2.LockItemPaginatedIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

final class LockItemPaginatedScanIterator
extends LockItemPaginatedIterator {
    private final DynamoDbClient dynamoDB;
    private volatile ScanRequest scanRequest;
    private final LockItemFactory lockItemFactory;
    private volatile ScanResponse scanResponse = null;

    LockItemPaginatedScanIterator(DynamoDbClient dynamoDB, ScanRequest scanRequest, LockItemFactory lockItemFactory) {
        this.dynamoDB = Objects.requireNonNull(dynamoDB, "dynamoDB must not be null");
        this.scanRequest = Objects.requireNonNull(scanRequest, "scanRequest must not be null");
        this.lockItemFactory = Objects.requireNonNull(lockItemFactory, "lockItemFactory must not be null");
    }

    @Override
    protected boolean hasAnotherPageToLoad() {
        if (!this.hasLoadedFirstPage()) {
            return true;
        }
        return this.scanResponse.lastEvaluatedKey() != null && !this.scanResponse.lastEvaluatedKey().isEmpty();
    }

    @Override
    protected boolean hasLoadedFirstPage() {
        return this.scanResponse != null;
    }

    @Override
    protected void loadNextPageIntoResults() {
        this.scanResponse = this.dynamoDB.scan(this.scanRequest);
        this.currentPageResults = this.scanResponse.items().stream().map(this.lockItemFactory::create).collect(Collectors.toList());
        this.currentPageResultsIndex = 0;
        this.scanRequest = (ScanRequest)ScanRequest.builder().tableName(this.scanRequest.tableName()).exclusiveStartKey(this.scanResponse.lastEvaluatedKey()).build();
    }
}

