/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.regions.Region;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClient;
import com.amazonaws.services.dynamodbv2.model.DescribeStreamRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeStreamResult;
import com.amazonaws.services.dynamodbv2.model.GetShardIteratorResult;
import com.amazonaws.services.dynamodbv2.model.ListStreamsRequest;
import com.amazonaws.services.dynamodbv2.model.Record;
import com.amazonaws.services.dynamodbv2.model.Shard;
import com.amazonaws.services.dynamodbv2.model.StreamDescription;
import com.amazonaws.services.dynamodbv2.model.StreamRecord;
import com.amazonaws.services.dynamodbv2.model.TrimmedDataAccessException;
import com.amazonaws.services.dynamodbv2.streamsadapter.AdapterRequestCache;
import com.amazonaws.services.dynamodbv2.streamsadapter.model.AmazonServiceExceptionTransformer;
import com.amazonaws.services.dynamodbv2.streamsadapter.model.DescribeStreamRequestAdapter;
import com.amazonaws.services.dynamodbv2.streamsadapter.model.DescribeStreamResultAdapter;
import com.amazonaws.services.dynamodbv2.streamsadapter.model.GetRecordsRequestAdapter;
import com.amazonaws.services.dynamodbv2.streamsadapter.model.GetRecordsResultAdapter;
import com.amazonaws.services.dynamodbv2.streamsadapter.model.GetShardIteratorRequestAdapter;
import com.amazonaws.services.dynamodbv2.streamsadapter.model.GetShardIteratorResultAdapter;
import com.amazonaws.services.dynamodbv2.streamsadapter.model.ListStreamsRequestAdapter;
import com.amazonaws.services.dynamodbv2.streamsadapter.model.ListStreamsResultAdapter;
import com.amazonaws.services.kinesis.AbstractAmazonKinesis;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsScope;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import com.amazonaws.services.kinesis.model.AddTagsToStreamRequest;
import com.amazonaws.services.kinesis.model.AddTagsToStreamResult;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.CreateStreamResult;
import com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodResult;
import com.amazonaws.services.kinesis.model.DeleteStreamRequest;
import com.amazonaws.services.kinesis.model.DeleteStreamResult;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodResult;
import com.amazonaws.services.kinesis.model.ListStreamsResult;
import com.amazonaws.services.kinesis.model.ListTagsForStreamRequest;
import com.amazonaws.services.kinesis.model.ListTagsForStreamResult;
import com.amazonaws.services.kinesis.model.MergeShardsRequest;
import com.amazonaws.services.kinesis.model.MergeShardsResult;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.RemoveTagsFromStreamRequest;
import com.amazonaws.services.kinesis.model.RemoveTagsFromStreamResult;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import com.amazonaws.services.kinesis.model.SplitShardRequest;
import com.amazonaws.services.kinesis.model.SplitShardResult;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonDynamoDBStreamsAdapterClient
extends AbstractAmazonKinesis {
    private static final int REQUEST_CACHE_CAPACITY = 50;
    private static final Log LOG = LogFactory.getLog(AmazonDynamoDBStreamsAdapterClient.class);
    public static final Integer GET_RECORDS_LIMIT = 1000;
    private final AmazonDynamoDBStreams internalClient;
    private final AdapterRequestCache requestCache = new AdapterRequestCache(50);
    private static final String MILLIS_BEHIND_LATEST_METRIC = "MillisBehindLatest";
    private SkipRecordsBehavior skipRecordsBehavior = SkipRecordsBehavior.SKIP_RECORDS_TO_TRIM_HORIZON;
    private boolean generateRecordBytes = true;

    public AmazonDynamoDBStreamsAdapterClient() {
        this.internalClient = new AmazonDynamoDBStreamsClient();
    }

    public AmazonDynamoDBStreamsAdapterClient(ClientConfiguration clientConfiguration) {
        this.internalClient = new AmazonDynamoDBStreamsClient(clientConfiguration);
    }

    public AmazonDynamoDBStreamsAdapterClient(AWSCredentials awsCredentials) {
        this.internalClient = new AmazonDynamoDBStreamsClient(awsCredentials);
    }

    public AmazonDynamoDBStreamsAdapterClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        this.internalClient = new AmazonDynamoDBStreamsClient(awsCredentials, clientConfiguration);
    }

    public AmazonDynamoDBStreamsAdapterClient(AWSCredentialsProvider awsCredentialsProvider) {
        this.internalClient = new AmazonDynamoDBStreamsClient(awsCredentialsProvider);
    }

    public AmazonDynamoDBStreamsAdapterClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this.internalClient = new AmazonDynamoDBStreamsClient(awsCredentialsProvider, clientConfiguration);
    }

    public AmazonDynamoDBStreamsAdapterClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        this.internalClient = new AmazonDynamoDBStreamsClient(awsCredentialsProvider, clientConfiguration, requestMetricCollector);
    }

    public AmazonDynamoDBStreamsAdapterClient(AmazonDynamoDBStreams amazonDynamoDBStreams) {
        this.internalClient = amazonDynamoDBStreams;
    }

    public void setEndpoint(String endpoint) {
        this.internalClient.setEndpoint(endpoint);
    }

    public void setRegion(Region region) {
        this.internalClient.setRegion(region);
    }

    public void setGenerateRecordBytes(boolean generateRecordBytes) {
        this.generateRecordBytes = generateRecordBytes;
    }

    public com.amazonaws.services.kinesis.model.DescribeStreamResult describeStream(com.amazonaws.services.kinesis.model.DescribeStreamRequest describeStreamRequest) {
        DescribeStreamResult result;
        DescribeStreamRequestAdapter requestAdapter = new DescribeStreamRequestAdapter(describeStreamRequest);
        this.requestCache.addEntry((AmazonWebServiceRequest)describeStreamRequest, (AmazonWebServiceRequest)requestAdapter);
        try {
            result = this.internalClient.describeStream((DescribeStreamRequest)requestAdapter);
        }
        catch (AmazonServiceException e) {
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisDescribeStream(e);
        }
        if (result.getStreamDescription().getStreamStatus().equals("DISABLED")) {
            List<Shard> allShards = this.getAllShardsForDisabledStream(result);
            this.markLeafShardsAsActive(allShards);
            StreamDescription newStreamDescription = new StreamDescription().withShards(allShards).withLastEvaluatedShardId(null).withCreationRequestDateTime(result.getStreamDescription().getCreationRequestDateTime()).withKeySchema((Collection)result.getStreamDescription().getKeySchema()).withStreamArn(result.getStreamDescription().getStreamArn()).withStreamLabel(result.getStreamDescription().getStreamLabel()).withStreamStatus(result.getStreamDescription().getStreamStatus()).withTableName(result.getStreamDescription().getTableName()).withStreamViewType(result.getStreamDescription().getStreamViewType());
            result = new DescribeStreamResult().withStreamDescription(newStreamDescription);
        }
        return new DescribeStreamResultAdapter(result);
    }

    private List<Shard> getAllShardsForDisabledStream(DescribeStreamResult initialResult) {
        ArrayList<Shard> shards = new ArrayList<Shard>();
        shards.addAll(initialResult.getStreamDescription().getShards());
        DescribeStreamResult result = initialResult;
        while (result.getStreamDescription().getLastEvaluatedShardId() != null) {
            DescribeStreamRequest request = new DescribeStreamRequest().withStreamArn(result.getStreamDescription().getStreamArn()).withExclusiveStartShardId(result.getStreamDescription().getLastEvaluatedShardId());
            try {
                result = this.internalClient.describeStream(request);
            }
            catch (AmazonServiceException e) {
                throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisDescribeStream(e);
            }
            shards.addAll(result.getStreamDescription().getShards());
        }
        return shards;
    }

    private void markLeafShardsAsActive(List<Shard> shards) {
        ArrayList<String> parentShardIds = new ArrayList<String>();
        for (Shard shard : shards) {
            if (shard.getParentShardId() == null) continue;
            parentShardIds.add(shard.getParentShardId());
        }
        for (Shard shard : shards) {
            if (parentShardIds.contains(shard.getShardId())) continue;
            shard.getSequenceNumberRange().setEndingSequenceNumber(null);
        }
    }

    public com.amazonaws.services.kinesis.model.DescribeStreamResult describeStream(String streamName) {
        return this.describeStream(streamName, null, null);
    }

    public com.amazonaws.services.kinesis.model.DescribeStreamResult describeStream(String streamName, String exclusiveStartShardId) {
        return this.describeStream(streamName, null, exclusiveStartShardId);
    }

    public com.amazonaws.services.kinesis.model.DescribeStreamResult describeStream(String streamName, Integer limit, String exclusiveStartShardId) {
        com.amazonaws.services.kinesis.model.DescribeStreamRequest request = new com.amazonaws.services.kinesis.model.DescribeStreamRequest();
        request.setStreamName(streamName);
        request.setLimit(limit);
        request.setExclusiveStartShardId(exclusiveStartShardId);
        return this.describeStream(request);
    }

    public com.amazonaws.services.kinesis.model.GetShardIteratorResult getShardIterator(GetShardIteratorRequest getShardIteratorRequest) {
        GetShardIteratorRequestAdapter requestAdapter = new GetShardIteratorRequestAdapter(getShardIteratorRequest);
        this.requestCache.addEntry((AmazonWebServiceRequest)getShardIteratorRequest, (AmazonWebServiceRequest)requestAdapter);
        try {
            GetShardIteratorResult result = this.internalClient.getShardIterator((com.amazonaws.services.dynamodbv2.model.GetShardIteratorRequest)requestAdapter);
            if (result != null && result.getShardIterator() == null && result.getSdkResponseMetadata() != null) {
                LOG.info((Object)("RequestId for getShardIterator call which resulted in ShardEnd: " + result.getSdkResponseMetadata().getRequestId()));
            }
            return new GetShardIteratorResultAdapter(result);
        }
        catch (TrimmedDataAccessException e) {
            if (this.skipRecordsBehavior == SkipRecordsBehavior.SKIP_RECORDS_TO_TRIM_HORIZON) {
                if (getShardIteratorRequest.getShardIteratorType().equals(ShardIteratorType.TRIM_HORIZON.toString())) {
                    throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisGetShardIterator((AmazonServiceException)((Object)e), this.skipRecordsBehavior);
                }
                LOG.warn((Object)String.format("Data has been trimmed. Intercepting DynamoDB exception and retrieving a fresh iterator %s", getShardIteratorRequest), (Throwable)e);
                getShardIteratorRequest.setShardIteratorType(ShardIteratorType.TRIM_HORIZON);
                getShardIteratorRequest.setStartingSequenceNumber(null);
                return this.getShardIterator(getShardIteratorRequest);
            }
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisGetShardIterator((AmazonServiceException)((Object)e), this.skipRecordsBehavior);
        }
        catch (AmazonServiceException e) {
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisGetShardIterator(e, this.skipRecordsBehavior);
        }
    }

    public com.amazonaws.services.kinesis.model.GetShardIteratorResult getShardIterator(String streamName, String shardId, String shardIteratorType) {
        return this.getShardIterator(streamName, shardId, shardIteratorType, null);
    }

    public com.amazonaws.services.kinesis.model.GetShardIteratorResult getShardIterator(String streamName, String shardId, String shardIteratorType, String startingSequenceNumber) {
        GetShardIteratorRequest request = new GetShardIteratorRequest();
        request.setStreamName(streamName);
        request.setShardId(shardId);
        request.setShardIteratorType(shardIteratorType);
        request.setStartingSequenceNumber(startingSequenceNumber);
        return this.getShardIterator(request);
    }

    public PutRecordResult putRecord(PutRecordRequest putRecordRequest) {
        throw new UnsupportedOperationException();
    }

    public PutRecordResult putRecord(String streamName, ByteBuffer data, String partitionKey) {
        throw new UnsupportedOperationException();
    }

    public PutRecordResult putRecord(String streamName, ByteBuffer data, String partitionKey, String sequenceNumberForOrdering) {
        throw new UnsupportedOperationException();
    }

    public PutRecordsResult putRecords(PutRecordsRequest putRecordsRequest) {
        throw new UnsupportedOperationException();
    }

    public GetRecordsResult getRecords(GetRecordsRequest getRecordsRequest) {
        if (getRecordsRequest.getLimit() != null && getRecordsRequest.getLimit() > GET_RECORDS_LIMIT) {
            getRecordsRequest.setLimit(GET_RECORDS_LIMIT);
        }
        GetRecordsRequestAdapter requestAdapter = new GetRecordsRequestAdapter(getRecordsRequest);
        this.requestCache.addEntry((AmazonWebServiceRequest)getRecordsRequest, (AmazonWebServiceRequest)requestAdapter);
        try {
            com.amazonaws.services.dynamodbv2.model.GetRecordsResult result = this.internalClient.getRecords((com.amazonaws.services.dynamodbv2.model.GetRecordsRequest)requestAdapter);
            List records = result.getRecords();
            if (records != null && !records.isEmpty()) {
                int lastIndex = result.getRecords().size() - 1;
                StreamRecord lastStreamRecord = ((Record)result.getRecords().get(lastIndex)).getDynamodb();
                double lastApproximateCreationTimestamp = lastStreamRecord.getApproximateCreationDateTime().getTime();
                double millisBehindLatest = Math.max((double)System.currentTimeMillis() - lastApproximateCreationTimestamp, 0.0);
                IMetricsScope scope = MetricsHelper.getMetricsScope();
                scope.addData(MILLIS_BEHIND_LATEST_METRIC, millisBehindLatest, StandardUnit.Milliseconds, MetricsLevel.SUMMARY);
            }
            if (result != null && result.getNextShardIterator() == null && result.getSdkResponseMetadata() != null) {
                LOG.info((Object)("RequestId for getRecords which resulted in ShardEnd: " + result.getSdkResponseMetadata().getRequestId()));
            }
            return new GetRecordsResultAdapter(result, this.generateRecordBytes);
        }
        catch (AmazonServiceException e) {
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisGetRecords(e, this.skipRecordsBehavior);
        }
    }

    public SplitShardResult splitShard(SplitShardRequest splitShardRequest) {
        throw new UnsupportedOperationException();
    }

    public SplitShardResult splitShard(String streamName, String shardToSplit, String newStartingHashKey) {
        throw new UnsupportedOperationException();
    }

    public CreateStreamResult createStream(CreateStreamRequest createStreamRequest) {
        throw new UnsupportedOperationException();
    }

    public CreateStreamResult createStream(String streamName, Integer shardCount) {
        throw new UnsupportedOperationException();
    }

    public DeleteStreamResult deleteStream(DeleteStreamRequest deleteStreamRequest) {
        throw new UnsupportedOperationException();
    }

    public DeleteStreamResult deleteStream(String streamName) {
        throw new UnsupportedOperationException();
    }

    public ListStreamsResult listStreams(com.amazonaws.services.kinesis.model.ListStreamsRequest listStreamsRequest) {
        ListStreamsRequestAdapter requestAdapter = new ListStreamsRequestAdapter(listStreamsRequest);
        this.requestCache.addEntry((AmazonWebServiceRequest)listStreamsRequest, (AmazonWebServiceRequest)requestAdapter);
        try {
            com.amazonaws.services.dynamodbv2.model.ListStreamsResult result = this.internalClient.listStreams((ListStreamsRequest)requestAdapter);
            return new ListStreamsResultAdapter(result);
        }
        catch (AmazonServiceException e) {
            throw AmazonServiceExceptionTransformer.transformDynamoDBStreamsToKinesisListStreams(e);
        }
    }

    public ListStreamsResult listStreams() {
        return this.listStreams(null, null);
    }

    public ListStreamsResult listStreams(String exclusiveStartStreamName) {
        return this.listStreams(null, exclusiveStartStreamName);
    }

    public ListStreamsResult listStreams(Integer limit, String exclusiveStartStreamName) {
        com.amazonaws.services.kinesis.model.ListStreamsRequest request = new com.amazonaws.services.kinesis.model.ListStreamsRequest();
        request.setLimit(limit);
        request.setExclusiveStartStreamName(exclusiveStartStreamName);
        return this.listStreams(request);
    }

    public MergeShardsResult mergeShards(MergeShardsRequest mergeShardsRequest) {
        throw new UnsupportedOperationException();
    }

    public MergeShardsResult mergeShards(String streamName, String shardToMerge, String adjacentShardToMerge) {
        throw new UnsupportedOperationException();
    }

    public AddTagsToStreamResult addTagsToStream(AddTagsToStreamRequest addTagsToStreamRequest) {
        throw new UnsupportedOperationException();
    }

    public ListTagsForStreamResult listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) {
        throw new UnsupportedOperationException();
    }

    public RemoveTagsFromStreamResult removeTagsFromStream(RemoveTagsFromStreamRequest removeTagsFromStreamRequest) {
        throw new UnsupportedOperationException();
    }

    public void shutdown() {
        this.internalClient.shutdown();
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.internalClient.getCachedResponseMetadata(this.requestCache.getEntry(request));
    }

    public SkipRecordsBehavior getSkipRecordsBehavior() {
        return this.skipRecordsBehavior;
    }

    public void setSkipRecordsBehavior(SkipRecordsBehavior skipRecordsBehavior) {
        if (skipRecordsBehavior == null) {
            throw new NullPointerException("skipRecordsBehavior cannot be null");
        }
        this.skipRecordsBehavior = skipRecordsBehavior;
    }

    public DecreaseStreamRetentionPeriodResult decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) {
        throw new UnsupportedOperationException();
    }

    public IncreaseStreamRetentionPeriodResult increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) {
        throw new UnsupportedOperationException();
    }

    public static enum SkipRecordsBehavior {
        SKIP_RECORDS_TO_TRIM_HORIZON,
        KCL_RETRY;

    }
}

