/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.IPeriodicShardSyncManager;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaderDecider;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.MetricsCollectingTaskDecorator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import com.amazonaws.util.CollectionUtils;
import com.google.common.annotations.VisibleForTesting;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamoDBStreamsPeriodicShardSyncManager
implements IPeriodicShardSyncManager {
    private static final Log LOG = LogFactory.getLog(DynamoDBStreamsPeriodicShardSyncManager.class);
    private static final long INITIAL_DELAY = 0L;
    private static final long DEFAULT_PERIODIC_SHARD_SYNC_INTERVAL_MILLIS = 1000L;
    @VisibleForTesting
    static final BigInteger MIN_HASH_KEY = BigInteger.ZERO;
    @VisibleForTesting
    static final BigInteger MAX_HASH_KEY = new BigInteger("2").pow(128).subtract(BigInteger.ONE);
    static final String PERIODIC_SHARD_SYNC_MANAGER = "PeriodicShardSyncManager";
    private final String workerId;
    private final LeaderDecider leaderDecider;
    private final ITask metricsEmittingShardSyncTask;
    private final ScheduledExecutorService shardSyncThreadPool;
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private final IKinesisProxy kinesisProxy;
    private final boolean isAuditorMode;
    private final long periodicShardSyncIntervalMillis;
    private boolean isRunning;
    private final IMetricsFactory metricsFactory;
    private final int leasesRecoveryAuditorInconsistencyConfidenceThreshold;

    DynamoDBStreamsPeriodicShardSyncManager(String workerId, LeaderDecider leaderDecider, ShardSyncTask shardSyncTask, IMetricsFactory metricsFactory, ILeaseManager<KinesisClientLease> leaseManager, IKinesisProxy kinesisProxy, boolean isAuditorMode, long leasesRecoveryAuditorExecutionFrequencyMillis, int leasesRecoveryAuditorInconsistencyConfidenceThreshold) {
        this(workerId, leaderDecider, shardSyncTask, Executors.newSingleThreadScheduledExecutor(), metricsFactory, leaseManager, kinesisProxy, isAuditorMode, leasesRecoveryAuditorExecutionFrequencyMillis, leasesRecoveryAuditorInconsistencyConfidenceThreshold);
    }

    DynamoDBStreamsPeriodicShardSyncManager(String workerId, LeaderDecider leaderDecider, ShardSyncTask shardSyncTask, ScheduledExecutorService shardSyncThreadPool, IMetricsFactory metricsFactory, ILeaseManager<KinesisClientLease> leaseManager, IKinesisProxy kinesisProxy, boolean isAuditorMode, long leasesRecoveryAuditorExecutionFrequencyMillis, int leasesRecoveryAuditorInconsistencyConfidenceThreshold) {
        Validate.notBlank((CharSequence)workerId, (String)"WorkerID is required to initialize PeriodicShardSyncManager.", (Object[])new Object[0]);
        Validate.notNull((Object)leaderDecider, (String)"LeaderDecider is required to initialize PeriodicShardSyncManager.", (Object[])new Object[0]);
        Validate.notNull((Object)shardSyncTask, (String)"ShardSyncTask is required to initialize PeriodicShardSyncManager.", (Object[])new Object[0]);
        this.workerId = workerId;
        this.leaderDecider = leaderDecider;
        this.metricsEmittingShardSyncTask = new MetricsCollectingTaskDecorator((ITask)shardSyncTask, metricsFactory);
        this.shardSyncThreadPool = shardSyncThreadPool;
        this.leaseManager = leaseManager;
        this.kinesisProxy = kinesisProxy;
        this.metricsFactory = metricsFactory;
        this.isAuditorMode = isAuditorMode;
        this.leasesRecoveryAuditorInconsistencyConfidenceThreshold = leasesRecoveryAuditorInconsistencyConfidenceThreshold;
        if (isAuditorMode) {
            Validate.notNull(this.leaseManager, (String)"LeaseManager is required for non-PERIODIC shard sync strategies.", (Object[])new Object[0]);
            Validate.notNull((Object)this.kinesisProxy, (String)"KinesisProxy is required for non-PERIODIC shard sync strategies.", (Object[])new Object[0]);
            this.periodicShardSyncIntervalMillis = leasesRecoveryAuditorExecutionFrequencyMillis;
        } else {
            this.periodicShardSyncIntervalMillis = 1000L;
        }
    }

    public synchronized TaskResult start() {
        if (!this.isRunning) {
            Runnable periodicShardSyncer = () -> {
                try {
                    this.runShardSync();
                }
                catch (Throwable t) {
                    LOG.error((Object)"Error running shard sync.", t);
                }
            };
            this.shardSyncThreadPool.scheduleWithFixedDelay(periodicShardSyncer, 0L, this.periodicShardSyncIntervalMillis, TimeUnit.MILLISECONDS);
            this.isRunning = true;
        }
        return new TaskResult(null);
    }

    public synchronized TaskResult syncShardsOnce() {
        LOG.info((Object)("Syncing shards once from worker " + this.workerId));
        return this.metricsEmittingShardSyncTask.call();
    }

    public void stop() {
        if (this.isRunning) {
            LOG.info((Object)String.format("Shutting down leader decider on worker %s", this.workerId));
            this.leaderDecider.shutdown();
            LOG.info((Object)String.format("Shutting down periodic shard sync task scheduler on worker %s", this.workerId));
            this.shardSyncThreadPool.shutdown();
            this.isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runShardSync() {
        if (this.leaderDecider.isLeader(this.workerId).booleanValue()) {
            LOG.debug((Object)("WorkerId " + this.workerId + " is a leader, running the shard sync task"));
            MetricsHelper.startScope((IMetricsFactory)this.metricsFactory, (String)PERIODIC_SHARD_SYNC_MANAGER);
            boolean isRunSuccess = false;
            long runStartMillis = System.currentTimeMillis();
            try {
                IPeriodicShardSyncManager.ShardSyncResponse shardSyncResponse = this.checkForShardSync();
                MetricsHelper.getMetricsScope().addData("NumStreamsToSync", shardSyncResponse.shouldDoShardSync() ? 1.0 : 0.0, StandardUnit.Count, MetricsLevel.SUMMARY);
                if (shardSyncResponse.shouldDoShardSync()) {
                    LOG.info((Object)("Periodic shard syncer initiating shard sync due to the reason - " + shardSyncResponse.reasonForDecision()));
                    this.metricsEmittingShardSyncTask.call();
                } else {
                    LOG.info((Object)("Skipping shard sync due to the reason - " + shardSyncResponse.reasonForDecision()));
                }
                isRunSuccess = true;
            }
            catch (Exception e) {
                LOG.error((Object)"Caught exception while running periodic shard syncer.", (Throwable)e);
            }
            finally {
                MetricsHelper.addSuccessAndLatency((long)runStartMillis, (boolean)isRunSuccess, (MetricsLevel)MetricsLevel.SUMMARY);
                MetricsHelper.endScope();
            }
        } else {
            LOG.debug((Object)("WorkerId " + this.workerId + " is not a leader, not running the shard sync task"));
        }
    }

    @VisibleForTesting
    IPeriodicShardSyncManager.ShardSyncResponse checkForShardSync() throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        if (!this.isAuditorMode) {
            return new IPeriodicShardSyncManager.ShardSyncResponse(true, false, "Syncing every time with PERIODIC shard sync strategy.");
        }
        List currentLeases = this.leaseManager.listLeases();
        if (CollectionUtils.isNullOrEmpty((Collection)currentLeases)) {
            LOG.info((Object)"No leases found. Will trigger a shard sync.");
            return new IPeriodicShardSyncManager.ShardSyncResponse(true, false, "No leases found.");
        }
        return new IPeriodicShardSyncManager.ShardSyncResponse(false, false, "DynamoDB Streams does not support hash range hole checking");
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public LeaderDecider getLeaderDecider() {
        return this.leaderDecider;
    }

    public ITask getMetricsEmittingShardSyncTask() {
        return this.metricsEmittingShardSyncTask;
    }

    public ScheduledExecutorService getShardSyncThreadPool() {
        return this.shardSyncThreadPool;
    }

    public ILeaseManager<KinesisClientLease> getLeaseManager() {
        return this.leaseManager;
    }

    public IKinesisProxy getKinesisProxy() {
        return this.kinesisProxy;
    }

    public boolean isAuditorMode() {
        return this.isAuditorMode;
    }

    public long getPeriodicShardSyncIntervalMillis() {
        return this.periodicShardSyncIntervalMillis;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public IMetricsFactory getMetricsFactory() {
        return this.metricsFactory;
    }

    public int getLeasesRecoveryAuditorInconsistencyConfidenceThreshold() {
        return this.leasesRecoveryAuditorInconsistencyConfidenceThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDBStreamsPeriodicShardSyncManager)) {
            return false;
        }
        DynamoDBStreamsPeriodicShardSyncManager other = (DynamoDBStreamsPeriodicShardSyncManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuditorMode() != other.isAuditorMode()) {
            return false;
        }
        if (this.getPeriodicShardSyncIntervalMillis() != other.getPeriodicShardSyncIntervalMillis()) {
            return false;
        }
        if (this.isRunning() != other.isRunning()) {
            return false;
        }
        if (this.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold() != other.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold()) {
            return false;
        }
        String this$workerId = this.getWorkerId();
        String other$workerId = other.getWorkerId();
        if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
            return false;
        }
        LeaderDecider this$leaderDecider = this.getLeaderDecider();
        LeaderDecider other$leaderDecider = other.getLeaderDecider();
        if (this$leaderDecider == null ? other$leaderDecider != null : !this$leaderDecider.equals(other$leaderDecider)) {
            return false;
        }
        ITask this$metricsEmittingShardSyncTask = this.getMetricsEmittingShardSyncTask();
        ITask other$metricsEmittingShardSyncTask = other.getMetricsEmittingShardSyncTask();
        if (this$metricsEmittingShardSyncTask == null ? other$metricsEmittingShardSyncTask != null : !this$metricsEmittingShardSyncTask.equals(other$metricsEmittingShardSyncTask)) {
            return false;
        }
        ScheduledExecutorService this$shardSyncThreadPool = this.getShardSyncThreadPool();
        ScheduledExecutorService other$shardSyncThreadPool = other.getShardSyncThreadPool();
        if (this$shardSyncThreadPool == null ? other$shardSyncThreadPool != null : !this$shardSyncThreadPool.equals(other$shardSyncThreadPool)) {
            return false;
        }
        ILeaseManager<KinesisClientLease> this$leaseManager = this.getLeaseManager();
        ILeaseManager<KinesisClientLease> other$leaseManager = other.getLeaseManager();
        if (this$leaseManager == null ? other$leaseManager != null : !this$leaseManager.equals(other$leaseManager)) {
            return false;
        }
        IKinesisProxy this$kinesisProxy = this.getKinesisProxy();
        IKinesisProxy other$kinesisProxy = other.getKinesisProxy();
        if (this$kinesisProxy == null ? other$kinesisProxy != null : !this$kinesisProxy.equals(other$kinesisProxy)) {
            return false;
        }
        IMetricsFactory this$metricsFactory = this.getMetricsFactory();
        IMetricsFactory other$metricsFactory = other.getMetricsFactory();
        return !(this$metricsFactory == null ? other$metricsFactory != null : !this$metricsFactory.equals(other$metricsFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamoDBStreamsPeriodicShardSyncManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuditorMode() ? 79 : 97);
        long $periodicShardSyncIntervalMillis = this.getPeriodicShardSyncIntervalMillis();
        result = result * 59 + (int)($periodicShardSyncIntervalMillis >>> 32 ^ $periodicShardSyncIntervalMillis);
        result = result * 59 + (this.isRunning() ? 79 : 97);
        result = result * 59 + this.getLeasesRecoveryAuditorInconsistencyConfidenceThreshold();
        String $workerId = this.getWorkerId();
        result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
        LeaderDecider $leaderDecider = this.getLeaderDecider();
        result = result * 59 + ($leaderDecider == null ? 43 : $leaderDecider.hashCode());
        ITask $metricsEmittingShardSyncTask = this.getMetricsEmittingShardSyncTask();
        result = result * 59 + ($metricsEmittingShardSyncTask == null ? 43 : $metricsEmittingShardSyncTask.hashCode());
        ScheduledExecutorService $shardSyncThreadPool = this.getShardSyncThreadPool();
        result = result * 59 + ($shardSyncThreadPool == null ? 43 : $shardSyncThreadPool.hashCode());
        ILeaseManager<KinesisClientLease> $leaseManager = this.getLeaseManager();
        result = result * 59 + ($leaseManager == null ? 43 : $leaseManager.hashCode());
        IKinesisProxy $kinesisProxy = this.getKinesisProxy();
        result = result * 59 + ($kinesisProxy == null ? 43 : $kinesisProxy.hashCode());
        IMetricsFactory $metricsFactory = this.getMetricsFactory();
        result = result * 59 + ($metricsFactory == null ? 43 : $metricsFactory.hashCode());
        return result;
    }
}

