/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.dynamodbv2.streamsadapter.model.RecordAdapter;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.types.InitializationInput;
import com.amazonaws.services.kinesis.clientlibrary.types.ProcessRecordsInput;
import com.amazonaws.services.kinesis.clientlibrary.types.ShutdownInput;
import com.amazonaws.services.kinesis.model.Record;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StreamsRecordProcessor
implements IRecordProcessor {
    private static final Log LOG = LogFactory.getLog(StreamsRecordProcessor.class);

    public abstract void initialize(InitializationInput var1);

    public void processRecords(ProcessRecordsInput processRecordsInput) {
        ArrayList<com.amazonaws.services.dynamodbv2.model.Record> streamsRecords = new ArrayList<com.amazonaws.services.dynamodbv2.model.Record>();
        if (processRecordsInput.getRecords() == null) {
            LOG.warn((Object)"ProcessRecordsInput's list of Records was null. Skipping.");
            return;
        }
        for (Record record : processRecordsInput.getRecords()) {
            if (record instanceof RecordAdapter) {
                streamsRecords.add(((RecordAdapter)record).getInternalObject());
                continue;
            }
            throw new IllegalArgumentException("Record is not an instance of RecordAdapter");
        }
        this.processStreamsRecords(streamsRecords, processRecordsInput.getCheckpointer());
    }

    public abstract void processStreamsRecords(List<com.amazonaws.services.dynamodbv2.model.Record> var1, IRecordProcessorCheckpointer var2);

    public abstract void shutdown(ShutdownInput var1);
}

