/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import com.amazonaws.services.dynamodbv2.streamsadapter.adapter.DynamoDBStreamsGetRecordsResponseAdapter;
import com.amazonaws.services.dynamodbv2.streamsadapter.common.DynamoDBStreamsRequestsBuilder;
import com.amazonaws.services.dynamodbv2.streamsadapter.util.KinesisMapperUtil;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.KinesisException;
import software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;
import software.amazon.kinesis.metrics.MetricsUtil;
import software.amazon.kinesis.retrieval.AWSExceptionManager;
import software.amazon.kinesis.retrieval.DataFetcherProviderConfig;
import software.amazon.kinesis.retrieval.DataFetcherResult;
import software.amazon.kinesis.retrieval.GetRecordsResponseAdapter;
import software.amazon.kinesis.retrieval.KinesisClientRecord;
import software.amazon.kinesis.retrieval.RetryableRetrievalException;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;
import software.amazon.kinesis.retrieval.polling.DataFetcher;

public class DynamoDBStreamsDataFetcher
implements DataFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamoDBStreamsDataFetcher.class);
    private static final String METRICS_PREFIX = "DynamoDBStreamsDataFetcher";
    private static final String OPERATION = "ProcessTask";
    @NonNull
    private final AmazonDynamoDBStreamsAdapterClient amazonDynamoDBStreamsAdapterClient;
    @NonNull
    private final StreamIdentifier streamIdentifier;
    @NonNull
    private final String shardId;
    private final int maxRecords;
    @NonNull
    private final MetricsFactory metricsFactory;
    private final String streamAndShardId;
    private String nextIterator;
    private boolean isShardEndReached;
    private boolean isInitialized;
    private String lastKnownSequenceNumber;
    final Duration maxFutureWait;
    private InitialPositionInStreamExtended initialPositionInStream;
    private static final AWSExceptionManager AWS_EXCEPTION_MANAGER = DynamoDBStreamsDataFetcher.createExceptionManager();
    private static final int DEFAULT_MAX_RECORDS = 1000;
    final DataFetcherResult terminalResult = new DataFetcherResult(){

        public GetRecordsResponseAdapter getResultAdapter() {
            return new DynamoDBStreamsGetRecordsResponseAdapter((software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse)software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse.builder().records(Collections.emptyList()).nextShardIterator(null).build());
        }

        public GetRecordsResponse getResult() {
            throw new UnsupportedOperationException("getResult not implemented for DynamoDBStreamsDataFetcher");
        }

        public GetRecordsResponseAdapter acceptAdapter() {
            DynamoDBStreamsDataFetcher.this.nextIterator = null;
            DynamoDBStreamsDataFetcher.this.isShardEndReached = true;
            return this.getResultAdapter();
        }

        public GetRecordsResponse accept() {
            throw new UnsupportedOperationException("accept not implemented for DynamoDBStreamsDataFetcher");
        }

        public boolean isShardEnd() {
            return true;
        }
    };

    private static AWSExceptionManager createExceptionManager() {
        AWSExceptionManager exceptionManager = new AWSExceptionManager();
        exceptionManager.add(ResourceNotFoundException.class, t -> t);
        exceptionManager.add(KinesisException.class, t -> t);
        exceptionManager.add(SdkException.class, t -> t);
        return exceptionManager;
    }

    public DynamoDBStreamsDataFetcher(@NotNull AmazonDynamoDBStreamsAdapterClient amazonDynamoDBStreamsAdapterClient, DataFetcherProviderConfig dynamoDBStreamsDataFetcherProviderConfig) {
        this.amazonDynamoDBStreamsAdapterClient = amazonDynamoDBStreamsAdapterClient;
        this.maxRecords = Math.min(dynamoDBStreamsDataFetcherProviderConfig.getMaxRecords(), 1000);
        this.metricsFactory = dynamoDBStreamsDataFetcherProviderConfig.getMetricsFactory();
        this.streamIdentifier = dynamoDBStreamsDataFetcherProviderConfig.getStreamIdentifier();
        this.shardId = dynamoDBStreamsDataFetcherProviderConfig.getShardId();
        this.streamAndShardId = String.format("%s:%s", KinesisMapperUtil.createDynamoDBStreamsArnFromKinesisStreamName(this.streamIdentifier.streamName()), this.shardId);
        this.maxFutureWait = dynamoDBStreamsDataFetcherProviderConfig.getKinesisRequestTimeout();
    }

    public DataFetcherResult getRecords() {
        if (!this.isInitialized) {
            throw new IllegalStateException("DynamoDBStreamsDataFetcher.getRecords method called before initialization.");
        }
        if (this.nextIterator != null) {
            try {
                return new AdvancingResult(this.ddbGetRecords(this.nextIterator));
            }
            catch (ResourceNotFoundException e) {
                log.info("Caught ResourceNotFoundException when fetching records for stream and shard {}", (Object)this.streamAndShardId);
                return this.terminalResult;
            }
        }
        return this.terminalResult;
    }

    public void initialize(String initialCheckpoint, InitialPositionInStreamExtended initialPositionInStream) {
        log.info("Initializing stream and shard: {} with: {}", (Object)this.streamAndShardId, (Object)initialCheckpoint);
        this.advanceIteratorTo(initialCheckpoint, initialPositionInStream);
        this.isInitialized = true;
    }

    public void initialize(ExtendedSequenceNumber initialCheckpoint, InitialPositionInStreamExtended initialPositionInStream) {
        log.info("Initializing stream and shard: {} with: {}", (Object)this.streamAndShardId, (Object)initialCheckpoint.sequenceNumber());
        this.advanceIteratorTo(initialCheckpoint.sequenceNumber(), initialPositionInStream);
        this.isInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advanceIteratorTo(String sequenceNumber, InitialPositionInStreamExtended initialPositionInStream) {
        if (sequenceNumber == null) {
            throw new IllegalArgumentException("SequenceNumber should not be null: shardId " + this.shardId);
        }
        GetShardIteratorRequest.Builder getShardIteratorRequestBuilder = GetShardIteratorRequest.builder().streamName(KinesisMapperUtil.createDynamoDBStreamsArnFromKinesisStreamName(this.streamIdentifier.streamName())).shardId(this.shardId);
        if (Objects.equals(ExtendedSequenceNumber.LATEST.sequenceNumber(), sequenceNumber)) {
            getShardIteratorRequestBuilder.shardIteratorType(ShardIteratorType.LATEST);
        } else if (Objects.equals(ExtendedSequenceNumber.TRIM_HORIZON.sequenceNumber(), sequenceNumber)) {
            getShardIteratorRequestBuilder.shardIteratorType(ShardIteratorType.TRIM_HORIZON);
        } else {
            if (Objects.equals(ExtendedSequenceNumber.SHARD_END.sequenceNumber(), sequenceNumber)) {
                this.nextIterator = null;
                this.isShardEndReached = true;
                this.lastKnownSequenceNumber = sequenceNumber;
                this.initialPositionInStream = initialPositionInStream;
                return;
            }
            getShardIteratorRequestBuilder.shardIteratorType(ShardIteratorType.AFTER_SEQUENCE_NUMBER);
            getShardIteratorRequestBuilder.startingSequenceNumber(sequenceNumber);
        }
        GetShardIteratorRequest request = (GetShardIteratorRequest)getShardIteratorRequestBuilder.build();
        log.debug("[GetShardIterator] Request has parameters {}", (Object)request);
        MetricsScope metricsScope = MetricsUtil.createMetricsWithOperation((MetricsFactory)this.metricsFactory, (String)OPERATION);
        MetricsUtil.addStreamId((MetricsScope)metricsScope, (StreamIdentifier)this.streamIdentifier);
        MetricsUtil.addShardId((MetricsScope)metricsScope, (String)this.shardId);
        boolean success = false;
        long startTime = System.currentTimeMillis();
        try {
            try {
                this.nextIterator = this.getNextIterator(request);
                success = true;
            }
            catch (ExecutionException e) {
                throw AWS_EXCEPTION_MANAGER.apply(e.getCause());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException e) {
                throw new RetryableRetrievalException(e.getMessage(), (Exception)e);
            }
        }
        catch (ResourceNotFoundException e) {
            try {
                log.info("Caught ResourceNotFoundException when getting an iterator for stream and shard {}", (Object)this.streamAndShardId, (Object)e);
                this.nextIterator = null;
            }
            catch (Throwable throwable) {
                MetricsUtil.addSuccessAndLatency((MetricsScope)metricsScope, (String)String.format("%s.%s", METRICS_PREFIX, "getShardIterator"), (boolean)success, (long)startTime, (MetricsLevel)MetricsLevel.DETAILED);
                MetricsUtil.endScope((MetricsScope)metricsScope);
                throw throwable;
            }
            MetricsUtil.addSuccessAndLatency((MetricsScope)metricsScope, (String)String.format("%s.%s", METRICS_PREFIX, "getShardIterator"), (boolean)success, (long)startTime, (MetricsLevel)MetricsLevel.DETAILED);
            MetricsUtil.endScope((MetricsScope)metricsScope);
        }
        MetricsUtil.addSuccessAndLatency((MetricsScope)metricsScope, (String)String.format("%s.%s", METRICS_PREFIX, "getShardIterator"), (boolean)success, (long)startTime, (MetricsLevel)MetricsLevel.DETAILED);
        MetricsUtil.endScope((MetricsScope)metricsScope);
        if (this.nextIterator == null) {
            this.isShardEndReached = true;
        }
        this.lastKnownSequenceNumber = sequenceNumber;
        this.initialPositionInStream = initialPositionInStream;
    }

    public void restartIterator() {
        if (StringUtils.isEmpty((CharSequence)this.lastKnownSequenceNumber) || this.initialPositionInStream == null) {
            throw new IllegalArgumentException("Make sure to initialize the DynamoDBStreamsDataFetcher before restarting the iterator.");
        }
        log.debug("Restarting iterator for sequence number {} on shard id {}", (Object)this.lastKnownSequenceNumber, (Object)this.streamAndShardId);
        this.advanceIteratorTo(this.lastKnownSequenceNumber, this.initialPositionInStream);
    }

    public void resetIterator(String shardIterator, String sequenceNumber, InitialPositionInStreamExtended initialPositionInStream) {
        this.nextIterator = shardIterator;
        this.lastKnownSequenceNumber = sequenceNumber;
        this.initialPositionInStream = initialPositionInStream;
    }

    public GetRecordsResponse getGetRecordsResponse(software.amazon.awssdk.services.kinesis.model.GetRecordsRequest request) throws Exception {
        throw new UnsupportedOperationException("getGetRecordsResponse is not implemented for DynamoDBStreamsDataFetcher");
    }

    public software.amazon.awssdk.services.kinesis.model.GetRecordsRequest getGetRecordsRequest(String nextIterator) {
        throw new UnsupportedOperationException("getGetRecordsRequest is not implemented for DynamoDBStreamsDataFetcher");
    }

    public GetRecordsResponseAdapter getGetRecordsResponse(GetRecordsRequest request) throws ExecutionException, InterruptedException, TimeoutException {
        return this.amazonDynamoDBStreamsAdapterClient.getDynamoDBStreamsRecords(request).get();
    }

    public GetRecordsRequest ddbGetRecordsRequest(String nextIterator) {
        return (GetRecordsRequest)DynamoDBStreamsRequestsBuilder.getRecordsRequestBuilder().shardIterator(nextIterator).limit(Integer.valueOf(this.maxRecords)).build();
    }

    public String getNextIterator(GetShardIteratorRequest request) throws ExecutionException, InterruptedException, TimeoutException {
        GetShardIteratorResponse result = this.amazonDynamoDBStreamsAdapterClient.getShardIterator(request).get();
        return result.shardIterator();
    }

    public GetRecordsResponse getRecords(@NonNull String nextIterator) {
        if (nextIterator == null) {
            throw new NullPointerException("nextIterator is marked non-null but is null");
        }
        throw new UnsupportedOperationException("getRecords is not implemented for DynamoDBStreamsDataFetcher");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GetRecordsResponseAdapter ddbGetRecords(@NonNull String nextIterator) {
        GetRecordsResponseAdapter getRecordsResponseAdapter;
        if (nextIterator == null) {
            throw new NullPointerException("nextIterator is marked non-null but is null");
        }
        GetRecordsRequest getRecordsRequest = this.ddbGetRecordsRequest(nextIterator);
        MetricsScope metricsScope = MetricsUtil.createMetricsWithOperation((MetricsFactory)this.metricsFactory, (String)OPERATION);
        MetricsUtil.addStreamId((MetricsScope)metricsScope, (StreamIdentifier)this.streamIdentifier);
        MetricsUtil.addShardId((MetricsScope)metricsScope, (String)this.shardId);
        boolean success = false;
        long startTime = System.currentTimeMillis();
        try {
            GetRecordsResponseAdapter response = this.getGetRecordsResponse(getRecordsRequest);
            success = true;
            getRecordsResponseAdapter = response;
        }
        catch (ExecutionException e) {
            try {
                throw AWS_EXCEPTION_MANAGER.apply(e.getCause());
                catch (InterruptedException e2) {
                    log.debug("{} : Interrupt called on method, shutdown initiated", (Object)this.streamAndShardId);
                    throw new RuntimeException(e2);
                }
                catch (TimeoutException e3) {
                    throw new RetryableRetrievalException(e3.getMessage(), (Exception)e3);
                }
            }
            catch (Throwable throwable) {
                MetricsUtil.addSuccessAndLatency((MetricsScope)metricsScope, (String)String.format("%s.%s", METRICS_PREFIX, "getRecords"), (boolean)success, (long)startTime, (MetricsLevel)MetricsLevel.DETAILED);
                MetricsUtil.endScope((MetricsScope)metricsScope);
                throw throwable;
            }
        }
        MetricsUtil.addSuccessAndLatency((MetricsScope)metricsScope, (String)String.format("%s.%s", METRICS_PREFIX, "getRecords"), (boolean)success, (long)startTime, (MetricsLevel)MetricsLevel.DETAILED);
        MetricsUtil.endScope((MetricsScope)metricsScope);
        return getRecordsResponseAdapter;
    }

    @NonNull
    @Generated
    public StreamIdentifier getStreamIdentifier() {
        return this.streamIdentifier;
    }

    @Generated
    String getNextIterator() {
        return this.nextIterator;
    }

    @Generated
    public boolean isShardEndReached() {
        return this.isShardEndReached;
    }

    @Generated
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Generated
    public String getLastKnownSequenceNumber() {
        return this.lastKnownSequenceNumber;
    }

    class AdvancingResult
    implements DataFetcherResult {
        final GetRecordsResponseAdapter result;

        public GetRecordsResponseAdapter getResultAdapter() {
            return this.result;
        }

        public GetRecordsResponse getResult() {
            throw new UnsupportedOperationException("AdvancingResult.getResult is not implemented for DynamoDBStreamsDataFetcher");
        }

        public GetRecordsResponseAdapter acceptAdapter() {
            DynamoDBStreamsDataFetcher.this.nextIterator = this.result.nextShardIterator();
            if (CollectionUtils.isNotEmpty((Collection)this.result.records())) {
                DynamoDBStreamsDataFetcher.this.lastKnownSequenceNumber = ((KinesisClientRecord)Iterables.getLast((Iterable)this.result.records())).sequenceNumber();
            }
            if (DynamoDBStreamsDataFetcher.this.nextIterator == null) {
                DynamoDBStreamsDataFetcher.this.isShardEndReached = true;
            }
            return this.getResultAdapter();
        }

        public GetRecordsResponse accept() {
            throw new UnsupportedOperationException("AdvancingResult.accept is not implemented for DynamoDBStreamsDataFetcher");
        }

        public boolean isShardEnd() {
            return DynamoDBStreamsDataFetcher.this.isShardEndReached;
        }

        @Generated
        public AdvancingResult(GetRecordsResponseAdapter result) {
            this.result = result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdvancingResult)) {
                return false;
            }
            AdvancingResult other = (AdvancingResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GetRecordsResponse this$result = this.getResult();
            GetRecordsResponse other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AdvancingResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GetRecordsResponse $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DynamoDBStreamsDataFetcher.AdvancingResult(result=" + this.getResult() + ")";
        }
    }
}

