/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsShardDetector;
import com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsShardSyncer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import lombok.NonNull;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.common.StreamConfig;
import software.amazon.kinesis.coordinator.DeletedStreamListProvider;
import software.amazon.kinesis.leases.HierarchicalShardSyncer;
import software.amazon.kinesis.leases.LeaseCleanupManager;
import software.amazon.kinesis.leases.LeaseCoordinator;
import software.amazon.kinesis.leases.LeaseManagementConfig;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.LeaseSerializer;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.ShardSyncTaskManager;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseManagementFactory;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseSerializer;
import software.amazon.kinesis.leases.dynamodb.DynamoDBMultiStreamLeaseSerializer;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.retrieval.RetrievalConfig;

public class DynamoDBStreamsLeaseManagementFactory
extends DynamoDBLeaseManagementFactory {
    public DynamoDBStreamsLeaseManagementFactory(@NonNull KinesisAsyncClient kinesisClient, @NonNull LeaseManagementConfig leaseManagementConfig, @NonNull RetrievalConfig retrievalConfig) {
        super(kinesisClient, leaseManagementConfig.dynamoDBClient(), leaseManagementConfig.tableName(), leaseManagementConfig.workerIdentifier(), leaseManagementConfig.executorService(), leaseManagementConfig.failoverTimeMillis(), leaseManagementConfig.enablePriorityLeaseAssignment(), leaseManagementConfig.epsilonMillis, leaseManagementConfig.maxLeasesForWorker(), leaseManagementConfig.maxLeasesToStealAtOneTime(), leaseManagementConfig.maxLeaseRenewalThreads(), leaseManagementConfig.cleanupLeasesUponShardCompletion(), leaseManagementConfig.ignoreUnexpectedChildShards(), leaseManagementConfig.shardSyncIntervalMillis(), leaseManagementConfig.consistentReads(), leaseManagementConfig.listShardsBackoffTimeInMillis(), leaseManagementConfig.maxListShardsRetryAttempts(), leaseManagementConfig.maxCacheMissesBeforeReload(), leaseManagementConfig.listShardsCacheAllowedAgeInSeconds(), leaseManagementConfig.cacheMissWarningModulus(), (long)leaseManagementConfig.initialLeaseTableReadCapacity(), (long)leaseManagementConfig.initialLeaseTableWriteCapacity(), leaseManagementConfig.tableCreatorCallback(), leaseManagementConfig.dynamoDbRequestTimeout(), leaseManagementConfig.billingMode(), leaseManagementConfig.leaseTableDeletionProtectionEnabled(), leaseManagementConfig.leaseTablePitrEnabled(), leaseManagementConfig.tags(), (LeaseSerializer)(retrievalConfig.streamTracker().isMultiStream() ? new DynamoDBMultiStreamLeaseSerializer() : new DynamoDBLeaseSerializer()), leaseManagementConfig.customShardDetectorProvider(), retrievalConfig.streamTracker().isMultiStream(), leaseManagementConfig.leaseCleanupConfig(), leaseManagementConfig.workerUtilizationAwareAssignmentConfig(), leaseManagementConfig.gracefulLeaseHandoffConfig(), leaseManagementConfig.leaseAssignmentIntervalMillis());
        if (kinesisClient == null) {
            throw new NullPointerException("kinesisClient is marked non-null but is null");
        }
        if (leaseManagementConfig == null) {
            throw new NullPointerException("leaseManagementConfig is marked non-null but is null");
        }
        if (retrievalConfig == null) {
            throw new NullPointerException("retrievalConfig is marked non-null but is null");
        }
    }

    public ShardDetector createShardDetector(StreamConfig streamConfig) {
        return new DynamoDBStreamsShardDetector(super.getKinesisClient(), streamConfig.streamIdentifier(), super.getListShardsCacheAllowedAgeInSeconds(), super.getMaxCacheMissesBeforeReload(), super.getCacheMissWarningModulus(), super.getDynamoDbRequestTimeout());
    }

    public ShardSyncTaskManager createShardSyncTaskManager(MetricsFactory metricsFactory, StreamConfig streamConfig, DeletedStreamListProvider deletedStreamListProvider) {
        return new ShardSyncTaskManager(this.createShardDetector(streamConfig), (LeaseRefresher)this.createLeaseRefresher(), streamConfig.initialPositionInStreamExtended(), super.isCleanupLeasesUponShardCompletion(), super.isIgnoreUnexpectedChildShards(), super.getShardSyncIntervalMillis(), super.getExecutorService(), (HierarchicalShardSyncer)new DynamoDBStreamsShardSyncer(super.isMultiStreamMode(), streamConfig.streamIdentifier().toString(), super.isCleanupLeasesUponShardCompletion(), deletedStreamListProvider), metricsFactory);
    }

    public LeaseCleanupManager createLeaseCleanupManager(MetricsFactory metricsFactory) {
        return new NoOpLeaseCleanupManager(this.createLeaseCoordinator(metricsFactory), metricsFactory, Executors.newSingleThreadScheduledExecutor(), super.isCleanupLeasesUponShardCompletion(), super.getLeaseCleanupConfig().leaseCleanupIntervalMillis(), super.getLeaseCleanupConfig().completedLeaseCleanupIntervalMillis(), super.getLeaseCleanupConfig().garbageLeaseCleanupIntervalMillis());
    }

    static class NoOpLeaseCleanupManager
    extends LeaseCleanupManager {
        NoOpLeaseCleanupManager(@NonNull LeaseCoordinator leaseCoordinator, @NonNull MetricsFactory metricsFactory, @NonNull ScheduledExecutorService deletionThreadPool, boolean cleanupLeasesUponShardCompletion, long leaseCleanupIntervalMillis, long completedLeaseCleanupIntervalMillis, long garbageLeaseCleanupIntervalMillis) {
            super(leaseCoordinator, metricsFactory, deletionThreadPool, cleanupLeasesUponShardCompletion, leaseCleanupIntervalMillis, completedLeaseCleanupIntervalMillis, garbageLeaseCleanupIntervalMillis);
            if (leaseCoordinator == null) {
                throw new NullPointerException("leaseCoordinator is marked non-null but is null");
            }
            if (metricsFactory == null) {
                throw new NullPointerException("metricsFactory is marked non-null but is null");
            }
            if (deletionThreadPool == null) {
                throw new NullPointerException("deletionThreadPool is marked non-null but is null");
            }
        }

        public void start() {
        }

        public void shutdown() {
        }
    }
}

