/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.naming.ConfigurationException;
import net.spy.memcached.BroadcastOpFactory;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.TapConnectionProvider;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.TapOperation;
import net.spy.memcached.tapmessage.RequestMessage;
import net.spy.memcached.tapmessage.ResponseMessage;
import net.spy.memcached.tapmessage.TapAck;
import net.spy.memcached.tapmessage.TapOpcode;
import net.spy.memcached.tapmessage.TapStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TapClient {
    protected BlockingQueue<Object> rqueue = new LinkedBlockingQueue<Object>();
    protected final HashMap<TapStream, TapConnectionProvider> omap = new HashMap();
    protected long messagesRead;
    private List<InetSocketAddress> addrs;

    public TapClient(InetSocketAddress ... ia) {
        this(Arrays.asList(ia));
    }

    public TapClient(List<InetSocketAddress> addrs) {
        this.addrs = addrs;
        this.messagesRead = 0L;
    }

    public ResponseMessage getNextMessage() {
        return this.getNextMessage(10L, TimeUnit.SECONDS);
    }

    public ResponseMessage getNextMessage(long time, TimeUnit timeunit) {
        try {
            Object m = this.rqueue.poll(time, timeunit);
            if (m == null) {
                return null;
            }
            if (m instanceof ResponseMessage) {
                return (ResponseMessage)m;
            }
            if (m instanceof TapAck) {
                TapAck ack = (TapAck)m;
                this.tapAck(ack.getConn(), ack.getNode(), ack.getOpcode(), ack.getOpaque(), ack.getCallback());
                return null;
            }
            throw new RuntimeException("Unexpected tap message type");
        }
        catch (InterruptedException e) {
            this.shutdown();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreMessages() {
        if (!this.rqueue.isEmpty()) {
            return true;
        }
        HashMap<TapStream, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            for (TapStream ts : this.omap.keySet()) {
                if (!ts.isCompleted() && !ts.isCancelled() && !ts.hasErrored()) continue;
                this.omap.get(ts).shutdown();
                this.omap.remove(ts);
            }
            if (this.omap.size() > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TapStream tapCustom(final String id, final RequestMessage message) throws ConfigurationException, IOException {
        final TapConnectionProvider conn = new TapConnectionProvider(this.addrs);
        final TapStream ts = new TapStream();
        conn.broadcastOp(new BroadcastOpFactory(){

            public Operation newOp(MemcachedNode n, final CountDownLatch latch) {
                TapOperation op = conn.getOpFactory().tapCustom(id, message, new TapOperation.Callback(){

                    public void receivedStatus(OperationStatus status) {
                    }

                    public void gotData(ResponseMessage tapMessage) {
                        TapClient.this.rqueue.add(tapMessage);
                        ++TapClient.this.messagesRead;
                    }

                    public void gotAck(MemcachedNode node, TapOpcode opcode, int opaque) {
                        TapClient.this.rqueue.add(new TapAck(conn, node, opcode, opaque, this));
                    }

                    public void complete() {
                        latch.countDown();
                    }
                });
                ts.addOp(op);
                return op;
            }
        });
        HashMap<TapStream, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            this.omap.put(ts, conn);
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TapStream tapDump(final String id) throws IOException, ConfigurationException {
        final TapConnectionProvider conn = new TapConnectionProvider(this.addrs);
        final TapStream ts = new TapStream();
        conn.broadcastOp(new BroadcastOpFactory(){

            public Operation newOp(MemcachedNode n, final CountDownLatch latch) {
                TapOperation op = conn.getOpFactory().tapDump(id, new TapOperation.Callback(){

                    public void receivedStatus(OperationStatus status) {
                    }

                    public void gotData(ResponseMessage tapMessage) {
                        TapClient.this.rqueue.add(tapMessage);
                        ++TapClient.this.messagesRead;
                    }

                    public void gotAck(MemcachedNode node, TapOpcode opcode, int opaque) {
                        TapClient.this.rqueue.add(new TapAck(conn, node, opcode, opaque, this));
                    }

                    public void complete() {
                        latch.countDown();
                    }
                });
                ts.addOp(op);
                return op;
            }
        });
        HashMap<TapStream, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            this.omap.put(ts, conn);
        }
        return ts;
    }

    private void tapAck(TapConnectionProvider conn, MemcachedNode node, TapOpcode opcode, int opaque, OperationCallback cb) {
        TapOperation op = conn.getOpFactory().tapAck(opcode, opaque, cb);
        conn.addTapAckOp(node, op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        HashMap<TapStream, TapConnectionProvider> hashMap = this.omap;
        synchronized (hashMap) {
            for (Map.Entry<TapStream, TapConnectionProvider> me : this.omap.entrySet()) {
                me.getValue().shutdown();
            }
        }
    }

    public long getMessagesRead() {
        return this.messagesRead;
    }
}

