/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.net;

import android.content.Context;
import com.amazonaws.ivs.net.HttpClient;
import com.amazonaws.ivs.net.ReadCallback;
import com.amazonaws.ivs.net.Request;
import com.amazonaws.ivs.net.Response;
import com.amazonaws.ivs.net.ResponseCallback;
import com.amazonaws.ivs.net.StreamConsumer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.chromium.net.CronetEngine;
import org.chromium.net.CronetException;
import org.chromium.net.UploadDataProviders;
import org.chromium.net.UrlRequest;
import org.chromium.net.UrlResponseInfo;

enum CronetHttpClient implements HttpClient
{
    INSTANCE;

    private static volatile CronetEngine engine;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(3);

    static synchronized CronetHttpClient getInstance(Context context) {
        if (engine == null) {
            engine = new CronetEngine.Builder(context).enableHttp2(true).enableQuic(true).build();
        }
        return INSTANCE;
    }

    @Override
    public void release() {
    }

    @Override
    public void execute(final Request request, final ResponseCallback callback) {
        ScheduledFuture<?> requestTimeout = this.executor.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = request.lock();
                synchronized (object) {
                    if (!request.isCancelled()) {
                        callback.onError(new TimeoutException("request timeout"));
                    }
                }
            }
        }, (long)request.getTimeout(), TimeUnit.SECONDS);
        UrlRequest.Builder builder = engine.newUrlRequestBuilder(request.getUrl(), (UrlRequest.Callback)new RequestCallback(this.executor, request, requestTimeout, callback), (Executor)this.executor);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        builder.setHttpMethod(request.getMethod().toString());
        if (request.getContent() != null) {
            builder.setUploadDataProvider(UploadDataProviders.create((ByteBuffer)request.getContent()), (Executor)this.executor);
        }
        final UrlRequest urlRequest = builder.build();
        request.setCancellable(new Request.Cancellable(){

            @Override
            public void cancel() {
                urlRequest.cancel();
            }
        });
        urlRequest.start();
    }

    static class RequestCallback
    extends UrlRequest.Callback {
        private final ScheduledExecutorService executor;
        private final Request httpRequest;
        private final ResponseCallback callback;
        private ReadCallback readCallback;
        private ScheduledFuture<?> requestTimeout;
        private ScheduledFuture<?> readTimeout;

        RequestCallback(ScheduledExecutorService executor, Request request, ScheduledFuture<?> requestTimeout, ResponseCallback callback) {
            this.executor = executor;
            this.httpRequest = request;
            this.callback = callback;
            this.requestTimeout = requestTimeout;
        }

        public void onRedirectReceived(UrlRequest request, UrlResponseInfo info, String newLocationUrl) {
            request.followRedirect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponseStarted(final UrlRequest request, UrlResponseInfo info) {
            Object object = this.httpRequest.lock();
            synchronized (object) {
                if (!this.httpRequest.isCancelled()) {
                    Response response = new Response(info.getHttpStatusCode(), info.getUrl());
                    Map headers = info.getAllHeaders();
                    for (Map.Entry header : headers.entrySet()) {
                        List values = (List)header.getValue();
                        if (values.isEmpty()) continue;
                        response.setHeader((String)header.getKey(), String.join((CharSequence)",", values));
                    }
                    response.setConsumer(null, new StreamConsumer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void consume(ReadCallback callback) {
                            Object object = httpRequest.lock();
                            synchronized (object) {
                                readCallback = callback;
                                request.read(ByteBuffer.allocateDirect(16384));
                            }
                        }
                    });
                    this.requestTimeout.cancel(false);
                    this.callback.onResponse(response);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReadCompleted(UrlRequest request, UrlResponseInfo info, ByteBuffer byteBuffer) {
            Object object = this.httpRequest.lock();
            synchronized (object) {
                if (!this.httpRequest.isCancelled()) {
                    int timeout;
                    byteBuffer.flip();
                    if (this.readCallback != null) {
                        this.readCallback.onBuffer(byteBuffer, byteBuffer.remaining(), false);
                    }
                    byteBuffer.clear();
                    request.read(byteBuffer);
                    if (this.readTimeout != null) {
                        this.readTimeout.cancel(false);
                    }
                    if ((timeout = this.readCallback.getTimeout()) > 0) {
                        this.readTimeout = this.executor.schedule(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = httpRequest.lock();
                                synchronized (object) {
                                    if (!httpRequest.isCancelled()) {
                                        callback.onError(new TimeoutException("response timeout"));
                                    }
                                }
                            }
                        }, (long)timeout, TimeUnit.SECONDS);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSucceeded(UrlRequest request, UrlResponseInfo info) {
            Object object = this.httpRequest.lock();
            synchronized (object) {
                if (!this.httpRequest.isCancelled()) {
                    if (this.readTimeout != null) {
                        this.readTimeout.cancel(false);
                    }
                    if (this.readCallback != null) {
                        this.readCallback.onBuffer(null, 0, true);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailed(UrlRequest request, UrlResponseInfo info, CronetException error) {
            error.printStackTrace();
            Object object = this.httpRequest.lock();
            synchronized (object) {
                if (!this.httpRequest.isCancelled()) {
                    this.callback.onError((Exception)error);
                }
            }
        }
    }
}

