/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.net;

import android.content.Context;
import android.util.Log;
import com.amazonaws.ivs.net.CronetHttpClient;
import com.amazonaws.ivs.net.HttpClient;
import com.amazonaws.ivs.net.HttpUrlConnectionClient;
import com.amazonaws.ivs.net.OkHttpClient;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class HttpClientFactory {
    private static final String TAG = "AmazonIVSNet";
    private static final Map<Implementation, Boolean> supported = Collections.synchronizedMap(new EnumMap(Implementation.class));
    private static final boolean CRONET_ENABLED = false;

    private HttpClientFactory() {
    }

    private static Implementation getHttpImplementation(Context context) {
        if (supported.isEmpty()) {
            supported.put(Implementation.HTTP_URL_CONNECTION, true);
            try {
                Class.forName("okhttp3.OkHttpClient", false, HttpClientFactory.class.getClassLoader());
                supported.put(Implementation.OKHTTP, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (Implementation implementation : Implementation.values()) {
            if (!supported.containsKey((Object)implementation) || !supported.get((Object)implementation).booleanValue()) continue;
            return implementation;
        }
        return Implementation.HTTP_URL_CONNECTION;
    }

    public static HttpClient create(Context context) {
        Implementation implementation = HttpClientFactory.getHttpImplementation(context);
        Log.i((String)TAG, (String)("create http client " + implementation.toString().toLowerCase()));
        switch (implementation.ordinal()) {
            case 0: {
                return CronetHttpClient.getInstance(context);
            }
            case 1: {
                return new OkHttpClient();
            }
        }
        return new HttpUrlConnectionClient();
    }

    public static enum Implementation {
        CRONET,
        OKHTTP,
        HTTP_URL_CONNECTION;

    }
}

