/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.net;

import com.amazonaws.ivs.net.HttpClient;
import com.amazonaws.ivs.net.InputStreamConsumer;
import com.amazonaws.ivs.net.Request;
import com.amazonaws.ivs.net.Response;
import com.amazonaws.ivs.net.ResponseCallback;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class HttpUrlConnectionClient
implements HttpClient {
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 10000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 10000;
    private static final int BUFFER_SIZE = 16384;
    private final ExecutorService executor = Executors.newFixedThreadPool(3);

    HttpUrlConnectionClient() {
    }

    @Override
    public void release() {
        this.executor.shutdown();
    }

    @Override
    public void execute(Request request, ResponseCallback callback) {
        this.executeAsync(request, callback);
    }

    private void executeAsync(final Request request, final ResponseCallback callback) {
        Future<?> future = this.executor.submit(new Runnable(){

            @Override
            public void run() {
                HttpUrlConnectionClient.this.executeSync(request, callback);
            }
        });
        request.setFuture(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSync(Request request, ResponseCallback callback) {
        HttpURLConnection connection = null;
        try {
            connection = this.openConnection(request, request.getUrl());
            Response response = this.blockingExecute(connection, request, callback);
            Object object = request.lock();
            synchronized (object) {
                if (!request.isCancelled()) {
                    callback.onResponse(response);
                }
            }
        }
        catch (IOException e) {
            HttpUrlConnectionClient.disconnect(connection);
            e.printStackTrace();
            Object object = request.lock();
            synchronized (object) {
                if (!request.isCancelled()) {
                    callback.onError(e);
                }
            }
        }
    }

    private HttpURLConnection openConnection(Request request, String location) throws IOException {
        URL url = new URL(location);
        return (HttpURLConnection)url.openConnection();
    }

    private Response blockingExecute(final HttpURLConnection connection, Request request, ResponseCallback callback) throws IOException {
        String location;
        String method = request.getMethod().toString().toUpperCase(Locale.ROOT);
        connection.setRequestMethod(method);
        connection.setInstanceFollowRedirects(false);
        if (request.getTimeout() > 0) {
            connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(request.getTimeout()));
            connection.setReadTimeout(10000);
        } else {
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
        }
        for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        this.writeRequestContent(connection, request, callback);
        connection.connect();
        int statusCode = connection.getResponseCode();
        Response response = new Response(statusCode, connection.getURL().toString());
        for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
            List<String> values = header.getValue();
            if (values.isEmpty()) continue;
            response.setHeader(header.getKey(), String.join((CharSequence)",", values));
        }
        if ((statusCode == 302 || statusCode == 301 || statusCode == 307) && (location = response.getHeader("Location")) != null) {
            if (request.getContent() != null) {
                request.getContent().rewind();
            }
            HttpUrlConnectionClient.disconnect(connection);
            return this.blockingExecute(this.openConnection(request, location), request, callback);
        }
        InputStreamConsumer.Provider provider = new InputStreamConsumer.Provider(){

            @Override
            public InputStream getInputStream(int timeout) throws IOException {
                InputStream inputStream;
                if (timeout > 0) {
                    connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(timeout));
                }
                if ((inputStream = connection.getErrorStream()) == null) {
                    inputStream = connection.getInputStream();
                }
                return inputStream;
            }
        };
        response.setConsumer(this.executor, new InputStreamConsumer(request, provider));
        return response;
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void disconnect(HttpURLConnection connection) {
        if (connection != null) {
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequestContent(HttpURLConnection connection, Request request, ResponseCallback callback) throws IOException {
        if (request.getContent() != null) {
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            try {
                WritableByteChannel channel = Channels.newChannel(outputStream);
                channel.write(request.getContent());
            }
            catch (IOException e) {
                e.printStackTrace();
                Object object = request.lock();
                synchronized (object) {
                    if (!request.isCancelled()) {
                        callback.onError(e);
                    }
                }
            }
            finally {
                HttpUrlConnectionClient.close(outputStream);
            }
        }
    }
}

