/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.net;

import com.amazonaws.ivs.net.ReadCallback;
import com.amazonaws.ivs.net.Request;
import com.amazonaws.ivs.net.StreamConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class InputStreamConsumer
implements StreamConsumer {
    private static final int BUFFER_SIZE = 16384;
    private final Request request;
    private final Provider provider;

    InputStreamConsumer(Request request, Provider provider) {
        this.request = request;
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void consume(ReadCallback callback) {
        int timeout;
        Object object = this.request.lock();
        synchronized (object) {
            if (this.request.isCancelled()) {
                return;
            }
            timeout = callback.getTimeout();
        }
        IOException exception = null;
        try (InputStream inputStream = this.provider.getInputStream(timeout);){
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            byte[] bytes = new byte[16384];
            boolean endOfStream = false;
            while (!endOfStream && !this.request.isCancelled()) {
                int read = inputStream.read(bytes);
                int size = 0;
                buffer.rewind();
                if (read == -1) {
                    endOfStream = true;
                } else {
                    buffer.put(bytes, 0, read);
                    size = read;
                }
                Object object2 = this.request.lock();
                synchronized (object2) {
                    if (!this.request.isCancelled()) {
                        callback.onBuffer(buffer, size, endOfStream);
                    }
                }
            }
        }
        catch (IOException e) {
            exception = e;
            e.printStackTrace();
        }
        if (exception == null) return;
        Object object3 = this.request.lock();
        synchronized (object3) {
            if (this.request.isCancelled()) return;
            callback.onError(exception);
            return;
        }
    }

    static interface Provider {
        public InputStream getInputStream(int var1) throws IOException;
    }
}

