/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.net;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class NetworkLinkInfo {
    private static final String TAG = "AmazonIVSNet";
    private final Context context;
    private ConnectivityManager connectivityManager;
    private boolean isPermissionAccessNetworkState;
    private Boolean isOnline = null;
    private ConnectivityManager.NetworkCallback callback;
    private long nativeListener;
    private final Object lock = new Object();

    public NetworkLinkInfo(Context context) {
        Context context2 = this.context = context != null ? context.getApplicationContext() : null;
        if (this.context == null) {
            Log.w((String)TAG, (String)"NetworkConnectivity null context, info not available");
        } else {
            this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }
    }

    private native void onNetworkAvailable(long var1);

    private native void onNetworkLost(long var1);

    @TargetApi(value=21)
    @Nullable
    private Network getActiveNetwork() {
        if (!this.isPermissionAccessNetworkState && this.context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") != 0) {
            return null;
        }
        this.isPermissionAccessNetworkState = true;
        if (Build.VERSION.SDK_INT >= 23) {
            return this.connectivityManager.getActiveNetwork();
        }
        Network[] networks = this.connectivityManager.getAllNetworks();
        return networks.length > 0 ? networks[0] : null;
    }

    public String getNetworkType() {
        if (this.context != null && Build.VERSION.SDK_INT >= 21) {
            Network network = this.getActiveNetwork();
            if (network == null) {
                return "None";
            }
            NetworkCapabilities capabilities = this.connectivityManager.getNetworkCapabilities(network);
            if (capabilities == null) {
                return "Unknown";
            }
            if (capabilities.hasTransport(3)) {
                return "Ethernet";
            }
            if (capabilities.hasTransport(1)) {
                return "Wifi";
            }
            if (capabilities.hasTransport(2)) {
                return "Bluetooth";
            }
            if (capabilities.hasTransport(0)) {
                if (0 == this.context.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE")) {
                    CellularNetworkType cellularType = this.getCellularNetworkType();
                    switch (cellularType.ordinal()) {
                        case 0: {
                            return "Cellular_2g";
                        }
                        default: {
                            return "Cellular_3g";
                        }
                        case 2: {
                            return "Cellular_4g";
                        }
                        case 3: 
                    }
                    return "Cellular_5g";
                }
                return "Cellular";
            }
        }
        return "Unknown";
    }

    private CellularNetworkType getCellularNetworkType() {
        TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
        int type = telephonyManager.getNetworkType();
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 7: 
            case 11: {
                return CellularNetworkType.TYPE_2G;
            }
            default: {
                return CellularNetworkType.TYPE_3G;
            }
            case 13: 
            case 19: {
                return CellularNetworkType.TYPE_4G;
            }
            case 20: 
        }
        return CellularNetworkType.TYPE_5G;
    }

    private int getCellularMaxLinkSpeedKbps() {
        TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
        int type = telephonyManager.getNetworkType();
        switch (type) {
            case 1: 
            case 7: {
                return 100;
            }
            case 2: 
            case 11: 
            case 16: {
                return 300;
            }
            default: {
                return 1000;
            }
            case 5: {
                return 1000;
            }
            case 6: {
                return 2000;
            }
            case 12: {
                return 3000;
            }
            case 10: {
                return 7000;
            }
            case 8: 
            case 9: {
                return 14000;
            }
            case 15: {
                return 21000;
            }
            case 13: {
                return 50000;
            }
            case 19: {
                return 300000;
            }
            case 20: 
        }
        return 1000000;
    }

    public int getDownlinkBandwidth() {
        Network network;
        NetworkCapabilities capabilities;
        if (this.context != null && Build.VERSION.SDK_INT >= 21 && (capabilities = this.connectivityManager.getNetworkCapabilities(network = this.getActiveNetwork())) != null) {
            if (capabilities.hasTransport(1)) {
                WifiManager wifiManager = (WifiManager)this.context.getApplicationContext().getSystemService("wifi");
                int result = this.context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE");
                if (result == 0) {
                    WifiInfo wifiInfo;
                    WifiInfo wifiInfo2 = wifiInfo = wifiManager == null ? null : wifiManager.getConnectionInfo();
                    if (wifiInfo != null) {
                        return wifiInfo.getLinkSpeed() * 1000 * 1000;
                    }
                } else {
                    Log.w((String)TAG, (String)"No permission for ACCESS_WIFI_STATE");
                }
            }
            if (capabilities.hasTransport(0)) {
                int networkMaxKbps = this.getCellularMaxLinkSpeedKbps();
                return 1000 * Math.min(networkMaxKbps, capabilities.getLinkDownstreamBandwidthKbps());
            }
            return 1000 * capabilities.getLinkDownstreamBandwidthKbps();
        }
        return -1;
    }

    public boolean getNetworkOnline() {
        if (this.isOnline != null) {
            return this.isOnline;
        }
        NetworkInfo info = this.connectivityManager.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(long listener) {
        Object object = this.lock;
        synchronized (object) {
            this.nativeListener = listener;
            if (this.callback != null) {
                try {
                    this.connectivityManager.unregisterNetworkCallback(this.callback);
                }
                catch (IllegalArgumentException e) {
                    Log.w((String)TAG, (String)"NetworkCallback was already unregistered");
                }
                this.callback = null;
            }
            if (this.nativeListener != 0L) {
                this.callback = new ConnectivityManager.NetworkCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onAvailable(@NonNull Network network) {
                        Object object = NetworkLinkInfo.this.lock;
                        synchronized (object) {
                            NetworkLinkInfo.this.isOnline = true;
                            if (NetworkLinkInfo.this.nativeListener != 0L) {
                                NetworkLinkInfo.this.onNetworkAvailable(NetworkLinkInfo.this.nativeListener);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onLost(@NonNull Network network) {
                        Object object = NetworkLinkInfo.this.lock;
                        synchronized (object) {
                            NetworkLinkInfo.this.isOnline = false;
                            if (NetworkLinkInfo.this.nativeListener != 0L) {
                                NetworkLinkInfo.this.onNetworkLost(NetworkLinkInfo.this.nativeListener);
                            }
                        }
                    }
                };
                try {
                    if (Build.VERSION.SDK_INT >= 24) {
                        this.connectivityManager.registerDefaultNetworkCallback(this.callback);
                    } else {
                        this.connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().build(), this.callback);
                    }
                }
                catch (Exception ex) {
                    Log.w((String)TAG, (String)"Unable to monitor network changes", (Throwable)ex);
                }
            }
        }
    }

    static enum CellularNetworkType {
        TYPE_2G,
        TYPE_3G,
        TYPE_4G,
        TYPE_5G;

    }
}

