/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.net;

import androidx.annotation.NonNull;
import com.amazonaws.ivs.net.HttpClient;
import com.amazonaws.ivs.net.InputStreamConsumer;
import com.amazonaws.ivs.net.Method;
import com.amazonaws.ivs.net.Request;
import com.amazonaws.ivs.net.Response;
import com.amazonaws.ivs.net.ResponseCallback;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

class OkHttpClient
implements HttpClient {
    OkHttpClient() {
    }

    private static okhttp3.OkHttpClient client() {
        return Holder.client;
    }

    @Override
    public void release() {
    }

    @Override
    public void execute(Request request, ResponseCallback callback) {
        Object copy;
        Request.Builder builder = new Request.Builder();
        RequestBody body = null;
        if (request.getContent() != null) {
            ByteBuffer buffer = request.getContent();
            copy = new byte[buffer.remaining()];
            buffer.get((byte[])copy);
            body = RequestBody.create(null, (byte[])copy);
        } else if (request.getMethod() == Method.POST) {
            body = RequestBody.create(null, (byte[])new byte[0]);
        }
        builder.url(request.getUrl());
        String method = request.getMethod().toString().toUpperCase(Locale.ROOT);
        builder.method(method, body);
        copy = request.getHeaders().entrySet().iterator();
        while (copy.hasNext()) {
            Map.Entry header = (Map.Entry)copy.next();
            builder.addHeader((String)header.getKey(), (String)header.getValue());
        }
        okhttp3.Request okRequest = builder.build();
        this.execute(request, okRequest, callback);
    }

    private void execute(Request request, okhttp3.Request okRequest, ResponseCallback callback) {
        final Call call = OkHttpClient.client().newCall(okRequest);
        request.setCancellable(new Request.Cancellable(){

            @Override
            public void cancel() {
                call.cancel();
            }
        });
        call.enqueue((Callback)new OkHttpResponseCallback(request, callback));
    }

    private boolean handleRedirect(Request request, okhttp3.Response okResponse, ResponseCallback callback) {
        okhttp3.Response prevResponse = null;
        if (OkHttpClient.isHttpRedirectCode(okResponse.code())) {
            prevResponse = okResponse;
        } else if (okResponse.code() == 403) {
            prevResponse = okResponse.priorResponse();
        }
        if (prevResponse == null || !OkHttpClient.isHttpRedirectCode(prevResponse.code())) {
            return false;
        }
        String location = prevResponse.header("Location");
        if (location == null) {
            return false;
        }
        okhttp3.Request prevRequest = prevResponse.request();
        okhttp3.Request redirect = prevRequest.newBuilder().url(HttpUrl.parse((String)location)).build();
        this.execute(request, redirect, callback);
        return true;
    }

    private static boolean isHttpRedirectCode(int code) {
        return code == 301 || code == 302 || code == 307;
    }

    private static class Holder {
        static final okhttp3.OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).protocols(Collections.singletonList(Protocol.HTTP_1_1)).followRedirects(false).build();

        private Holder() {
        }
    }

    class OkHttpResponseCallback
    implements Callback {
        private final Request request;
        private final ResponseCallback callback;

        OkHttpResponseCallback(Request request, ResponseCallback callback) {
            this.request = request;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(@NonNull Call call, IOException e) {
            e.printStackTrace();
            Object object = this.request.lock();
            synchronized (object) {
                if (!this.request.isCancelled()) {
                    this.callback.onError(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(@NonNull Call call, final @NonNull okhttp3.Response okResponse) {
            Object object = this.request.lock();
            synchronized (object) {
                if (!this.request.isCancelled()) {
                    Response response = new Response(okResponse.code(), okResponse.request().url().toString());
                    Map headers = okResponse.headers().toMultimap();
                    for (Map.Entry header : headers.entrySet()) {
                        List values = (List)header.getValue();
                        if (values.isEmpty()) continue;
                        response.setHeader((String)header.getKey(), String.join((CharSequence)",", values));
                    }
                    InputStreamConsumer.Provider provider = new InputStreamConsumer.Provider(){

                        @Override
                        public InputStream getInputStream(int timeout) throws IOException {
                            ResponseBody body = okResponse.body();
                            if (body == null) {
                                throw new IOException("No body");
                            }
                            return body.byteStream();
                        }
                    };
                    if (OkHttpClient.this.handleRedirect(this.request, okResponse, this.callback)) {
                        return;
                    }
                    response.setConsumer(OkHttpClient.client().dispatcher().executorService(), new InputStreamConsumer(this.request, provider));
                    this.callback.onResponse(response);
                }
            }
        }
    }
}

