/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.net;

import com.amazonaws.ivs.net.Method;
import com.amazonaws.ivs.net.WriteCallback;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;

public class Request {
    private final String url;
    private final Method method;
    private final Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> queryParams = new HashMap<String, String>();
    private WriteCallback streamCallback;
    private ByteBuffer content;
    private int timeoutSeconds = 10;
    private boolean cancelled;
    private Future<?> future;
    private Cancellable cancellable;

    public Request(String url, Method method) {
        this.url = url;
        this.method = method;
    }

    public Request(String url, String method) {
        this.url = url;
        this.method = Request.stringToMethod(method);
    }

    public String getUrl() {
        try {
            URL originalUrl = new URL(this.url);
            ArrayList<String> newQueryParamPairs = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
                newQueryParamPairs.add(entry.getKey() + "=" + entry.getValue());
            }
            String originalQueryString = originalUrl.getQuery();
            if (originalQueryString != null) {
                String[] queryParamPairs;
                for (String pair : queryParamPairs = originalQueryString.split("&")) {
                    String[] parts = pair.split("=");
                    if (parts.length != 2 || this.queryParams.containsKey(parts[0])) continue;
                    newQueryParamPairs.add(pair);
                }
            }
            String newQueryString = String.join((CharSequence)"&", newQueryParamPairs);
            String newPath = originalUrl.getPath();
            if (!newQueryString.isEmpty()) {
                newPath = newPath + "?";
                newPath = newPath + newQueryString;
            }
            URL newURL = new URL(originalUrl.getProtocol(), originalUrl.getHost(), originalUrl.getPort(), newPath);
            return newURL.toString();
        }
        catch (MalformedURLException e) {
            return this.url;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    public void setContent(ByteBuffer content) {
        ByteBuffer copy = ByteBuffer.allocateDirect(content.remaining());
        copy.put(content);
        copy.rewind();
        this.content = copy;
    }

    public WriteCallback getContentCallback() {
        return this.streamCallback;
    }

    public void setContentCallback(WriteCallback callback) {
        this.streamCallback = callback;
    }

    public void setHeader(String key, String value) {
        this.getHeaders().put(key, value);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setQueryParam(String key, String value) {
        this.getQueryParams().put(key, value);
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public int getTimeout() {
        return this.timeoutSeconds;
    }

    public void setTimeout(int seconds) {
        this.timeoutSeconds = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Object object = this.lock();
        synchronized (object) {
            this.cancelled = true;
            if (this.future != null) {
                this.future.cancel(true);
            }
            if (this.cancellable != null) {
                this.cancellable.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCancelled() {
        Object object = this.lock();
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancellable(Cancellable cancellable) {
        Object object = this.lock();
        synchronized (object) {
            this.cancellable = cancellable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFuture(Future<?> future) {
        Object object = this.lock();
        synchronized (object) {
            this.future = future;
        }
    }

    Object lock() {
        return this;
    }

    private static Method stringToMethod(String method) {
        try {
            return Method.valueOf(method.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return Method.GET;
        }
    }

    public static interface Cancellable {
        public void cancel();
    }
}

