/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.net;

import com.amazonaws.ivs.net.ReadCallback;
import com.amazonaws.ivs.net.StreamConsumer;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;

public class Response {
    private final int status;
    private final Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final String url;
    private StreamConsumer consumer;
    private ExecutorService executorService;

    Response(int status, String url) {
        this.status = status;
        this.url = url;
    }

    public int getStatus() {
        return this.status;
    }

    public void setConsumer(ExecutorService executorService, StreamConsumer consumer) {
        this.executorService = executorService;
        this.consumer = consumer;
    }

    public void setHeader(String key, String value) {
        if (key != null) {
            this.headers.put(key, value);
        }
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public String getUrl() {
        return this.url;
    }

    public void readContent(final ReadCallback callback) {
        if (this.executorService != null) {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    Response.this.consumer.consume(callback);
                }
            });
        } else {
            this.consumer.consume(callback);
        }
    }
}

