/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import com.amazonaws.ivs.player.Logging;

class AudioFocusHandler
implements AudioManager.OnAudioFocusChangeListener {
    private boolean enabled;
    private final AudioManager audioManager;
    private AudioFocusRequest focusRequest;
    private int focusMode = -1;
    private int defaultAudioStream = 3;

    AudioFocusHandler(Context context) {
        this.audioManager = (AudioManager)context.getSystemService("audio");
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.abandonFocus();
        }
    }

    public void requestFocus() {
        if (this.enabled) {
            int result;
            int mode = 2;
            if (Build.VERSION.SDK_INT >= 26) {
                AudioFocusRequest.Builder builder = new AudioFocusRequest.Builder(mode);
                AudioAttributes audioAttributes = new AudioAttributes.Builder().setContentType(3).setUsage(1).build();
                builder.setAudioAttributes(audioAttributes);
                builder.setWillPauseWhenDucked(false);
                builder.setOnAudioFocusChangeListener((AudioManager.OnAudioFocusChangeListener)this);
                this.focusRequest = builder.build();
                result = this.audioManager.requestAudioFocus(this.focusRequest);
            } else {
                result = this.audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, this.defaultAudioStream, mode);
            }
            if (result != 1) {
                switch (result) {
                    case 0: {
                        Logging.w("requestAudioFocus AUDIOFOCUS_REQUEST_FAILED");
                        break;
                    }
                    case 2: {
                        Logging.w("requestAudioFocus AUDIOFOCUS_REQUEST_DELAYED");
                    }
                }
            }
        }
    }

    public void abandonFocus() {
        if (this.enabled) {
            if (Build.VERSION.SDK_INT >= 26) {
                if (this.focusRequest != null) {
                    this.audioManager.abandonAudioFocusRequest(this.focusRequest);
                }
            } else {
                this.audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            }
        }
    }

    public int getVolumeControlStream() {
        if (Build.VERSION.SDK_INT >= 26 && this.focusRequest != null) {
            return this.focusRequest.getAudioAttributes().getVolumeControlStream();
        }
        return this.defaultAudioStream;
    }

    public void onAudioFocusChange(int i) {
        this.focusMode = i;
        switch (this.focusMode) {
            case -1: {
                Logging.i("AUDIOFOCUS_LOSS pause");
                break;
            }
            case -2: {
                break;
            }
            case -3: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
        }
    }
}

