/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.annotation.SuppressLint;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.media.MediaFormat;
import android.media.PlaybackParams;
import android.os.Build;
import android.os.Process;
import android.os.Trace;
import com.amazonaws.ivs.player.AudioRenderer;
import com.amazonaws.ivs.player.Logging;
import com.amazonaws.ivs.player.MediaRenderer;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

class AudioTrackRenderer
implements MediaRenderer,
AudioRenderer {
    private static final int BUFFERS = 2;
    private static final int MAX_PLAYBACK_RATE = 2;
    private AudioTrack track;
    private int audioSessionId;
    private int frameSizeBytes;
    private int bytesWritten;
    private int bufferSize;
    private int maxPlaybackRate;
    private long framesWritten;
    private long playheadBasePosition;
    private long playheadPrevPosition;
    private long sampleTimeUs;
    private long startMediaTimeUs;
    private long startSystemTimeNs;
    private float volume = 1.0f;
    private float playbackRate = 1.0f;
    private boolean started;
    private boolean outOfSync = false;
    private MediaFormat format;

    AudioTrackRenderer() {
        this(2);
    }

    AudioTrackRenderer(int maxRate) {
        this.maxPlaybackRate = maxRate;
        Process.setThreadPriority((int)-19);
    }

    private void updateTrackVolume() {
        if (this.track != null) {
            Logging.i("Set audio track volume " + this.volume);
            int result = this.track.setVolume(this.volume);
            this.checkResult(result);
        }
    }

    private void updatePlaybackRate() {
        if (this.track != null && this.track.getState() == 1) {
            Logging.i("Set playback rate " + this.playbackRate);
            if (Build.VERSION.SDK_INT >= 23) {
                PlaybackParams params = new PlaybackParams();
                this.track.setPlaybackParams(params.setSpeed(this.playbackRate));
            } else {
                this.track.setPlaybackRate((int)((float)this.track.getSampleRate() * this.playbackRate));
            }
        }
    }

    private void adjustBufferSize(float oldPlaybackRate, float newPlaybackRate) {
        float newRate;
        float oldRate;
        if (this.track != null && Build.VERSION.SDK_INT >= 24 && (oldRate = Math.max(oldPlaybackRate, 1.0f)) != (newRate = Math.max(newPlaybackRate, 1.0f))) {
            this.track.setBufferSizeInFrames((int)((float)this.track.getBufferSizeInFrames() * newRate / oldRate));
        }
    }

    @Override
    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    @Override
    public void setVolume(float volume) {
        this.volume = volume;
        this.updateTrackVolume();
    }

    @Override
    public void setPlaybackRate(float rate) {
        this.startMediaTimeUs = this.getCurrentMediaTimeUs();
        this.startSystemTimeNs = System.nanoTime();
        this.adjustBufferSize(this.playbackRate, rate);
        this.playbackRate = rate;
        try {
            this.updatePlaybackRate();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            this.configure(this.format);
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private static int createChannelConfig(int channelCount) {
        switch (channelCount) {
            case 1: {
                return 4;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 28;
            }
            case 4: {
                return 204;
            }
            case 5: {
                return 220;
            }
            case 6: {
                return 252;
            }
            case 7: {
                return 1276;
            }
            case 8: {
                return 6396;
            }
        }
        return 1;
    }

    @Override
    public void configure(MediaFormat format) {
        this.format = format;
        int sampleRate = format.getInteger("sample-rate");
        int channelCount = format.getInteger("channel-count");
        if (this.track != null) {
            if (this.track.getSampleRate() == sampleRate && this.track.getChannelCount() == channelCount) {
                return;
            }
            this.flush();
            this.release();
        }
        Trace.beginSection((String)"AudioTrackRenderer configure");
        int encoding = 2;
        int channelConfig = AudioTrackRenderer.createChannelConfig(channelCount);
        this.bufferSize = AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)encoding);
        if (this.bufferSize == -2) {
            this.bufferSize = sampleRate;
            Logging.w("Error getting min buffer size using sample rate " + sampleRate);
        }
        this.bufferSize *= 2 * this.maxPlaybackRate;
        this.frameSizeBytes = channelCount * 2;
        this.framesWritten = 0L;
        int sessionId = this.audioSessionId > 0 ? this.audioSessionId : 0;
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setContentType(3).setUsage(1).build();
        AudioFormat audioFormat = new AudioFormat.Builder().setEncoding(encoding).setSampleRate(sampleRate).setChannelMask(channelConfig).build();
        Logging.i("Creating audio track format: " + audioFormat);
        this.track = Build.VERSION.SDK_INT >= 23 ? new AudioTrack.Builder().setAudioAttributes(audioAttributes).setAudioFormat(audioFormat).setBufferSizeInBytes(this.bufferSize).setTransferMode(1).setSessionId(sessionId).build() : new AudioTrack(audioAttributes, audioFormat, this.bufferSize, 1, sessionId);
        this.adjustBufferSize(this.maxPlaybackRate, this.playbackRate);
        this.audioSessionId = this.track.getAudioSessionId();
        this.updateTrackVolume();
        this.updatePlaybackRate();
        Trace.endSection();
    }

    @Override
    public void start() {
        Trace.beginSection((String)"AudioTrackRenderer start");
        this.started = true;
        Trace.endSection();
    }

    @Override
    public void stop() {
        Trace.beginSection((String)"AudioTrackRenderer start");
        this.started = false;
        if (this.track != null && this.track.getPlayState() == 3) {
            this.track.pause();
            this.startMediaTimeUs = 0L;
            this.startSystemTimeNs = 0L;
        }
        Trace.endSection();
    }

    @Override
    public void flush() {
        Trace.beginSection((String)"AudioTrackRenderer flush");
        this.sampleTimeUs = 0L;
        this.framesWritten = 0L;
        this.bytesWritten = 0;
        this.playheadPrevPosition = 0L;
        this.startMediaTimeUs = 0L;
        this.startSystemTimeNs = 0L;
        this.outOfSync = false;
        if (this.track != null) {
            this.track.stop();
            this.track.flush();
            long position = this.track.getPlaybackHeadPosition();
            if (position > 0L) {
                Logging.w("audio position at flush " + position);
                this.release();
            }
        }
        Trace.endSection();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void render(ByteBuffer buffer, int size, long presentationTimeUs) {
        if (this.track == null || size == 0) {
            return;
        }
        Trace.beginSection((String)("AudioTrackRenderer render " + presentationTimeUs));
        long currentMediaTimeUs = this.getCurrentMediaTimeUs();
        if (this.startMediaTimeUs <= 0L) {
            this.startMediaTimeUs = presentationTimeUs;
        } else if (this.outOfSync) {
            if (presentationTimeUs < currentMediaTimeUs) return;
            this.outOfSync = false;
        } else if (this.startSystemTimeNs > 0L && currentMediaTimeUs - presentationTimeUs > 900000L) {
            this.outOfSync = true;
            Logging.i(String.format("Audio samples out of sync current: %d present: %d", currentMediaTimeUs, presentationTimeUs));
            return;
        }
        int result = this.track.write(buffer, size, 0);
        this.framesWritten += (long)(size / this.frameSizeBytes);
        this.bytesWritten += size;
        this.sampleTimeUs = presentationTimeUs;
        if (this.started && this.bytesWritten >= this.bufferSize / this.maxPlaybackRate && this.track.getPlayState() != 3) {
            if (this.startSystemTimeNs <= 0L) {
                this.startSystemTimeNs = System.nanoTime();
            }
            this.track.play();
        }
        this.checkResult(result);
        Trace.endSection();
    }

    private long getCurrentMediaTimeUs() {
        if (this.startMediaTimeUs <= 0L || this.startSystemTimeNs <= 0L) {
            return -1L;
        }
        long elapsedNs = (long)((float)(System.nanoTime() - this.startSystemTimeNs) * this.playbackRate);
        return this.startMediaTimeUs + TimeUnit.NANOSECONDS.toMicros(elapsedNs);
    }

    @Override
    public void release() {
        if (this.track != null) {
            try {
                Trace.beginSection((String)"AudioTrackRenderer release");
                this.track.release();
            }
            finally {
                this.track = null;
                Trace.endSection();
            }
        }
    }

    @Override
    public long getRenderedPresentationTime() {
        if (this.sampleTimeUs == 0L || this.track == null || this.track.getPlayState() != 3) {
            return -1L;
        }
        long position = 0xFFFFFFFFL & (long)this.track.getPlaybackHeadPosition();
        if (this.playheadPrevPosition > 0L && position < this.playheadPrevPosition) {
            Logging.w("AudioTrack.getPlaybackHeadPosition " + position + " < previous " + this.playheadPrevPosition);
            this.playheadBasePosition = this.playheadPrevPosition;
        }
        this.playheadPrevPosition = position;
        long frames = this.framesWritten - (position += this.playheadBasePosition);
        long audioLatencyUs = (long)((double)frames / (double)this.track.getSampleRate() * 1000000.0);
        long time = this.sampleTimeUs - audioLatencyUs;
        if (time < 0L) {
            time = 0L;
        }
        return time;
    }

    @Override
    public boolean shouldProcessMore() {
        return true;
    }

    private void checkResult(int result) {
        switch (result) {
            case -3: {
                Logging.e("AudioTrack.ERROR_INVALID_OPERATION");
                break;
            }
            case -2: {
                Logging.e("AudioTrack.ERROR_BAD_VALUE");
                break;
            }
            case -6: {
                Logging.e("AudioTrack.ERROR_DEAD_OBJECT");
                this.flush();
                break;
            }
        }
    }
}

