/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import com.amazonaws.ivs.player.DeviceConfigPropertyHolder;
import com.amazonaws.ivs.player.Experimental;
import com.amazonaws.ivs.player.Experiments;
import com.amazonaws.ivs.player.IVSFeature;
import com.amazonaws.ivs.player.Logging;
import com.amazonaws.ivs.player.SessionConfig;
import com.amazonaws.ivs.player.SuperResolution;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Configuration {
    static final String KEY_SURFACE_SIZE_FILTER_ENABLED = "surfaceSizeFilterEnabled";
    static final String KEY_RESOLUTION_FILTER_MODE = "resolutionFilterMode";
    static final String VALUE_ASPECT_RATIO = "aspectRatio";
    static final String KEY_CODEC = "codecConfigs";
    private final JSONObject configuration = new JSONObject();
    private Experiments experiments;
    private final ArrayList<IVSFeature<?>> features = new ArrayList();

    Configuration() {
        this.loadDefaults();
    }

    protected void registerFeature(IVSFeature<?> feature) {
        if (this.experiments != null) {
            try {
                feature.overrideWith(this.experiments);
                if (feature instanceof Experimental) {
                    Experiments.Experiment experiment = ((Experimental)((Object)feature)).getDescription();
                    ((JSONObject)this.configuration.get(Group.EXPERIMENT.key)).put(experiment.name(), (Object)this.fillExperimentData(experiment));
                }
                if (feature instanceof SuperResolution) {
                    ((JSONObject)this.configuration.get(Group.EXPERIMENT.key)).put(Experiments.Experiment.ANDROID_GPU.name(), (Object)this.fillExperimentData(Experiments.Experiment.ANDROID_GPU));
                }
            }
            catch (JSONException e) {
                Logging.w("Failed to update feature with experiments", e);
            }
        }
        this.features.add(feature);
    }

    void loadDefaults() {
        try {
            JSONObject adaptiveBitrate = new JSONObject();
            adaptiveBitrate.put(KEY_SURFACE_SIZE_FILTER_ENABLED, false);
            this.configuration.put(Group.ADAPTIVE_BITRATE.key, (Object)adaptiveBitrate);
            JSONObject analytics = new JSONObject();
            this.configuration.put(Group.ANALYTICS.key, (Object)analytics);
            JSONObject media = new JSONObject();
            media.put(KEY_CODEC, (Object)new JSONArray());
            this.configuration.put(Group.MEDIA.key, (Object)media);
            JSONObject experiments = new JSONObject();
            this.configuration.put(Group.EXPERIMENT.key, (Object)experiments);
        }
        catch (JSONException jsone) {
            Logging.w("Failed to load default configurations", jsone);
        }
    }

    void overrideWith(SessionConfig additionalEventProperties) {
        try {
            this.merge(additionalEventProperties.get(), this.configuration);
        }
        catch (JSONException jsone) {
            Logging.w("Failed to update configurations with session data", jsone);
        }
    }

    void overrideWith(Experiments experiments) {
        this.experiments = experiments;
    }

    void overrideWith(DeviceConfigPropertyHolder propertyHolder) {
        try {
            for (IVSFeature<?> feature : this.features) {
                JSONObject payload = feature.overrideWithPayload(propertyHolder);
                if (!feature.isEnabled) continue;
                if (!this.configuration.has(feature.key)) {
                    this.configuration.put(feature.key, (Object)new JSONObject());
                }
                this.merge(payload, this.configuration.getJSONObject(feature.key));
            }
        }
        catch (JSONException e) {
            Logging.w("Failed to update configurations from device config", e);
        }
    }

    String getString(Group group, String key) {
        if (this.configuration.has(group.key)) {
            return this.configuration.optJSONObject(group.key).optString(key, null);
        }
        return null;
    }

    boolean getBoolean(Group group, String key) {
        if (this.configuration.has(group.key)) {
            return this.configuration.optJSONObject(group.key).optBoolean(key);
        }
        return false;
    }

    public String toString() {
        return this.configuration.toString();
    }

    private JSONObject fillExperimentData(Experiments.Experiment experiment) throws JSONException {
        JSONObject experimentData = new JSONObject();
        experimentData.put("id", (Object)experiment.id);
        experimentData.put("assignment", (Object)this.experiments.getAssignedGroup(experiment));
        experimentData.put("version", (Object)this.experiments.getVersion(experiment));
        experimentData.put("type", (Object)this.experiments.getType(experiment));
        return experimentData;
    }

    private void merge(JSONObject source, JSONObject target) throws JSONException {
        Iterator it = source.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = source.get(key);
            if (!target.has(key)) {
                target.put(key, value);
                continue;
            }
            if (value instanceof JSONObject) {
                this.merge((JSONObject)value, target.getJSONObject(key));
                continue;
            }
            target.put(key, value);
        }
    }

    static enum Group {
        ADAPTIVE_BITRATE("adaptiveBitrate"),
        ANALYTICS("analytics"),
        EXPERIMENT("experiments"),
        MEDIA("media");

        final String key;

        private Group(String name) {
            this.key = name;
        }
    }
}

