/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import androidx.annotation.Nullable;
import com.amazonaws.ivs.player.json.Json;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ConfigurationParser {
    static HashMap<Class, Field[]> classToFieldMap = new HashMap();

    ConfigurationParser() {
    }

    @Nullable
    static <T> T createConfigurationFromJson(JSONObject json, Class<T> configurationType) throws JSONException {
        T result = null;
        try {
            result = configurationType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return result;
        }
        ConfigurationParser.updateConfigurationFromJson(json, result);
        return result;
    }

    static <T> void updateConfigurationFromJson(JSONObject json, T configurationInstance) throws JSONException {
        Field[] type_fields;
        if (classToFieldMap.containsValue(configurationInstance.getClass())) {
            type_fields = classToFieldMap.get(configurationInstance.getClass());
        } else {
            type_fields = configurationInstance.getClass().getFields();
            classToFieldMap.put(configurationInstance.getClass(), type_fields);
        }
        for (Field field : type_fields) {
            boolean isRequired;
            Json jsonAnnotation = field.getAnnotation(Json.class);
            if (jsonAnnotation == null) continue;
            String key = jsonAnnotation.value();
            if (key.isEmpty()) {
                key = field.getName();
            }
            if (!(isRequired = jsonAnnotation.required()) && !json.has(key)) continue;
            if (isRequired && !json.has(key)) {
                throw new JSONException("Field " + field.getName() + " marked required, but was not found in json");
            }
            if (field.getType().isArray()) {
                ConfigurationParser.handleArray(field, key, json, configurationInstance);
                continue;
            }
            Class<?> type = field.getType();
            if (ConfigurationParser.isBasicType(type)) {
                ConfigurationParser.handlePrimitive(field, key, type, json, configurationInstance);
                continue;
            }
            ConfigurationParser.handleComposite(field, key, type, json, configurationInstance);
        }
    }

    @Nullable
    static <T> JSONObject createJsonFromConfiguration(T configurationInstance) throws JSONException {
        Field[] type_fields;
        JSONObject json = new JSONObject();
        if (classToFieldMap.containsValue(configurationInstance.getClass())) {
            type_fields = classToFieldMap.get(configurationInstance.getClass());
        } else {
            type_fields = configurationInstance.getClass().getFields();
            classToFieldMap.put(configurationInstance.getClass(), type_fields);
        }
        for (Field field : type_fields) {
            boolean isFieldNull;
            String name = field.getName();
            Json jsonAnnotation = field.getAnnotation(Json.class);
            if (jsonAnnotation == null) continue;
            String key = jsonAnnotation.value();
            if (key.isEmpty()) {
                key = name;
            }
            boolean isRequired = jsonAnnotation.required();
            boolean bl = isFieldNull = ConfigurationParser.GetFieldValue(field, configurationInstance) == null;
            if (!isRequired && isFieldNull) continue;
            if (isRequired && isFieldNull) {
                throw new JSONException("Field " + field.getName() + " marked required, but was null");
            }
            if (field.getType().isArray()) {
                Class<?> componentType = field.getType().getComponentType();
                if (ConfigurationParser.isBasicType(componentType)) {
                    JSONArray jsonArray = new JSONArray(ConfigurationParser.GetFieldValue(field, configurationInstance));
                    json.put(key, (Object)jsonArray);
                    continue;
                }
                Object[] subInstance = (Object[])ConfigurationParser.GetFieldValue(field, configurationInstance);
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < Objects.requireNonNull(subInstance).length; ++i) {
                    JSONObject subJson = ConfigurationParser.createJsonFromConfiguration(Objects.requireNonNull(componentType.cast(subInstance[i])));
                    jsonArray.put((Object)subJson);
                }
                json.put(key, (Object)jsonArray);
                continue;
            }
            Class<?> type = field.getType();
            if (ConfigurationParser.isBasicType(type)) {
                json.put(key, ConfigurationParser.GetFieldValue(field, configurationInstance));
                continue;
            }
            JSONObject subJson = ConfigurationParser.createJsonFromConfiguration(type);
            json.put(key, (Object)subJson);
        }
        return json;
    }

    private static <T> void handleArray(Field field, String name, JSONObject json, T configurationInstance) throws JSONException {
        Class<?> arrayType = field.getType();
        Class<?> elementType = arrayType.getComponentType();
        if (!(json.get(name) instanceof JSONArray)) {
            ConfigurationParser.SetFieldValue(field, Array.newInstance(elementType, 0), configurationInstance);
            return;
        }
        JSONArray jsonArray = json.getJSONArray(name);
        if (arrayType == int[].class || arrayType == Integer[].class) {
            if (!ConfigurationParser.checkJsonArrayType(jsonArray, Integer.class)) {
                ConfigurationParser.SetFieldValue(field, Array.newInstance(elementType, 0), configurationInstance);
            } else {
                Object values = Array.newInstance(elementType, jsonArray.length());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Array.set(values, i, jsonArray.getInt(i));
                }
                ConfigurationParser.SetFieldValue(field, values, configurationInstance);
            }
        } else if (arrayType == long[].class || arrayType == Long[].class) {
            if (!ConfigurationParser.checkJsonArrayType(jsonArray, Long.class)) {
                ConfigurationParser.SetFieldValue(field, Array.newInstance(elementType, 0), configurationInstance);
            } else {
                Object values = Array.newInstance(elementType, jsonArray.length());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Array.set(values, i, jsonArray.getLong(i));
                }
                ConfigurationParser.SetFieldValue(field, values, configurationInstance);
            }
        } else if (arrayType == double[].class || arrayType == Double[].class) {
            if (!ConfigurationParser.checkJsonArrayType(jsonArray, Double.class)) {
                ConfigurationParser.SetFieldValue(field, Array.newInstance(elementType, 0), configurationInstance);
            } else {
                Object values = Array.newInstance(elementType, jsonArray.length());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Array.set(values, i, jsonArray.getDouble(i));
                }
                ConfigurationParser.SetFieldValue(field, values, configurationInstance);
            }
        } else if (arrayType == boolean[].class || arrayType == Boolean[].class) {
            if (!ConfigurationParser.checkJsonArrayType(jsonArray, Boolean.class)) {
                ConfigurationParser.SetFieldValue(field, Array.newInstance(elementType, 0), configurationInstance);
            } else {
                Object values = Array.newInstance(elementType, jsonArray.length());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Array.set(values, i, jsonArray.getBoolean(i));
                }
                ConfigurationParser.SetFieldValue(field, values, configurationInstance);
            }
        } else if (arrayType == String[].class) {
            if (!ConfigurationParser.checkJsonArrayType(jsonArray, String.class)) {
                ConfigurationParser.SetFieldValue(field, Array.newInstance(elementType, 0), configurationInstance);
            } else {
                Object values = Array.newInstance(elementType, jsonArray.length());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Array.set(values, i, jsonArray.getString(i));
                }
                ConfigurationParser.SetFieldValue(field, values, configurationInstance);
            }
        } else if (!ConfigurationParser.checkJsonArrayType(jsonArray, JSONObject.class)) {
            ConfigurationParser.SetFieldValue(field, Array.newInstance(elementType, 0), configurationInstance);
        } else {
            Object values = Array.newInstance(elementType, jsonArray.length());
            for (int i = 0; i < jsonArray.length(); ++i) {
                Array.set(values, i, ConfigurationParser.createConfigurationFromJson(jsonArray.getJSONObject(i), elementType));
            }
            ConfigurationParser.SetFieldValue(field, values, configurationInstance);
        }
    }

    private static <T> boolean checkJsonArrayType(JSONArray array, Class<T> type) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            boolean isjsonInstanceOfInteger = array.get(i) instanceof Integer;
            boolean isFieldTypeLarger = type.isInstance(0L) || type.isInstance(0.0);
            boolean isJsonInstanceSameAsField = type.isInstance(array.get(i));
            if (isJsonInstanceSameAsField || isjsonInstanceOfInteger && isFieldTypeLarger) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> void handlePrimitive(Field field, String name, Class<?> type, JSONObject json, T instance) throws JSONException {
        Object jsonElem = json.get(name);
        if (type == Integer.TYPE || type == Integer.class) {
            if (!(jsonElem instanceof Integer)) {
                throw new JSONException("Found json element {" + name + "} expected type integer, found " + jsonElem.getClass().getName());
            }
            ConfigurationParser.SetFieldValue(field, (Integer)jsonElem, instance);
            return;
        } else if (type == Long.TYPE || type == Long.class) {
            if (jsonElem instanceof Long) {
                ConfigurationParser.SetFieldValue(field, (Long)jsonElem, instance);
                return;
            } else {
                if (!(jsonElem instanceof Integer)) throw new JSONException("Found json element {" + name + "} expected type Long, found " + jsonElem.getClass().getName());
                ConfigurationParser.SetFieldValue(field, (Integer)jsonElem, instance);
            }
            return;
        } else if (type == Double.TYPE || type == Double.class) {
            if (jsonElem instanceof Double) {
                ConfigurationParser.SetFieldValue(field, (Double)jsonElem, instance);
                return;
            } else {
                if (!(jsonElem instanceof Integer)) throw new JSONException("Found json element {" + name + "} expected type Double, found " + jsonElem.getClass().getName());
                ConfigurationParser.SetFieldValue(field, (Integer)jsonElem, instance);
            }
            return;
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            if (!(jsonElem instanceof Boolean)) {
                throw new JSONException("Found json element {" + name + "} expected type Boolean, found " + jsonElem.getClass().getName());
            }
            ConfigurationParser.SetFieldValue(field, (Boolean)jsonElem, instance);
            return;
        } else {
            if (type != String.class) throw new JSONException("Unhandled primitive case for json");
            if (!(jsonElem instanceof String)) {
                throw new JSONException("Found json element {" + name + "} expected type String, found " + jsonElem.getClass().getName());
            }
            ConfigurationParser.SetFieldValue(field, (String)jsonElem, instance);
        }
    }

    private static <T> void handleComposite(Field field, String name, Class<?> type, JSONObject json, T instance) throws JSONException {
        JSONObject subObj = json.getJSONObject(name);
        Object subinstance = ConfigurationParser.GetFieldValue(field, instance);
        if (subinstance == null) {
            subinstance = ConfigurationParser.createConfigurationFromJson(subObj, type);
        } else {
            ConfigurationParser.updateConfigurationFromJson(subObj, subinstance);
        }
        ConfigurationParser.SetFieldValue(field, subinstance, instance);
    }

    private static <T> boolean isBasicType(Class<T> type) {
        return type.isPrimitive() || type == String.class || type == Integer.class || type == Long.class || type == Double.class || type == Boolean.class;
    }

    private static <T> void SetFieldValue(Field field, T value, Object obj) throws JSONException {
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException ignored) {
            throw new JSONException("Couldn't set " + field.getName() + " with value " + value);
        }
    }

    private static Object GetFieldValue(Field field, Object obj) throws JSONException {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException ignored) {
            throw new JSONException("Couldn't get " + field.getName() + " value");
        }
    }

    static interface Encodable {
        public void updateWithJson(JSONObject var1) throws JSONException;

        public JSONObject toJson() throws JSONException;
    }
}

