/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amazonaws.ivs.experiments.ExperimentData;
import com.amazonaws.ivs.player.AnalyticsFeature;
import com.amazonaws.ivs.player.Configuration;
import com.amazonaws.ivs.player.Cue;
import com.amazonaws.ivs.player.DeviceConfigPropertyHolder;
import com.amazonaws.ivs.player.EGLManager;
import com.amazonaws.ivs.player.ErrorType;
import com.amazonaws.ivs.player.Experiments;
import com.amazonaws.ivs.player.GPUAnalyticsEvent;
import com.amazonaws.ivs.player.HardwareInfo;
import com.amazonaws.ivs.player.HlsSource;
import com.amazonaws.ivs.player.IVSFeature;
import com.amazonaws.ivs.player.Logging;
import com.amazonaws.ivs.player.MediaPlayer;
import com.amazonaws.ivs.player.Platform;
import com.amazonaws.ivs.player.Player;
import com.amazonaws.ivs.player.PlayerException;
import com.amazonaws.ivs.player.PlayerInternal;
import com.amazonaws.ivs.player.ProbeV2Feature;
import com.amazonaws.ivs.player.Quality;
import com.amazonaws.ivs.player.SeiMessage;
import com.amazonaws.ivs.player.SessionConfig;
import com.amazonaws.ivs.player.Size;
import com.amazonaws.ivs.player.Source;
import com.amazonaws.ivs.player.SourceGroup;
import com.amazonaws.ivs.player.Statistics;
import com.amazonaws.ivs.player.SuperResolution;
import com.amazonaws.ivs.player.UnavailableQuality;
import com.amazonaws.ivs.player.VideoFrameTransformer;
import com.amazonaws.ivs.player.VideoRenderer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;

class CorePlayerImpl
implements MediaPlayer,
VideoRenderer.VideoSizeListener,
IVSFeature.EventListener {
    private final Platform platform;
    private long player;
    private final Handler handler;
    private final Set<Player.Listener> listeners;
    private final Set<PlayerInternal.PlaybackListener> playbackListeners;
    private final AtomicBoolean closed;
    private final Statistics statistics;
    private final Configuration config;
    private EGLManager eglManager = null;
    private HardwareInfo hardwareInfo = null;
    private static Platform preloadPlatform;
    private Context context;
    private ArrayList<IVSFeature<?>> features;
    private SuperResolution superRes;
    private VideoFrameTransformer videoFrameTransformer;

    public CorePlayerImpl(@NonNull Context context) {
        this(context, new Configuration());
    }

    public CorePlayerImpl(@NonNull Context context, Configuration config) {
        this.platform = new Platform(context, this);
        this.player = this.init(context, this.platform, config.toString());
        this.handler = new Handler(Looper.getMainLooper());
        this.closed = new AtomicBoolean();
        this.listeners = new CopyOnWriteArraySet<Player.Listener>();
        this.playbackListeners = new CopyOnWriteArraySet<PlayerInternal.PlaybackListener>();
        this.statistics = new Statistics();
        this.config = config;
        Size maxDisplaySize = this.platform.getDisplaySize();
        this.setDisplaySize(maxDisplaySize.width, maxDisplaySize.height);
        if (Logging.isVerbose()) {
            this.setLogLevel(Player.LogLevel.DEBUG);
        }
        this.context = context;
        this.features = this.addSupportedFeatures();
        for (IVSFeature<?> feature : this.features) {
            this.config.registerFeature(feature);
        }
        if (this.superRes != null) {
            this.superRes.init(context, this.platform);
            this.videoFrameTransformer = this.superRes.getTransformer();
        }
    }

    private static native void initialize();

    private native long init(Context var1, Platform var2, String var3);

    private native void linkSuperRes(long var1, long var3);

    private native void load(long var1, String var3, String var4, String var5);

    private native void loadSource(long var1, long var3, String var5);

    private native Source preload(long var1, String var3, Handler var4, Source.Listener var5);

    private native void setSourceGroup(long var1, String var3);

    @Nullable
    private native SourceGroup getSourceGroup(long var1);

    private native HashSet<SourceGroup> getSourceGroups(long var1);

    private native void seekTo(long var1, long var3);

    private native void play(long var1);

    private native void pause(long var1);

    private native void release(long var1);

    private native boolean isMuted(long var1);

    private native int getState(long var1);

    private native long getPosition(long var1);

    private native long getSyncTime(long var1);

    private native long getAverageBitrate(long var1);

    private native long getBandwidthEstimate(long var1);

    private native long getBufferedPosition(long var1);

    private native long getLiveLatency(long var1);

    private native long getDuration(long var1);

    private native HashSet<Quality> getQualities(long var1);

    private native Quality getQuality(long var1);

    private native HashSet<UnavailableQuality> getUnavailableQualities(long var1);

    private native void setQuality(long var1, String var3, boolean var4);

    private native String getVersion(long var1);

    private native boolean isAutoQualityMode(long var1);

    private native void setAuthToken(long var1, String var3);

    private native void setAutoQualityMode(long var1, boolean var3, boolean var4);

    private native void setAutoMaxVideoSize(long var1, int var3, int var4);

    private native void setAutoInitialBitrate(long var1, int var3);

    private native void setAutoMaxBitrate(long var1, int var3);

    private native void setAutoMaxQuality(long var1, Quality var3);

    private native void setConfiguration(long var1, String var3);

    private native boolean isLiveLowLatency(long var1);

    private native void setLiveLowLatencyEnabled(long var1, boolean var3);

    private native void setLooping(long var1, boolean var3);

    private native void setLogLevel(long var1, String var3);

    private native void setMuted(long var1, boolean var3);

    private native void setRebufferToLive(long var1, boolean var3);

    private native void setSurface(long var1, Surface var3);

    private native void setSurfaceSize(long var1, int var3, int var4);

    private native float getPlaybackRate(long var1);

    private native void setPlaybackRate(long var1, float var3);

    private native void setVolume(long var1, float var3);

    private native float getVolume(long var1);

    private native void setClientId(long var1, String var3);

    private native void setDeviceId(long var1, String var3);

    private native void getStatistics(long var1, Statistics var3);

    private native String getPath(long var1);

    private native String getProtocol(long var1);

    private native String getSessionId(long var1);

    private native String[] getChannelMetadata(long var1);

    private native Map<String, String> getExperiments(long var1);

    private native void setExperiment(long var1, ExperimentData var3);

    private native void setOrigin(long var1, String var3);

    private native void setUserAgent(long var1, String var3);

    private native void setInitialBufferDuration(long var1, long var3);

    private native void setResumeAfterReconnect(long var1, boolean var3);

    private native void setDisplaySize(long var1, int var3, int var4);

    private native void setDrmEnabled(long var1, boolean var3);

    @Nullable
    private native DeviceConfigPropertyHolder getDeviceConfigPropertyHolderImpl(long var1);

    private native void onGpuInitEvent(long var1, GPUAnalyticsEvent.GPUInitAnalyticsEvent var3);

    private native void onGpuStatusEvent(long var1, GPUAnalyticsEvent.GPUStatusAnalyticsEvent var3);

    private native void onGpuErrorEvent(long var1, GPUAnalyticsEvent.GPUErrorAnalyticsEvent var3);

    protected void finalize() throws Throwable {
        try {
            if (this.player != 0L) {
                Logging.e("Player not released, releasing from finalizer");
            }
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    void handleCue(final Cue cue) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onCue(cue);
                }
            }
        });
    }

    void handleSeiMessage(final SeiMessage seiMessage) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onSeiMessage(seiMessage);
                }
            }
        });
    }

    void handleDurationChanged(final long value) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onDurationChanged(value);
                }
            }
        });
    }

    void handleError(String source, int result, int code, String message) {
        final PlayerException exception = this.platform.createException(source, result, code, message);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onError(exception);
                }
            }
        });
    }

    void handleQualityChange(final Quality quality) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onQualityChanged(quality);
                }
            }
        });
    }

    void handleSourceGroupChange(final SourceGroup sourceGroup) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onSourceGroupChanged(sourceGroup);
                }
            }
        });
    }

    void handleRebuffering() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onRebuffering();
                }
            }
        });
    }

    void handleSeekCompleted(final long value) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onSeekCompleted(value);
                }
            }
        });
    }

    void handleStateChange(final int value) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                Player.State state = CorePlayerImpl.this.mapState(value);
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onStateChanged(state);
                }
            }
        });
    }

    void handleAnalyticsEvent(final String name, final String properties) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onAnalyticsEvent(name, properties);
                }
            }
        });
    }

    void handleMetadata(final String type, ByteBuffer data) {
        if (data != null) {
            final ByteBuffer copy = ByteBuffer.allocate(data.capacity());
            copy.put(data);
            copy.flip();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                        listener.onMetadata(type, copy);
                    }
                }
            });
        }
    }

    void handleNetworkUnavailable() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onNetworkUnavailable();
                }
            }
        });
    }

    void handleVideoFirstFrame(final long mediatime) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onVideoFirstFrame(mediatime);
                }
            }
        });
    }

    void handleSyncTimeChanged(final long value) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onSyncTimeChanged(value);
                }
            }
        });
    }

    private Player.State mapState(int state) {
        switch (state) {
            default: {
                return Player.State.IDLE;
            }
            case 1: {
                return Player.State.READY;
            }
            case 2: {
                return Player.State.BUFFERING;
            }
            case 3: {
                return Player.State.PLAYING;
            }
            case 4: 
        }
        return Player.State.ENDED;
    }

    @Override
    public void release() {
        if (this.closed.compareAndSet(false, true)) {
            this.handler.removeCallbacksAndMessages(null);
            for (PlayerInternal.PlaybackListener listener : this.playbackListeners) {
                listener.onRelease();
            }
            this.release(this.player);
            this.player = 0L;
            if (this.superRes != null) {
                this.superRes.release();
            }
        }
    }

    @Override
    public void addPlaybackListener(@NonNull PlayerInternal.PlaybackListener listener) {
        this.playbackListeners.add(listener);
    }

    @Override
    public void removePlaybackListener(@NonNull PlayerInternal.PlaybackListener listener) {
        this.playbackListeners.remove(listener);
    }

    @Override
    public void addListener(@NonNull Player.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(@NonNull Player.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int getAudioSessionId() {
        return this.platform.getAudioSessionId();
    }

    @Override
    @NonNull
    public Player.State getState() {
        return this.mapState(this.getState(this.player));
    }

    @Override
    public long getPosition() {
        return this.getPosition(this.player);
    }

    @Override
    public long getSyncTime() {
        return this.getSyncTime(this.player);
    }

    @Override
    public long getDuration() {
        return this.getDuration(this.player);
    }

    @Override
    public long getAverageBitrate() {
        return this.getAverageBitrate(this.player);
    }

    @Override
    public long getBandwidthEstimate() {
        return this.getBandwidthEstimate(this.player);
    }

    @Override
    public long getBufferedPosition() {
        return this.getBufferedPosition(this.player);
    }

    @Override
    public long getLiveLatency() {
        return this.getLiveLatency(this.player);
    }

    @Override
    @NonNull
    public String getVersion() {
        return this.getVersion(this.player);
    }

    @Override
    public boolean isMuted() {
        return this.isMuted(this.player);
    }

    @Override
    public void setLooping(boolean loop) {
        this.setLooping(this.player, loop);
    }

    @Override
    public void setLogLevel(@NonNull Player.LogLevel level) {
        Logging.setLogLevel(level.systemLogLevel());
        this.setLogLevel(this.player, level.toString().toLowerCase());
    }

    @Override
    public void setMuted(boolean muted) {
        this.setMuted(this.player, muted);
    }

    @Override
    public void setSurface(@Nullable Surface surface) {
        Surface transformerInputSurface;
        if (this.videoFrameTransformer != null && surface != null && surface.isValid() && (transformerInputSurface = this.videoFrameTransformer.getInputSurface()) != null && this.videoFrameTransformer.setOutputSurface(surface)) {
            Logging.d("Post process frame transformer surface creation");
            this.setSurface(this.player, transformerInputSurface);
            this.videoFrameTransformer.play();
            return;
        }
        this.setSurface(this.player, surface);
    }

    @Override
    public void setSurfaceSize(int width, int height) {
        this.setSurfaceSize(this.player, width, height);
    }

    @Override
    public float getPlaybackRate() {
        return this.getPlaybackRate(this.player);
    }

    @Override
    public void setPlaybackRate(float rate) {
        this.setPlaybackRate(this.player, rate);
    }

    @Override
    public void setVolume(float volume) {
        this.setVolume(this.player, volume);
    }

    @Override
    public float getVolume() {
        return this.getVolume(this.player);
    }

    @Override
    public void load(@NonNull Uri uri) {
        MediaPlayer.LoadOptions options = new MediaPlayer.LoadOptions(uri);
        this.load(options);
    }

    @Override
    public void load(@NonNull Uri uri, @NonNull String mediaType) {
        MediaPlayer.LoadOptions options = new MediaPlayer.LoadOptions(uri).setMediaType(mediaType);
        this.load(options);
    }

    @Override
    public void load(@NonNull MediaPlayer.LoadOptions options) {
        this.handler.post(() -> {
            for (PlayerInternal.PlaybackListener listener : this.playbackListeners) {
                listener.onLoad(options.getUri());
            }
        });
        this.config.overrideWith(options.getSessionConfig());
        this.config.overrideWith(this.getDeviceConfigPropertyHolder());
        if (this.superRes != null && this.superRes.isEnabled) {
            this.superRes.init(this.context, this.platform);
        }
        this.load(this.player, options.getUri().toString(), options.getMediaType(), this.config.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSource(@NonNull Source source) {
        this.config.overrideWith(this.getDeviceConfigPropertyHolder());
        Source source2 = source;
        synchronized (source2) {
            long handle = ((HlsSource)source).handle();
            if (handle == 0L) {
                this.handleError("Source", ErrorType.ERROR_INVALID_STATE.getErrorCode(), 0, "Source object not valid.");
                return;
            }
            this.loadSource(this.player, handle, this.config.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSource(@NonNull Source source, @NonNull SessionConfig sessionConfig) {
        this.config.overrideWith(sessionConfig);
        this.config.overrideWith(this.getDeviceConfigPropertyHolder());
        Source source2 = source;
        synchronized (source2) {
            long handle = ((HlsSource)source).handle();
            if (handle == 0L) {
                this.handleError("Source", ErrorType.ERROR_INVALID_STATE.getErrorCode(), 0, "Source object not valid.");
                return;
            }
            this.loadSource(this.player, handle, this.config.toString());
        }
    }

    @Override
    public void preload(@NonNull Uri uri, @NonNull Source.Listener listener) {
        this.preload(this.player, uri.toString(), this.handler, listener);
    }

    public HashSet<SourceGroup> getSourceGroups() {
        return this.getSourceGroups(this.player);
    }

    @Override
    public SourceGroup getSourceGroup() {
        return this.getSourceGroup(this.player);
    }

    @Override
    public void setSourceGroup(@NonNull String groupName) {
        this.setSourceGroup(this.player, groupName);
    }

    @Override
    public void seekTo(long position) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (PlayerInternal.PlaybackListener listener : CorePlayerImpl.this.playbackListeners) {
                    listener.onSeek();
                }
            }
        });
        this.seekTo(this.player, position);
    }

    @Override
    public void play() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (PlayerInternal.PlaybackListener listener : CorePlayerImpl.this.playbackListeners) {
                    listener.onPlay();
                }
            }
        });
        this.play(this.player);
    }

    @Override
    public void pause() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (PlayerInternal.PlaybackListener listener : CorePlayerImpl.this.playbackListeners) {
                    listener.onPause();
                }
            }
        });
        this.pause(this.player);
    }

    @Override
    @NonNull
    public Set<Quality> getQualities() {
        HashSet<Quality> result = this.getQualities(this.player);
        if (result == null) {
            this.handleError("Unspecified", ErrorType.ERROR.getErrorCode(), 0, "Failed to retrieve qualities");
            return new HashSet<Quality>();
        }
        return result;
    }

    @Override
    @NonNull
    public Quality getQuality() {
        Quality result = this.getQuality(this.player);
        if (result == null) {
            this.handleError("Unspecified", ErrorType.ERROR.getErrorCode(), 0, "Failed to retrieve quality");
            return new Quality("", "", 0, 0, 0, 0.0f);
        }
        return result;
    }

    @Override
    public void setQuality(final @NonNull Quality quality) {
        final Quality oldQuality = this.getQuality();
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (PlayerInternal.PlaybackListener listener : CorePlayerImpl.this.playbackListeners) {
                    listener.onSetQuality(oldQuality, quality, false);
                }
            }
        });
        this.setQuality(this.player, quality.getName(), false);
    }

    @Override
    public void setQuality(final @NonNull Quality quality, final boolean adaptive) {
        final Quality oldQuality = this.getQuality();
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (PlayerInternal.PlaybackListener listener : CorePlayerImpl.this.playbackListeners) {
                    listener.onSetQuality(oldQuality, quality, adaptive);
                }
            }
        });
        this.setQuality(this.player, quality.getName(), adaptive);
    }

    @Override
    @NonNull
    public Set<UnavailableQuality> getUnavailableQualities() {
        return this.getUnavailableQualities(this.player);
    }

    @Override
    public boolean isAutoQualityMode() {
        return this.isAutoQualityMode(this.player);
    }

    @Override
    public void setAutoQualityMode(final boolean enable) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (PlayerInternal.PlaybackListener listener : CorePlayerImpl.this.playbackListeners) {
                    listener.onSetAutoQualityMode(enable, false);
                }
            }
        });
        this.setAutoQualityMode(this.player, enable, false);
    }

    @Override
    public void setAutoQualityMode(final boolean enable, final boolean adaptive) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (PlayerInternal.PlaybackListener listener : CorePlayerImpl.this.playbackListeners) {
                    listener.onSetAutoQualityMode(enable, adaptive);
                }
            }
        });
        this.setAutoQualityMode(this.player, enable, adaptive);
    }

    @Override
    public void setAutoInitialBitrate(int bitrate) {
        this.setAutoInitialBitrate(this.player, bitrate);
    }

    @Override
    public void setAutoMaxBitrate(int bitrate) {
        this.setAutoMaxBitrate(this.player, bitrate);
    }

    @Override
    public void setAutoMaxVideoSize(int width, int height) {
        this.setAutoMaxVideoSize(this.player, width, height);
    }

    @Override
    public void setAutoMaxQuality(@NonNull Quality quality) {
        this.setAutoMaxQuality(this.player, quality);
    }

    @Override
    public boolean isLiveLowLatency() {
        return this.isLiveLowLatency(this.player);
    }

    @Override
    public void setLiveLowLatencyEnabled(boolean enabled) {
        this.setLiveLowLatencyEnabled(this.player, enabled);
    }

    @Override
    public void setRebufferToLive(boolean enable) {
        this.setRebufferToLive(this.player, enable);
    }

    @Override
    @NonNull
    public Statistics getStatistics() {
        this.getStatistics(this.player, this.statistics);
        return this.statistics;
    }

    @Override
    @NonNull
    public String getSessionId() {
        return this.getSessionId(this.player);
    }

    @Override
    @NonNull
    public String[] getChannelMetadata() {
        return this.getChannelMetadata(this.player);
    }

    @Override
    public void onSizeChange(final int width, final int height) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (Player.Listener listener : CorePlayerImpl.this.listeners) {
                    listener.onVideoSizeChanged(width, height);
                }
            }
        });
    }

    @Override
    public void setInitialBufferDuration(long duration) {
        this.setInitialBufferDuration(this.player, duration);
    }

    @Override
    public void setOrigin(@NonNull String origin) {
        this.setOrigin(this.player, origin);
    }

    @Override
    public void setNetworkRecoveryMode(Player.NetworkRecoveryMode mode) {
        this.setResumeAfterReconnect(this.player, Player.NetworkRecoveryMode.RESUME.equals((Object)mode));
    }

    @Override
    public String getPath() {
        return this.getPath(this.player);
    }

    @Override
    public String getProtocol() {
        return this.getProtocol(this.player);
    }

    @Override
    public void setAuthToken(String id) {
        this.setAuthToken(this.player, id);
    }

    @Override
    public void setClientId(String id) {
        this.setClientId(this.player, id);
    }

    @Override
    public void setDeviceId(String id) {
        this.setDeviceId(this.player, id);
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void setConfiguration(@NonNull String json) {
        this.setConfiguration(this.player, json);
    }

    @Override
    public Map<String, String> getExperiments() {
        return Experiments.getEntries();
    }

    @Override
    public void setExperiment(ExperimentData data) {
        this.setExperiment(this.player, data);
    }

    @Override
    public void setExperiments(ExperimentData[] data) {
        if (data != null) {
            for (ExperimentData exp : data) {
                this.setExperiment(this.player, exp);
            }
        }
    }

    @Override
    public void setUserAgent(@NonNull String userAgent) {
        this.setUserAgent(this.player, userAgent);
    }

    @Override
    public void setDrmEnabled(boolean enable) {
        Logging.d("setDrmEnabled " + enable);
        this.setDrmEnabled(this.player, enable);
    }

    @Override
    public float getMaxPlaybackRateForQuality(Quality quality) {
        return this.platform.getMaxPlaybackRateForQuality(quality);
    }

    private void setDisplaySize(int width, int height) {
        this.setDisplaySize(this.player, width, height);
    }

    @Nullable
    DeviceConfigPropertyHolder getDeviceConfigPropertyHolder() {
        return this.getDeviceConfigPropertyHolderImpl(this.player);
    }

    SuperResolution getSuperResolutionFeature() {
        return this.superRes;
    }

    ArrayList<IVSFeature<?>> getFeatures() {
        return this.features;
    }

    @Override
    public void onEvent(Object event) {
        if (event instanceof GPUAnalyticsEvent.GPUInitAnalyticsEvent) {
            this.onGpuInitEvent(this.player, (GPUAnalyticsEvent.GPUInitAnalyticsEvent)event);
        } else if (event instanceof GPUAnalyticsEvent.GPUStatusAnalyticsEvent) {
            this.onGpuStatusEvent(this.player, (GPUAnalyticsEvent.GPUStatusAnalyticsEvent)event);
        } else if (event instanceof GPUAnalyticsEvent.GPUErrorAnalyticsEvent) {
            this.onGpuErrorEvent(this.player, (GPUAnalyticsEvent.GPUErrorAnalyticsEvent)event);
        }
    }

    private ArrayList<IVSFeature<?>> addSupportedFeatures() {
        ArrayList features = new ArrayList();
        this.superRes = new SuperResolution();
        this.superRes.registerEventListener(this);
        features.add(this.superRes);
        features.add(new AnalyticsFeature());
        features.add(new ProbeV2Feature());
        return features;
    }

    static {
        try {
            System.loadLibrary("playercore");
        }
        catch (UnsatisfiedLinkError e) {
            Logging.e("Failed to load playercore", e);
        }
        CorePlayerImpl.initialize();
    }
}

