/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ivs.player;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class DeviceConfigStorage {
    private final Context mContext;
    private final String mDirectoryName;
    private final long mHandle;
    private static final String TAG = "DeviceConfig";
    private static final byte[] SIGNATURE = "ivs-gzip".getBytes(StandardCharsets.US_ASCII);

    DeviceConfigStorage(Context context, String directoryName, long handle) {
        this.mContext = context.getApplicationContext();
        this.mDirectoryName = directoryName;
        this.mHandle = handle;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    byte[] readFile(@NonNull String fileName) {
        File file = this.resolveFileName(fileName, true);
        if (file == null) {
            return null;
        }
        try (FileInputStream fileStream = new FileInputStream(file);){
            byte[] byArray;
            byte[] signature = new byte[SIGNATURE.length];
            if (fileStream.read(signature) != signature.length || !Arrays.equals(signature, SIGNATURE)) {
                throw new IOException("Invalid signature");
            }
            try (GZIPInputStream gzipStream = new GZIPInputStream(fileStream);){
                int r;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[16384];
                while ((r = gzipStream.read(buf)) > 0) {
                    bos.write(buf, 0, r);
                }
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException x) {
            Log.e((String)TAG, (String)("Cannot read file " + file), (Throwable)x);
            return null;
        }
    }

    boolean writeFile(@NonNull String fileName, @NonNull byte[] data) {
        File fileTemp = this.resolveFileName(fileName + "-temp-save", false);
        if (fileTemp == null) {
            return false;
        }
        File fileReal = this.resolveFileName(fileName, false);
        if (fileReal == null) {
            return false;
        }
        try (FileOutputStream fileStream = new FileOutputStream(fileTemp);){
            fileStream.write(SIGNATURE);
            try (GZIPOutputStream gzipStream = new GZIPOutputStream(fileStream);){
                gzipStream.write(data);
            }
        }
        catch (IOException x) {
            Log.e((String)TAG, (String)("Cannot read file " + fileTemp), (Throwable)x);
            return false;
        }
        return fileTemp.renameTo(fileReal);
    }

    boolean deleteFile(@NonNull String fileName) {
        File file = this.resolveFileName(fileName, true);
        return file.delete();
    }

    @Nullable
    private File resolveFileName(@NonNull String fileName, boolean isForReading) {
        File baseDir = this.mContext.getFilesDir();
        File fullDir = new File(baseDir, this.mDirectoryName);
        if (!fullDir.exists()) {
            if (isForReading) {
                return null;
            }
            fullDir.mkdirs();
        }
        return new File(fullDir, fileName);
    }
}

